/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSessionRequest extends LexRuntimeV2Request implements
        ToCopyableBuilder<PutSessionRequest.Builder, PutSessionRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(PutSessionRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(PutSessionRequest::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(PutSessionRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(PutSessionRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(PutSessionRequest::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.<SessionState> builder(MarshallingType.SDK_POJO)
            .memberName("sessionState").getter(getter(PutSessionRequest::sessionState)).setter(setter(Builder::sessionState))
            .constructor(SessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()).build();

    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requestAttributes")
            .getter(getter(PutSessionRequest::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESPONSE_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseContentType").getter(getter(PutSessionRequest::responseContentType))
            .setter(setter(Builder::responseContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ResponseContentType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, MESSAGES_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD,
            RESPONSE_CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("botId", BOT_ID_FIELD);
                    put("botAliasId", BOT_ALIAS_ID_FIELD);
                    put("localeId", LOCALE_ID_FIELD);
                    put("sessionId", SESSION_ID_FIELD);
                    put("messages", MESSAGES_FIELD);
                    put("sessionState", SESSION_STATE_FIELD);
                    put("requestAttributes", REQUEST_ATTRIBUTES_FIELD);
                    put("ResponseContentType", RESPONSE_CONTENT_TYPE_FIELD);
                }
            });

    private final String botId;

    private final String botAliasId;

    private final String localeId;

    private final String sessionId;

    private final List<Message> messages;

    private final SessionState sessionState;

    private final Map<String, String> requestAttributes;

    private final String responseContentType;

    private PutSessionRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.messages = builder.messages;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
        this.responseContentType = builder.responseContentType;
    }

    /**
     * <p>
     * The identifier of the bot that receives the session data.
     * </p>
     * 
     * @return The identifier of the bot that receives the session data.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The alias identifier of the bot that receives the session data.
     * </p>
     * 
     * @return The alias identifier of the bot that receives the session data.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The locale where the session is in use.
     * </p>
     * 
     * @return The locale where the session is in use.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The identifier of the session that receives the session data.
     * </p>
     * 
     * @return The identifier of the session that receives the session data.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of messages to send to the user. Messages are sent in the order that they are defined in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return A list of messages to send to the user. Messages are sent in the order that they are defined in the list.
     */
    public final List<Message> messages() {
        return messages;
    }

    /**
     * <p>
     * Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and
     * dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation
     * with the user.
     * </p>
     * 
     * @return Sets the state of the session with the user. You can use this to set the current intent, attributes,
     *         context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should
     *         use in the conversation with the user.
     */
    public final SessionState sessionState() {
        return sessionState;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestAttributes() {
        return requestAttributes != null && !(requestAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Request-specific information passed between Amazon Lex V2 and the client application.
     * </p>
     * <p>
     * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
     * with the prefix <code>x-amz-lex:</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestAttributes} method.
     * </p>
     * 
     * @return Request-specific information passed between Amazon Lex V2 and the client application.</p>
     *         <p>
     *         The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
     *         attributes with the prefix <code>x-amz-lex:</code>.
     */
    public final Map<String, String> requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * The message that Amazon Lex V2 returns in the response can be either text or speech depending on the value of
     * this parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2 returns text in the response.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The message that Amazon Lex V2 returns in the response can be either text or speech depending on the
     *         value of this parameter. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2 returns text in the response.
     *         </p>
     *         </li>
     */
    public final String responseContentType() {
        return responseContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestAttributes() ? requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseContentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionRequest)) {
            return false;
        }
        PutSessionRequest other = (PutSessionRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(sessionId(), other.sessionId())
                && hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && Objects.equals(sessionState(), other.sessionState()) && hasRequestAttributes() == other.hasRequestAttributes()
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(responseContentType(), other.responseContentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSessionRequest").add("BotId", botId()).add("BotAliasId", botAliasId())
                .add("LocaleId", localeId()).add("SessionId", sessionId()).add("Messages", hasMessages() ? messages() : null)
                .add("SessionState", sessionState())
                .add("RequestAttributes", hasRequestAttributes() ? requestAttributes() : null)
                .add("ResponseContentType", responseContentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "responseContentType":
            return Optional.ofNullable(clazz.cast(responseContentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutSessionRequest, T> g) {
        return obj -> g.apply((PutSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeV2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutSessionRequest> {
        /**
         * <p>
         * The identifier of the bot that receives the session data.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that receives the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The alias identifier of the bot that receives the session data.
         * </p>
         * 
         * @param botAliasId
         *        The alias identifier of the bot that receives the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The locale where the session is in use.
         * </p>
         * 
         * @param localeId
         *        The locale where the session is in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The identifier of the session that receives the session data.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session that receives the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * A list of messages to send to the user. Messages are sent in the order that they are defined in the list.
         * </p>
         * 
         * @param messages
         *        A list of messages to send to the user. Messages are sent in the order that they are defined in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * A list of messages to send to the user. Messages are sent in the order that they are defined in the list.
         * </p>
         * 
         * @param messages
         *        A list of messages to send to the user. Messages are sent in the order that they are defined in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * A list of messages to send to the user. Messages are sent in the order that they are defined in the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexruntimev2.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder#build()} is called immediately and
         * its result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        /**
         * <p>
         * Sets the state of the session with the user. You can use this to set the current intent, attributes, context,
         * and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the
         * conversation with the user.
         * </p>
         * 
         * @param sessionState
         *        Sets the state of the session with the user. You can use this to set the current intent, attributes,
         *        context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should
         *        use in the conversation with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(SessionState sessionState);

        /**
         * <p>
         * Sets the state of the session with the user. You can use this to set the current intent, attributes, context,
         * and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the
         * conversation with the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionState.Builder} avoiding the need
         * to create one manually via {@link SessionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionState(SessionState)}.
         * 
         * @param sessionState
         *        a consumer that will call methods on {@link SessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionState(SessionState)
         */
        default Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return sessionState(SessionState.builder().applyMutation(sessionState).build());
        }

        /**
         * <p>
         * Request-specific information passed between Amazon Lex V2 and the client application.
         * </p>
         * <p>
         * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
         * with the prefix <code>x-amz-lex:</code>.
         * </p>
         * 
         * @param requestAttributes
         *        Request-specific information passed between Amazon Lex V2 and the client application.</p>
         *        <p>
         *        The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
         *        attributes with the prefix <code>x-amz-lex:</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(Map<String, String> requestAttributes);

        /**
         * <p>
         * The message that Amazon Lex V2 returns in the response can be either text or speech depending on the value of
         * this parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2 returns text in the response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param responseContentType
         *        The message that Amazon Lex V2 returns in the response can be either text or speech depending on the
         *        value of this parameter. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2 returns text in the response.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseContentType(String responseContentType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String localeId;

        private String sessionId;

        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private SessionState sessionState;

        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String responseContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSessionRequest model) {
            super(model);
            botId(model.botId);
            botAliasId(model.botAliasId);
            localeId(model.localeId);
            sessionId(model.sessionId);
            messages(model.messages);
            sessionState(model.sessionState);
            requestAttributes(model.requestAttributes);
            responseContentType(model.responseContentType);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return sessionState != null ? sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final Map<String, String> getRequestAttributes() {
            if (requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final String getResponseContentType() {
            return responseContentType;
        }

        public final void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @Override
        public final Builder responseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSessionRequest build() {
            return new PutSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
