/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSessionResponse extends LexRuntimeV2Response implements
        ToCopyableBuilder<PutSessionResponse.Builder, PutSessionResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(PutSessionResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> MESSAGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messages").getter(getter(PutSessionResponse::messages)).setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-messages").build()).build();

    private static final SdkField<String> SESSION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionState").getter(getter(PutSessionResponse::sessionState)).setter(setter(Builder::sessionState))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-state").build())
            .build();

    private static final SdkField<String> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestAttributes")
            .getter(getter(PutSessionResponse::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-request-attributes")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(PutSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-id").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            MESSAGES_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD, SESSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Content-Type", CONTENT_TYPE_FIELD);
                    put("x-amz-lex-messages", MESSAGES_FIELD);
                    put("x-amz-lex-session-state", SESSION_STATE_FIELD);
                    put("x-amz-lex-request-attributes", REQUEST_ATTRIBUTES_FIELD);
                    put("x-amz-lex-session-id", SESSION_ID_FIELD);
                }
            });

    private final String contentType;

    private final String messages;

    private final String sessionState;

    private final String requestAttributes;

    private final String sessionId;

    private PutSessionResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.messages = builder.messages;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
        this.sessionId = builder.sessionId;
    }

    /**
     * <p>
     * The type of response. Same as the type specified in the <code>responseContentType</code> field in the request.
     * </p>
     * 
     * @return The type of response. Same as the type specified in the <code>responseContentType</code> field in the
     *         request.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A list of messages that were last sent to the user. The messages are ordered based on how you return the messages
     * from you Lambda function or the order that the messages are defined in the bot.
     * </p>
     * 
     * @return A list of messages that were last sent to the user. The messages are ordered based on how you return the
     *         messages from you Lambda function or the order that the messages are defined in the bot.
     */
    public final String messages() {
        return messages;
    }

    /**
     * <p>
     * A base-64-encoded gzipped field that represents the current state of the dialog between the user and the bot. Use
     * this to determine the progress of the conversation and what the next action may be.
     * </p>
     * 
     * @return A base-64-encoded gzipped field that represents the current state of the dialog between the user and the
     *         bot. Use this to determine the progress of the conversation and what the next action may be.
     */
    public final String sessionState() {
        return sessionState;
    }

    /**
     * <p>
     * A base-64-encoded gzipped field that provides request-specific information passed between the client application
     * and Amazon Lex V2. These are the same as the <code>requestAttribute</code> parameter in the call to the
     * <code>PutSession</code> operation.
     * </p>
     * 
     * @return A base-64-encoded gzipped field that provides request-specific information passed between the client
     *         application and Amazon Lex V2. These are the same as the <code>requestAttribute</code> parameter in the
     *         call to the <code>PutSession</code> operation.
     */
    public final String requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * The identifier of the session that received the data.
     * </p>
     * 
     * @return The identifier of the session that received the data.
     */
    public final String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(messages());
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionResponse)) {
            return false;
        }
        PutSessionResponse other = (PutSessionResponse) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(messages(), other.messages())
                && Objects.equals(sessionState(), other.sessionState())
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(sessionId(), other.sessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSessionResponse").add("ContentType", contentType()).add("Messages", messages())
                .add("SessionState", sessionState()).add("RequestAttributes", requestAttributes()).add("SessionId", sessionId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutSessionResponse, T> g) {
        return obj -> g.apply((PutSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeV2Response.Builder, SdkPojo, CopyableBuilder<Builder, PutSessionResponse> {
        /**
         * <p>
         * The type of response. Same as the type specified in the <code>responseContentType</code> field in the
         * request.
         * </p>
         * 
         * @param contentType
         *        The type of response. Same as the type specified in the <code>responseContentType</code> field in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A list of messages that were last sent to the user. The messages are ordered based on how you return the
         * messages from you Lambda function or the order that the messages are defined in the bot.
         * </p>
         * 
         * @param messages
         *        A list of messages that were last sent to the user. The messages are ordered based on how you return
         *        the messages from you Lambda function or the order that the messages are defined in the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(String messages);

        /**
         * <p>
         * A base-64-encoded gzipped field that represents the current state of the dialog between the user and the bot.
         * Use this to determine the progress of the conversation and what the next action may be.
         * </p>
         * 
         * @param sessionState
         *        A base-64-encoded gzipped field that represents the current state of the dialog between the user and
         *        the bot. Use this to determine the progress of the conversation and what the next action may be.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(String sessionState);

        /**
         * <p>
         * A base-64-encoded gzipped field that provides request-specific information passed between the client
         * application and Amazon Lex V2. These are the same as the <code>requestAttribute</code> parameter in the call
         * to the <code>PutSession</code> operation.
         * </p>
         * 
         * @param requestAttributes
         *        A base-64-encoded gzipped field that provides request-specific information passed between the client
         *        application and Amazon Lex V2. These are the same as the <code>requestAttribute</code> parameter in
         *        the call to the <code>PutSession</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(String requestAttributes);

        /**
         * <p>
         * The identifier of the session that received the data.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session that received the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);
    }

    static final class BuilderImpl extends LexRuntimeV2Response.BuilderImpl implements Builder {
        private String contentType;

        private String messages;

        private String sessionState;

        private String requestAttributes;

        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSessionResponse model) {
            super(model);
            contentType(model.contentType);
            messages(model.messages);
            sessionState(model.sessionState);
            requestAttributes(model.requestAttributes);
            sessionId(model.sessionId);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getMessages() {
            return messages;
        }

        public final void setMessages(String messages) {
            this.messages = messages;
        }

        @Override
        public final Builder messages(String messages) {
            this.messages = messages;
            return this;
        }

        public final String getSessionState() {
            return sessionState;
        }

        public final void setSessionState(String sessionState) {
            this.sessionState = sessionState;
        }

        @Override
        public final Builder sessionState(String sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getRequestAttributes() {
            return requestAttributes;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        @Override
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public PutSessionResponse build() {
            return new PutSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
