/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The bot member that processes the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecognizedBotMember implements SdkPojo, Serializable,
        ToCopyableBuilder<RecognizedBotMember.Builder, RecognizedBotMember> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(RecognizedBotMember::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(RecognizedBotMember::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("botId", BOT_ID_FIELD);
                    put("botName", BOT_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String botId;

    private final String botName;

    private RecognizedBotMember(BuilderImpl builder) {
        this.botId = builder.botId;
        this.botName = builder.botName;
    }

    /**
     * <p>
     * The identifier of the bot member that processes the request.
     * </p>
     * 
     * @return The identifier of the bot member that processes the request.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The name of the bot member that processes the request.
     * </p>
     * 
     * @return The name of the bot member that processes the request.
     */
    public final String botName() {
        return botName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizedBotMember)) {
            return false;
        }
        RecognizedBotMember other = (RecognizedBotMember) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botName(), other.botName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecognizedBotMember").add("BotId", botId()).add("BotName", botName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecognizedBotMember, T> g) {
        return obj -> g.apply((RecognizedBotMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecognizedBotMember> {
        /**
         * <p>
         * The identifier of the bot member that processes the request.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot member that processes the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The name of the bot member that processes the request.
         * </p>
         * 
         * @param botName
         *        The name of the bot member that processes the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);
    }

    static final class BuilderImpl implements Builder {
        private String botId;

        private String botName;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizedBotMember model) {
            botId(model.botId);
            botName(model.botName);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        @Override
        public RecognizedBotMember build() {
            return new RecognizedBotMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
