/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A notification from the client that it is disconnecting from Amazon Lex V2. Sending a <code>DisconnectionEvent</code>
 * event is optional, but can help identify a conversation in logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DisconnectionEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<DisconnectionEvent.Builder, DisconnectionEvent>, StartConversationRequestEventStream {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(DisconnectionEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<Long> CLIENT_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("clientTimestampMillis").getter(getter(DisconnectionEvent::clientTimestampMillis))
            .setter(setter(Builder::clientTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientTimestampMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            CLIENT_TIMESTAMP_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final Long clientTimestampMillis;

    protected DisconnectionEvent(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.clientTimestampMillis = builder.clientTimestampMillis;
    }

    /**
     * <p>
     * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
     * </p>
     * 
     * @return A unique identifier that your application assigns to the event. You can use this to identify events in
     *         logs.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     * </p>
     * 
     * @return A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     */
    public final Long clientTimestampMillis() {
        return clientTimestampMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(clientTimestampMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectionEvent)) {
            return false;
        }
        DisconnectionEvent other = (DisconnectionEvent) obj;
        return Objects.equals(eventId(), other.eventId())
                && Objects.equals(clientTimestampMillis(), other.clientTimestampMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisconnectionEvent").add("EventId", eventId())
                .add("ClientTimestampMillis", clientTimestampMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "clientTimestampMillis":
            return Optional.ofNullable(clazz.cast(clientTimestampMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final DisconnectionEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventId", EVENT_ID_FIELD);
        map.put("clientTimestampMillis", CLIENT_TIMESTAMP_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisconnectionEvent, T> g) {
        return obj -> g.apply((DisconnectionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisconnectionEvent> {
        /**
         * <p>
         * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
         * </p>
         * 
         * @param eventId
         *        A unique identifier that your application assigns to the event. You can use this to identify events in
         *        logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * </p>
         * 
         * @param clientTimestampMillis
         *        A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientTimestampMillis(Long clientTimestampMillis);
    }

    protected static class BuilderImpl implements Builder {
        private String eventId;

        private Long clientTimestampMillis;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DisconnectionEvent model) {
            eventId(model.eventId);
            clientTimestampMillis(model.clientTimestampMillis);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Long getClientTimestampMillis() {
            return clientTimestampMillis;
        }

        public final void setClientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
        }

        @Override
        public final Builder clientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
            return this;
        }

        @Override
        public DisconnectionEvent build() {
            return new DisconnectionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
