/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a chunk of audio sent from the client application to Amazon Lex V2. The audio is all or part of an
 * utterance from the user.
 * </p>
 * <p>
 * Amazon Lex V2 accumulates audio chunks until it recognizes a natural pause in speech before processing the input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AudioInputEvent implements SdkPojo, Serializable, ToCopyableBuilder<AudioInputEvent.Builder, AudioInputEvent>,
        StartConversationRequestEventStream {
    private static final SdkField<SdkBytes> AUDIO_CHUNK_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("audioChunk").getter(getter(AudioInputEvent::audioChunk)).setter(setter(Builder::audioChunk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChunk").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(AudioInputEvent::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(AudioInputEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<Long> CLIENT_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("clientTimestampMillis").getter(getter(AudioInputEvent::clientTimestampMillis))
            .setter(setter(Builder::clientTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientTimestampMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CHUNK_FIELD,
            CONTENT_TYPE_FIELD, EVENT_ID_FIELD, CLIENT_TIMESTAMP_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes audioChunk;

    private final String contentType;

    private final String eventId;

    private final Long clientTimestampMillis;

    protected AudioInputEvent(BuilderImpl builder) {
        this.audioChunk = builder.audioChunk;
        this.contentType = builder.contentType;
        this.eventId = builder.eventId;
        this.clientTimestampMillis = builder.clientTimestampMillis;
    }

    /**
     * <p>
     * An encoded stream of audio.
     * </p>
     * 
     * @return An encoded stream of audio.
     */
    public final SdkBytes audioChunk() {
        return audioChunk;
    }

    /**
     * <p>
     * The encoding used for the audio chunk. You must use 8 KHz PCM 16-bit mono-channel little-endian format. The value
     * of the field should be:
     * </p>
     * <p>
     * <code>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false</code>
     * </p>
     * 
     * @return The encoding used for the audio chunk. You must use 8 KHz PCM 16-bit mono-channel little-endian format.
     *         The value of the field should be:</p>
     *         <p>
     *         <code>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false</code>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
     * </p>
     * 
     * @return A unique identifier that your application assigns to the event. You can use this to identify events in
     *         logs.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     * </p>
     * 
     * @return A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     */
    public final Long clientTimestampMillis() {
        return clientTimestampMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioChunk());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(clientTimestampMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioInputEvent)) {
            return false;
        }
        AudioInputEvent other = (AudioInputEvent) obj;
        return Objects.equals(audioChunk(), other.audioChunk()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(eventId(), other.eventId())
                && Objects.equals(clientTimestampMillis(), other.clientTimestampMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioInputEvent").add("AudioChunk", audioChunk()).add("ContentType", contentType())
                .add("EventId", eventId()).add("ClientTimestampMillis", clientTimestampMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audioChunk":
            return Optional.ofNullable(clazz.cast(audioChunk()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "clientTimestampMillis":
            return Optional.ofNullable(clazz.cast(clientTimestampMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final AudioInputEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioChunk", AUDIO_CHUNK_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("clientTimestampMillis", CLIENT_TIMESTAMP_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioInputEvent, T> g) {
        return obj -> g.apply((AudioInputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioInputEvent> {
        /**
         * <p>
         * An encoded stream of audio.
         * </p>
         * 
         * @param audioChunk
         *        An encoded stream of audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChunk(SdkBytes audioChunk);

        /**
         * <p>
         * The encoding used for the audio chunk. You must use 8 KHz PCM 16-bit mono-channel little-endian format. The
         * value of the field should be:
         * </p>
         * <p>
         * <code>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false</code>
         * </p>
         * 
         * @param contentType
         *        The encoding used for the audio chunk. You must use 8 KHz PCM 16-bit mono-channel little-endian
         *        format. The value of the field should be:</p>
         *        <p>
         *        <code>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
         * </p>
         * 
         * @param eventId
         *        A unique identifier that your application assigns to the event. You can use this to identify events in
         *        logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * </p>
         * 
         * @param clientTimestampMillis
         *        A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientTimestampMillis(Long clientTimestampMillis);
    }

    protected static class BuilderImpl implements Builder {
        private SdkBytes audioChunk;

        private String contentType;

        private String eventId;

        private Long clientTimestampMillis;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AudioInputEvent model) {
            audioChunk(model.audioChunk);
            contentType(model.contentType);
            eventId(model.eventId);
            clientTimestampMillis(model.clientTimestampMillis);
        }

        public final ByteBuffer getAudioChunk() {
            return audioChunk == null ? null : audioChunk.asByteBuffer();
        }

        public final void setAudioChunk(ByteBuffer audioChunk) {
            audioChunk(audioChunk == null ? null : SdkBytes.fromByteBuffer(audioChunk));
        }

        @Override
        public final Builder audioChunk(SdkBytes audioChunk) {
            this.audioChunk = audioChunk;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Long getClientTimestampMillis() {
            return clientTimestampMillis;
        }

        public final void setClientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
        }

        @Override
        public final Builder clientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
            return this;
        }

        @Override
        public AudioInputEvent build() {
            return new AudioInputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
