/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Event sent from Amazon Lex V2 to indicate to the client application should stop playback of audio. For example, if
 * the client is playing a prompt that asks for the user's telephone number, the user might start to say the phone
 * number before the prompt is complete. Amazon Lex V2 sends this event to the client application to indicate that the
 * user is responding and that Amazon Lex V2 is processing their input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PlaybackInterruptionEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<PlaybackInterruptionEvent.Builder, PlaybackInterruptionEvent>, StartConversationResponseEventStream {
    private static final SdkField<String> EVENT_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventReason").getter(getter(PlaybackInterruptionEvent::eventReasonAsString))
            .setter(setter(Builder::eventReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventReason").build()).build();

    private static final SdkField<String> CAUSED_BY_EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("causedByEventId").getter(getter(PlaybackInterruptionEvent::causedByEventId))
            .setter(setter(Builder::causedByEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("causedByEventId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(PlaybackInterruptionEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_REASON_FIELD,
            CAUSED_BY_EVENT_ID_FIELD, EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventReason;

    private final String causedByEventId;

    private final String eventId;

    protected PlaybackInterruptionEvent(BuilderImpl builder) {
        this.eventReason = builder.eventReason;
        this.causedByEventId = builder.causedByEventId;
        this.eventId = builder.eventId;
    }

    /**
     * <p>
     * Indicates the type of user input that Amazon Lex V2 detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventReason} will
     * return {@link PlaybackInterruptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventReasonAsString}.
     * </p>
     * 
     * @return Indicates the type of user input that Amazon Lex V2 detected.
     * @see PlaybackInterruptionReason
     */
    public final PlaybackInterruptionReason eventReason() {
        return PlaybackInterruptionReason.fromValue(eventReason);
    }

    /**
     * <p>
     * Indicates the type of user input that Amazon Lex V2 detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventReason} will
     * return {@link PlaybackInterruptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventReasonAsString}.
     * </p>
     * 
     * @return Indicates the type of user input that Amazon Lex V2 detected.
     * @see PlaybackInterruptionReason
     */
    public final String eventReasonAsString() {
        return eventReason;
    }

    /**
     * <p>
     * The identifier of the event that contained the audio, DTMF, or text that caused the interruption.
     * </p>
     * 
     * @return The identifier of the event that contained the audio, DTMF, or text that caused the interruption.
     */
    public final String causedByEventId() {
        return causedByEventId;
    }

    /**
     * <p>
     * A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form <code>RESPONSE-N</code>,
     * where N is a number starting with one and incremented for each event sent by Amazon Lex V2 in the current
     * session.
     * </p>
     * 
     * @return A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form
     *         <code>RESPONSE-N</code>, where N is a number starting with one and incremented for each event sent by
     *         Amazon Lex V2 in the current session.
     */
    public final String eventId() {
        return eventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(causedByEventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaybackInterruptionEvent)) {
            return false;
        }
        PlaybackInterruptionEvent other = (PlaybackInterruptionEvent) obj;
        return Objects.equals(eventReasonAsString(), other.eventReasonAsString())
                && Objects.equals(causedByEventId(), other.causedByEventId()) && Objects.equals(eventId(), other.eventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlaybackInterruptionEvent").add("EventReason", eventReasonAsString())
                .add("CausedByEventId", causedByEventId()).add("EventId", eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventReason":
            return Optional.ofNullable(clazz.cast(eventReasonAsString()));
        case "causedByEventId":
            return Optional.ofNullable(clazz.cast(causedByEventId()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final PlaybackInterruptionEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventReason", EVENT_REASON_FIELD);
        map.put("causedByEventId", CAUSED_BY_EVENT_ID_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlaybackInterruptionEvent, T> g) {
        return obj -> g.apply((PlaybackInterruptionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link PlaybackInterruptionEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartConversationResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlaybackInterruptionEvent> {
        /**
         * <p>
         * Indicates the type of user input that Amazon Lex V2 detected.
         * </p>
         * 
         * @param eventReason
         *        Indicates the type of user input that Amazon Lex V2 detected.
         * @see PlaybackInterruptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaybackInterruptionReason
         */
        Builder eventReason(String eventReason);

        /**
         * <p>
         * Indicates the type of user input that Amazon Lex V2 detected.
         * </p>
         * 
         * @param eventReason
         *        Indicates the type of user input that Amazon Lex V2 detected.
         * @see PlaybackInterruptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaybackInterruptionReason
         */
        Builder eventReason(PlaybackInterruptionReason eventReason);

        /**
         * <p>
         * The identifier of the event that contained the audio, DTMF, or text that caused the interruption.
         * </p>
         * 
         * @param causedByEventId
         *        The identifier of the event that contained the audio, DTMF, or text that caused the interruption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causedByEventId(String causedByEventId);

        /**
         * <p>
         * A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form <code>RESPONSE-N</code>
         * , where N is a number starting with one and incremented for each event sent by Amazon Lex V2 in the current
         * session.
         * </p>
         * 
         * @param eventId
         *        A unique identifier of the event sent by Amazon Lex V2. The identifier is in the form
         *        <code>RESPONSE-N</code>, where N is a number starting with one and incremented for each event sent by
         *        Amazon Lex V2 in the current session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);
    }

    protected static class BuilderImpl implements Builder {
        private String eventReason;

        private String causedByEventId;

        private String eventId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(PlaybackInterruptionEvent model) {
            eventReason(model.eventReason);
            causedByEventId(model.causedByEventId);
            eventId(model.eventId);
        }

        public final String getEventReason() {
            return eventReason;
        }

        public final void setEventReason(String eventReason) {
            this.eventReason = eventReason;
        }

        @Override
        public final Builder eventReason(String eventReason) {
            this.eventReason = eventReason;
            return this;
        }

        @Override
        public final Builder eventReason(PlaybackInterruptionReason eventReason) {
            this.eventReason(eventReason == null ? null : eventReason.toString());
            return this;
        }

        public final String getCausedByEventId() {
            return causedByEventId;
        }

        public final void setCausedByEventId(String causedByEventId) {
            this.causedByEventId = causedByEventId;
        }

        @Override
        public final Builder causedByEventId(String causedByEventId) {
            this.causedByEventId = causedByEventId;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        public PlaybackInterruptionEvent build() {
            return new PlaybackInterruptionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
