/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecognizeUtteranceRequest extends LexRuntimeV2Request implements
        ToCopyableBuilder<RecognizeUtteranceRequest.Builder, RecognizeUtteranceRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(RecognizeUtteranceRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(RecognizeUtteranceRequest::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(RecognizeUtteranceRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(RecognizeUtteranceRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> SESSION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionState").getter(getter(RecognizeUtteranceRequest::sessionState))
            .setter(setter(Builder::sessionState))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-state").build())
            .build();

    private static final SdkField<String> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestAttributes")
            .getter(getter(RecognizeUtteranceRequest::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-request-attributes")
                    .build()).build();

    private static final SdkField<String> REQUEST_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestContentType").getter(getter(RecognizeUtteranceRequest::requestContentType))
            .setter(setter(Builder::requestContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> RESPONSE_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseContentType").getter(getter(RecognizeUtteranceRequest::responseContentType))
            .setter(setter(Builder::responseContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Response-Content-Type").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD,
            REQUEST_CONTENT_TYPE_FIELD, RESPONSE_CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botAliasId;

    private final String localeId;

    private final String sessionId;

    private final String sessionState;

    private final String requestAttributes;

    private final String requestContentType;

    private final String responseContentType;

    private RecognizeUtteranceRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
        this.requestContentType = builder.requestContentType;
        this.responseContentType = builder.responseContentType;
    }

    /**
     * <p>
     * The identifier of the bot that should receive the request.
     * </p>
     * 
     * @return The identifier of the bot that should receive the request.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The alias identifier in use for the bot that should receive the request.
     * </p>
     * 
     * @return The alias identifier in use for the bot that should receive the request.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The locale where the session is in use.
     * </p>
     * 
     * @return The locale where the session is in use.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The identifier of the session in use.
     * </p>
     * 
     * @return The identifier of the session in use.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and
     * dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation
     * with the user.
     * </p>
     * <p>
     * The <code>sessionState</code> field must be compressed using gzip and then base64 encoded before sending to
     * Amazon Lex V2.
     * </p>
     * 
     * @return Sets the state of the session with the user. You can use this to set the current intent, attributes,
     *         context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should
     *         use in the conversation with the user.</p>
     *         <p>
     *         The <code>sessionState</code> field must be compressed using gzip and then base64 encoded before sending
     *         to Amazon Lex V2.
     */
    public final String sessionState() {
        return sessionState;
    }

    /**
     * <p>
     * Request-specific information passed between the client application and Amazon Lex V2
     * </p>
     * <p>
     * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes for
     * prefix <code>x-amz-lex:</code>.
     * </p>
     * <p>
     * The <code>requestAttributes</code> field must be compressed using gzip and then base64 encoded before sending to
     * Amazon Lex V2.
     * </p>
     * 
     * @return Request-specific information passed between the client application and Amazon Lex V2 </p>
     *         <p>
     *         The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
     *         attributes for prefix <code>x-amz-lex:</code>.
     *         </p>
     *         <p>
     *         The <code>requestAttributes</code> field must be compressed using gzip and then base64 encoded before
     *         sending to Amazon Lex V2.
     */
    public final String requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * Indicates the format for audio input or that the content is text. The header must start with one of the following
     * prefixes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PCM format, audio data must be in little-endian byte order.
     * </p>
     * <ul>
     * <li>
     * <p>
     * audio/l16; rate=16000; channels=1
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/x-l16; sample-rate=16000; channel-count=1
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Opus format
     * </p>
     * <ul>
     * <li>
     * <p>
     * audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Text format
     * </p>
     * <ul>
     * <li>
     * <p>
     * text/plain; charset=utf-8
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return Indicates the format for audio input or that the content is text. The header must start with one of the
     *         following prefixes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PCM format, audio data must be in little-endian byte order.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         audio/l16; rate=16000; channels=1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/x-l16; sample-rate=16000; channel-count=1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Opus format
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Text format
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         text/plain; charset=utf-8
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String requestContentType() {
        return requestContentType;
    }

    /**
     * <p>
     * The message that Amazon Lex V2 returns in the response can be either text or speech based on the
     * <code>responseContentType</code> value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex V2 uses
     * Amazon Polly to generate the speech using the configuration that you specified in the
     * <code>responseContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the value,
     * Amazon Lex V2 returns speech in the MPEG format.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> at 16 KHz in 16-bit,
     * little-endian format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The following are the accepted values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * audio/mpeg
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/ogg
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/pcm (16 KHz)
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/* (defaults to mpeg)
     * </p>
     * </li>
     * <li>
     * <p>
     * text/plain; charset=utf-8
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The message that Amazon Lex V2 returns in the response can be either text or speech based on the
     *         <code>responseContentType</code> value.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex V2
     *         uses Amazon Polly to generate the speech using the configuration that you specified in the
     *         <code>responseContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the
     *         value, Amazon Lex V2 returns speech in the MPEG format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> at 16 KHz in
     *         16-bit, little-endian format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The following are the accepted values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         audio/mpeg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/ogg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/pcm (16 KHz)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/* (defaults to mpeg)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         text/plain; charset=utf-8
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String responseContentType() {
        return responseContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(requestContentType());
        hashCode = 31 * hashCode + Objects.hashCode(responseContentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeUtteranceRequest)) {
            return false;
        }
        RecognizeUtteranceRequest other = (RecognizeUtteranceRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(sessionState(), other.sessionState())
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(requestContentType(), other.requestContentType())
                && Objects.equals(responseContentType(), other.responseContentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecognizeUtteranceRequest").add("BotId", botId()).add("BotAliasId", botAliasId())
                .add("LocaleId", localeId()).add("SessionId", sessionId())
                .add("SessionState", sessionState() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RequestAttributes", requestAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RequestContentType", requestContentType()).add("ResponseContentType", responseContentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "requestContentType":
            return Optional.ofNullable(clazz.cast(requestContentType()));
        case "responseContentType":
            return Optional.ofNullable(clazz.cast(responseContentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("x-amz-lex-session-state", SESSION_STATE_FIELD);
        map.put("x-amz-lex-request-attributes", REQUEST_ATTRIBUTES_FIELD);
        map.put("Content-Type", REQUEST_CONTENT_TYPE_FIELD);
        map.put("Response-Content-Type", RESPONSE_CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecognizeUtteranceRequest, T> g) {
        return obj -> g.apply((RecognizeUtteranceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexRuntimeV2Request.Builder, SdkPojo, CopyableBuilder<Builder, RecognizeUtteranceRequest> {
        /**
         * <p>
         * The identifier of the bot that should receive the request.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that should receive the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The alias identifier in use for the bot that should receive the request.
         * </p>
         * 
         * @param botAliasId
         *        The alias identifier in use for the bot that should receive the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The locale where the session is in use.
         * </p>
         * 
         * @param localeId
         *        The locale where the session is in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The identifier of the session in use.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Sets the state of the session with the user. You can use this to set the current intent, attributes, context,
         * and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the
         * conversation with the user.
         * </p>
         * <p>
         * The <code>sessionState</code> field must be compressed using gzip and then base64 encoded before sending to
         * Amazon Lex V2.
         * </p>
         * 
         * @param sessionState
         *        Sets the state of the session with the user. You can use this to set the current intent, attributes,
         *        context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should
         *        use in the conversation with the user.</p>
         *        <p>
         *        The <code>sessionState</code> field must be compressed using gzip and then base64 encoded before
         *        sending to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(String sessionState);

        /**
         * <p>
         * Request-specific information passed between the client application and Amazon Lex V2
         * </p>
         * <p>
         * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
         * for prefix <code>x-amz-lex:</code>.
         * </p>
         * <p>
         * The <code>requestAttributes</code> field must be compressed using gzip and then base64 encoded before sending
         * to Amazon Lex V2.
         * </p>
         * 
         * @param requestAttributes
         *        Request-specific information passed between the client application and Amazon Lex V2 </p>
         *        <p>
         *        The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
         *        attributes for prefix <code>x-amz-lex:</code>.
         *        </p>
         *        <p>
         *        The <code>requestAttributes</code> field must be compressed using gzip and then base64 encoded before
         *        sending to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(String requestAttributes);

        /**
         * <p>
         * Indicates the format for audio input or that the content is text. The header must start with one of the
         * following prefixes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PCM format, audio data must be in little-endian byte order.
         * </p>
         * <ul>
         * <li>
         * <p>
         * audio/l16; rate=16000; channels=1
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/x-l16; sample-rate=16000; channel-count=1
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Opus format
         * </p>
         * <ul>
         * <li>
         * <p>
         * audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Text format
         * </p>
         * <ul>
         * <li>
         * <p>
         * text/plain; charset=utf-8
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param requestContentType
         *        Indicates the format for audio input or that the content is text. The header must start with one of
         *        the following prefixes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PCM format, audio data must be in little-endian byte order.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        audio/l16; rate=16000; channels=1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/x-l16; sample-rate=16000; channel-count=1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Opus format
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Text format
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        text/plain; charset=utf-8
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestContentType(String requestContentType);

        /**
         * <p>
         * The message that Amazon Lex V2 returns in the response can be either text or speech based on the
         * <code>responseContentType</code> value.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex V2
         * uses Amazon Polly to generate the speech using the configuration that you specified in the
         * <code>responseContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the value,
         * Amazon Lex V2 returns speech in the MPEG format.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> at 16 KHz in 16-bit,
         * little-endian format.
         * </p>
         * </li>
         * <li>
         * <p>
         * The following are the accepted values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * audio/mpeg
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/ogg
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/pcm (16 KHz)
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/* (defaults to mpeg)
         * </p>
         * </li>
         * <li>
         * <p>
         * text/plain; charset=utf-8
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param responseContentType
         *        The message that Amazon Lex V2 returns in the response can be either text or speech based on the
         *        <code>responseContentType</code> value.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex
         *        V2 uses Amazon Polly to generate the speech using the configuration that you specified in the
         *        <code>responseContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the
         *        value, Amazon Lex V2 returns speech in the MPEG format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> at 16 KHz in
         *        16-bit, little-endian format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The following are the accepted values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        audio/mpeg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/ogg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/pcm (16 KHz)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/* (defaults to mpeg)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        text/plain; charset=utf-8
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseContentType(String responseContentType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String localeId;

        private String sessionId;

        private String sessionState;

        private String requestAttributes;

        private String requestContentType;

        private String responseContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeUtteranceRequest model) {
            super(model);
            botId(model.botId);
            botAliasId(model.botAliasId);
            localeId(model.localeId);
            sessionId(model.sessionId);
            sessionState(model.sessionState);
            requestAttributes(model.requestAttributes);
            requestContentType(model.requestContentType);
            responseContentType(model.responseContentType);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionState() {
            return sessionState;
        }

        public final void setSessionState(String sessionState) {
            this.sessionState = sessionState;
        }

        @Override
        public final Builder sessionState(String sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getRequestAttributes() {
            return requestAttributes;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        @Override
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final String getRequestContentType() {
            return requestContentType;
        }

        public final void setRequestContentType(String requestContentType) {
            this.requestContentType = requestContentType;
        }

        @Override
        public final Builder requestContentType(String requestContentType) {
            this.requestContentType = requestContentType;
            return this;
        }

        public final String getResponseContentType() {
            return responseContentType;
        }

        public final void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @Override
        public final Builder responseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RecognizeUtteranceRequest build() {
            return new RecognizeUtteranceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
