/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A value that Amazon Lex V2 uses to fulfill an intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Slot implements SdkPojo, Serializable, ToCopyableBuilder<Slot.Builder, Slot> {
    private static final SdkField<Value> VALUE_FIELD = SdkField.<Value> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(Slot::value)).setter(setter(Builder::value)).constructor(Value::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shape")
            .getter(getter(Slot::shapeAsString)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()).build();

    private static final SdkField<List<Slot>> VALUES_FIELD = SdkField
            .<List<Slot>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(Slot::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Slot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Slot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Slot>> SUB_SLOTS_FIELD = SdkField
            .<Map<String, Slot>> builder(MarshallingType.MAP)
            .memberName("subSlots")
            .getter(getter(Slot::subSlots))
            .setter(setter(Builder::subSlots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlots").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Slot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Slot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, SHAPE_FIELD,
            VALUES_FIELD, SUB_SLOTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Value value;

    private final String shape;

    private final List<Slot> values;

    private final Map<String, Slot> subSlots;

    private Slot(BuilderImpl builder) {
        this.value = builder.value;
        this.shape = builder.shape;
        this.values = builder.values;
        this.subSlots = builder.subSlots;
    }

    /**
     * <p>
     * The current value of the slot.
     * </p>
     * 
     * @return The current value of the slot.
     */
    public final Value value() {
        return value;
    }

    /**
     * <p>
     * When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code> field contains
     * a list of slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code> field
     * contains a single value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shape} will return
     * {@link Shape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeAsString}.
     * </p>
     * 
     * @return When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code> field
     *         contains a list of slot values. When the value is <code>Scalar</code>, it indicates that the
     *         <code>value</code> field contains a single value.
     * @see Shape
     */
    public final Shape shape() {
        return Shape.fromValue(shape);
    }

    /**
     * <p>
     * When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code> field contains
     * a list of slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code> field
     * contains a single value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shape} will return
     * {@link Shape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeAsString}.
     * </p>
     * 
     * @return When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code> field
     *         contains a list of slot values. When the value is <code>Scalar</code>, it indicates that the
     *         <code>value</code> field contains a single value.
     * @see Shape
     */
    public final String shapeAsString() {
        return shape;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more values that the user provided for the slot. For example, if a for a slot that elicits pizza
     * toppings, the values might be "pepperoni" and "pineapple."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of one or more values that the user provided for the slot. For example, if a for a slot that
     *         elicits pizza toppings, the values might be "pepperoni" and "pineapple."
     */
    public final List<Slot> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubSlots property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubSlots() {
        return subSlots != null && !(subSlots instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The constituent sub slots of a composite slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubSlots} method.
     * </p>
     * 
     * @return The constituent sub slots of a composite slot.
     */
    public final Map<String, Slot> subSlots() {
        return subSlots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(shapeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubSlots() ? subSlots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(shapeAsString(), other.shapeAsString())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && hasSubSlots() == other.hasSubSlots() && Objects.equals(subSlots(), other.subSlots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Slot").add("Value", value()).add("Shape", shapeAsString())
                .add("Values", hasValues() ? values() : null).add("SubSlots", hasSubSlots() ? subSlots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "shape":
            return Optional.ofNullable(clazz.cast(shapeAsString()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "subSlots":
            return Optional.ofNullable(clazz.cast(subSlots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("values", VALUES_FIELD);
        map.put("subSlots", SUB_SLOTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Slot, T> g) {
        return obj -> g.apply((Slot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Slot> {
        /**
         * <p>
         * The current value of the slot.
         * </p>
         * 
         * @param value
         *        The current value of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Value value);

        /**
         * <p>
         * The current value of the slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link Value.Builder} avoiding the need to
         * create one manually via {@link Value#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Value.Builder#build()} is called immediately and its result is
         * passed to {@link #value(Value)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link Value.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(Value)
         */
        default Builder value(Consumer<Value.Builder> value) {
            return value(Value.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code> field
         * contains a list of slot values. When the value is <code>Scalar</code>, it indicates that the
         * <code>value</code> field contains a single value.
         * </p>
         * 
         * @param shape
         *        When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code>
         *        field contains a list of slot values. When the value is <code>Scalar</code>, it indicates that the
         *        <code>value</code> field contains a single value.
         * @see Shape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Shape
         */
        Builder shape(String shape);

        /**
         * <p>
         * When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code> field
         * contains a list of slot values. When the value is <code>Scalar</code>, it indicates that the
         * <code>value</code> field contains a single value.
         * </p>
         * 
         * @param shape
         *        When the <code>shape</code> value is <code>List</code>, it indicates that the <code>values</code>
         *        field contains a list of slot values. When the value is <code>Scalar</code>, it indicates that the
         *        <code>value</code> field contains a single value.
         * @see Shape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Shape
         */
        Builder shape(Shape shape);

        /**
         * <p>
         * A list of one or more values that the user provided for the slot. For example, if a for a slot that elicits
         * pizza toppings, the values might be "pepperoni" and "pineapple."
         * </p>
         * 
         * @param values
         *        A list of one or more values that the user provided for the slot. For example, if a for a slot that
         *        elicits pizza toppings, the values might be "pepperoni" and "pineapple."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<Slot> values);

        /**
         * <p>
         * A list of one or more values that the user provided for the slot. For example, if a for a slot that elicits
         * pizza toppings, the values might be "pepperoni" and "pineapple."
         * </p>
         * 
         * @param values
         *        A list of one or more values that the user provided for the slot. For example, if a for a slot that
         *        elicits pizza toppings, the values might be "pepperoni" and "pineapple."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Slot... values);

        /**
         * <p>
         * A list of one or more values that the user provided for the slot. For example, if a for a slot that elicits
         * pizza toppings, the values might be "pepperoni" and "pineapple."
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Slot.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexruntimev2.model.Slot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Slot.Builder#build()} is called immediately and its
         * result is passed to {@link #values(List<Slot>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexruntimev2.model.Slot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<Slot>)
         */
        Builder values(Consumer<Builder>... values);

        /**
         * <p>
         * The constituent sub slots of a composite slot.
         * </p>
         * 
         * @param subSlots
         *        The constituent sub slots of a composite slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSlots(Map<String, Slot> subSlots);
    }

    static final class BuilderImpl implements Builder {
        private Value value;

        private String shape;

        private List<Slot> values = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Slot> subSlots = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            value(model.value);
            shape(model.shape);
            values(model.values);
            subSlots(model.subSlots);
        }

        public final Value.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(Value.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(Value value) {
            this.value = value;
            return this;
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public final Builder shape(Shape shape) {
            this.shape(shape == null ? null : shape.toString());
            return this;
        }

        public final List<Builder> getValues() {
            List<Builder> result = ValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<BuilderImpl> values) {
            this.values = ValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<Slot> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Slot... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<Builder>... values) {
            values(Stream.of(values).map(c -> Slot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getSubSlots() {
            Map<String, Builder> result = SlotsCopier.copyToBuilder(this.subSlots);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSubSlots(Map<String, BuilderImpl> subSlots) {
            this.subSlots = SlotsCopier.copyFromBuilder(subSlots);
        }

        @Override
        public final Builder subSlots(Map<String, Slot> subSlots) {
            this.subSlots = SlotsCopier.copy(subSlots);
            return this;
        }

        @Override
        public Slot build() {
            return new Slot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
