/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information about an intent that Amazon Lex V2 determined might satisfy the user's utterance.
 * The intents are ordered by the confidence score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Interpretation implements SdkPojo, Serializable, ToCopyableBuilder<Interpretation.Builder, Interpretation> {
    private static final SdkField<ConfidenceScore> NLU_CONFIDENCE_FIELD = SdkField
            .<ConfidenceScore> builder(MarshallingType.SDK_POJO).memberName("nluConfidence")
            .getter(getter(Interpretation::nluConfidence)).setter(setter(Builder::nluConfidence))
            .constructor(ConfidenceScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluConfidence").build()).build();

    private static final SdkField<SentimentResponse> SENTIMENT_RESPONSE_FIELD = SdkField
            .<SentimentResponse> builder(MarshallingType.SDK_POJO).memberName("sentimentResponse")
            .getter(getter(Interpretation::sentimentResponse)).setter(setter(Builder::sentimentResponse))
            .constructor(SentimentResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentResponse").build()).build();

    private static final SdkField<Intent> INTENT_FIELD = SdkField.<Intent> builder(MarshallingType.SDK_POJO).memberName("intent")
            .getter(getter(Interpretation::intent)).setter(setter(Builder::intent)).constructor(Intent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()).build();

    private static final SdkField<String> INTERPRETATION_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interpretationSource").getter(getter(Interpretation::interpretationSourceAsString))
            .setter(setter(Builder::interpretationSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretationSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NLU_CONFIDENCE_FIELD,
            SENTIMENT_RESPONSE_FIELD, INTENT_FIELD, INTERPRETATION_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConfidenceScore nluConfidence;

    private final SentimentResponse sentimentResponse;

    private final Intent intent;

    private final String interpretationSource;

    private Interpretation(BuilderImpl builder) {
        this.nluConfidence = builder.nluConfidence;
        this.sentimentResponse = builder.sentimentResponse;
        this.intent = builder.intent;
        this.interpretationSource = builder.interpretationSource;
    }

    /**
     * <p>
     * Determines the threshold where Amazon Lex V2 will insert the <code>AMAZON.FallbackIntent</code>,
     * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a response.
     * <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
     * configured for the bot.
     * </p>
     * 
     * @return Determines the threshold where Amazon Lex V2 will insert the <code>AMAZON.FallbackIntent</code>,
     *         <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a response.
     *         <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they
     *         are configured for the bot.
     */
    public final ConfidenceScore nluConfidence() {
        return nluConfidence;
    }

    /**
     * <p>
     * The sentiment expressed in an utterance.
     * </p>
     * <p>
     * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains
     * the result of the analysis.
     * </p>
     * 
     * @return The sentiment expressed in an utterance. </p>
     *         <p>
     *         When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field
     *         contains the result of the analysis.
     */
    public final SentimentResponse sentimentResponse() {
        return sentimentResponse;
    }

    /**
     * <p>
     * A list of intents that might satisfy the user's utterance. The intents are ordered by the confidence score.
     * </p>
     * 
     * @return A list of intents that might satisfy the user's utterance. The intents are ordered by the confidence
     *         score.
     */
    public final Intent intent() {
        return intent;
    }

    /**
     * <p>
     * Specifies the service that interpreted the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #interpretationSource} will return {@link InterpretationSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #interpretationSourceAsString}.
     * </p>
     * 
     * @return Specifies the service that interpreted the input.
     * @see InterpretationSource
     */
    public final InterpretationSource interpretationSource() {
        return InterpretationSource.fromValue(interpretationSource);
    }

    /**
     * <p>
     * Specifies the service that interpreted the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #interpretationSource} will return {@link InterpretationSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #interpretationSourceAsString}.
     * </p>
     * 
     * @return Specifies the service that interpreted the input.
     * @see InterpretationSource
     */
    public final String interpretationSourceAsString() {
        return interpretationSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nluConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentResponse());
        hashCode = 31 * hashCode + Objects.hashCode(intent());
        hashCode = 31 * hashCode + Objects.hashCode(interpretationSourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interpretation)) {
            return false;
        }
        Interpretation other = (Interpretation) obj;
        return Objects.equals(nluConfidence(), other.nluConfidence())
                && Objects.equals(sentimentResponse(), other.sentimentResponse()) && Objects.equals(intent(), other.intent())
                && Objects.equals(interpretationSourceAsString(), other.interpretationSourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Interpretation").add("NluConfidence", nluConfidence())
                .add("SentimentResponse", sentimentResponse()).add("Intent", intent())
                .add("InterpretationSource", interpretationSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nluConfidence":
            return Optional.ofNullable(clazz.cast(nluConfidence()));
        case "sentimentResponse":
            return Optional.ofNullable(clazz.cast(sentimentResponse()));
        case "intent":
            return Optional.ofNullable(clazz.cast(intent()));
        case "interpretationSource":
            return Optional.ofNullable(clazz.cast(interpretationSourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nluConfidence", NLU_CONFIDENCE_FIELD);
        map.put("sentimentResponse", SENTIMENT_RESPONSE_FIELD);
        map.put("intent", INTENT_FIELD);
        map.put("interpretationSource", INTERPRETATION_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Interpretation, T> g) {
        return obj -> g.apply((Interpretation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Interpretation> {
        /**
         * <p>
         * Determines the threshold where Amazon Lex V2 will insert the <code>AMAZON.FallbackIntent</code>,
         * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a response.
         * <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
         * configured for the bot.
         * </p>
         * 
         * @param nluConfidence
         *        Determines the threshold where Amazon Lex V2 will insert the <code>AMAZON.FallbackIntent</code>,
         *        <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a response.
         *        <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if
         *        they are configured for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluConfidence(ConfidenceScore nluConfidence);

        /**
         * <p>
         * Determines the threshold where Amazon Lex V2 will insert the <code>AMAZON.FallbackIntent</code>,
         * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a response.
         * <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
         * configured for the bot.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfidenceScore.Builder} avoiding the
         * need to create one manually via {@link ConfidenceScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfidenceScore.Builder#build()} is called immediately and its
         * result is passed to {@link #nluConfidence(ConfidenceScore)}.
         * 
         * @param nluConfidence
         *        a consumer that will call methods on {@link ConfidenceScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nluConfidence(ConfidenceScore)
         */
        default Builder nluConfidence(Consumer<ConfidenceScore.Builder> nluConfidence) {
            return nluConfidence(ConfidenceScore.builder().applyMutation(nluConfidence).build());
        }

        /**
         * <p>
         * The sentiment expressed in an utterance.
         * </p>
         * <p>
         * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field
         * contains the result of the analysis.
         * </p>
         * 
         * @param sentimentResponse
         *        The sentiment expressed in an utterance. </p>
         *        <p>
         *        When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field
         *        contains the result of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentResponse(SentimentResponse sentimentResponse);

        /**
         * <p>
         * The sentiment expressed in an utterance.
         * </p>
         * <p>
         * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field
         * contains the result of the analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link SentimentResponse.Builder} avoiding the
         * need to create one manually via {@link SentimentResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SentimentResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #sentimentResponse(SentimentResponse)}.
         * 
         * @param sentimentResponse
         *        a consumer that will call methods on {@link SentimentResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentResponse(SentimentResponse)
         */
        default Builder sentimentResponse(Consumer<SentimentResponse.Builder> sentimentResponse) {
            return sentimentResponse(SentimentResponse.builder().applyMutation(sentimentResponse).build());
        }

        /**
         * <p>
         * A list of intents that might satisfy the user's utterance. The intents are ordered by the confidence score.
         * </p>
         * 
         * @param intent
         *        A list of intents that might satisfy the user's utterance. The intents are ordered by the confidence
         *        score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intent(Intent intent);

        /**
         * <p>
         * A list of intents that might satisfy the user's utterance. The intents are ordered by the confidence score.
         * </p>
         * This is a convenience method that creates an instance of the {@link Intent.Builder} avoiding the need to
         * create one manually via {@link Intent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Intent.Builder#build()} is called immediately and its result is
         * passed to {@link #intent(Intent)}.
         * 
         * @param intent
         *        a consumer that will call methods on {@link Intent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intent(Intent)
         */
        default Builder intent(Consumer<Intent.Builder> intent) {
            return intent(Intent.builder().applyMutation(intent).build());
        }

        /**
         * <p>
         * Specifies the service that interpreted the input.
         * </p>
         * 
         * @param interpretationSource
         *        Specifies the service that interpreted the input.
         * @see InterpretationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterpretationSource
         */
        Builder interpretationSource(String interpretationSource);

        /**
         * <p>
         * Specifies the service that interpreted the input.
         * </p>
         * 
         * @param interpretationSource
         *        Specifies the service that interpreted the input.
         * @see InterpretationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterpretationSource
         */
        Builder interpretationSource(InterpretationSource interpretationSource);
    }

    static final class BuilderImpl implements Builder {
        private ConfidenceScore nluConfidence;

        private SentimentResponse sentimentResponse;

        private Intent intent;

        private String interpretationSource;

        private BuilderImpl() {
        }

        private BuilderImpl(Interpretation model) {
            nluConfidence(model.nluConfidence);
            sentimentResponse(model.sentimentResponse);
            intent(model.intent);
            interpretationSource(model.interpretationSource);
        }

        public final ConfidenceScore.Builder getNluConfidence() {
            return nluConfidence != null ? nluConfidence.toBuilder() : null;
        }

        public final void setNluConfidence(ConfidenceScore.BuilderImpl nluConfidence) {
            this.nluConfidence = nluConfidence != null ? nluConfidence.build() : null;
        }

        @Override
        public final Builder nluConfidence(ConfidenceScore nluConfidence) {
            this.nluConfidence = nluConfidence;
            return this;
        }

        public final SentimentResponse.Builder getSentimentResponse() {
            return sentimentResponse != null ? sentimentResponse.toBuilder() : null;
        }

        public final void setSentimentResponse(SentimentResponse.BuilderImpl sentimentResponse) {
            this.sentimentResponse = sentimentResponse != null ? sentimentResponse.build() : null;
        }

        @Override
        public final Builder sentimentResponse(SentimentResponse sentimentResponse) {
            this.sentimentResponse = sentimentResponse;
            return this;
        }

        public final Intent.Builder getIntent() {
            return intent != null ? intent.toBuilder() : null;
        }

        public final void setIntent(Intent.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        public final Builder intent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public final String getInterpretationSource() {
            return interpretationSource;
        }

        public final void setInterpretationSource(String interpretationSource) {
            this.interpretationSource = interpretationSource;
        }

        @Override
        public final Builder interpretationSource(String interpretationSource) {
            this.interpretationSource = interpretationSource;
            return this;
        }

        @Override
        public final Builder interpretationSource(InterpretationSource interpretationSource) {
            this.interpretationSource(interpretationSource == null ? null : interpretationSource.toString());
            return this;
        }

        @Override
        public Interpretation build() {
            return new Interpretation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
