/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of attributes that describe a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceInventory implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceInventory.Builder, ResourceInventory> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceInventory::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceInventory::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceInventory::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceInventory::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceInventory::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> RESOURCE_OWNING_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceInventory::resourceOwningAccountId)).setter(setter(Builder::resourceOwningAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwningAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ARN_FIELD, PLATFORM_FIELD, PLATFORM_VERSION_FIELD, RESOURCE_OWNING_ACCOUNT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String resourceType;

    private final String resourceArn;

    private final String platform;

    private final String platformVersion;

    private final String resourceOwningAccountId;

    private ResourceInventory(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceArn = builder.resourceArn;
        this.platform = builder.platform;
        this.platformVersion = builder.platformVersion;
        this.resourceOwningAccountId = builder.resourceOwningAccountId;
    }

    /**
     * <p>
     * Unique ID of the resource.
     * </p>
     * 
     * @return Unique ID of the resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The platform of the resource.
     * </p>
     * 
     * @return The platform of the resource.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * Platform version of the resource in the inventory.
     * </p>
     * 
     * @return Platform version of the resource in the inventory.
     */
    public String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * Unique ID of the account that owns the resource.
     * </p>
     * 
     * @return Unique ID of the account that owns the resource.
     */
    public String resourceOwningAccountId() {
        return resourceOwningAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwningAccountId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInventory)) {
            return false;
        }
        ResourceInventory other = (ResourceInventory) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(platform(), other.platform())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(resourceOwningAccountId(), other.resourceOwningAccountId());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceInventory").add("ResourceId", resourceId()).add("ResourceType", resourceTypeAsString())
                .add("ResourceArn", resourceArn()).add("Platform", platform()).add("PlatformVersion", platformVersion())
                .add("ResourceOwningAccountId", resourceOwningAccountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "ResourceOwningAccountId":
            return Optional.ofNullable(clazz.cast(resourceOwningAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceInventory, T> g) {
        return obj -> g.apply((ResourceInventory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceInventory> {
        /**
         * <p>
         * Unique ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        Unique ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The platform of the resource.
         * </p>
         * 
         * @param platform
         *        The platform of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * Platform version of the resource in the inventory.
         * </p>
         * 
         * @param platformVersion
         *        Platform version of the resource in the inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * Unique ID of the account that owns the resource.
         * </p>
         * 
         * @param resourceOwningAccountId
         *        Unique ID of the account that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwningAccountId(String resourceOwningAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String resourceArn;

        private String platform;

        private String platformVersion;

        private String resourceOwningAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInventory model) {
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            resourceArn(model.resourceArn);
            platform(model.platform);
            platformVersion(model.platformVersion);
            resourceOwningAccountId(model.resourceOwningAccountId);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getResourceOwningAccountId() {
            return resourceOwningAccountId;
        }

        @Override
        public final Builder resourceOwningAccountId(String resourceOwningAccountId) {
            this.resourceOwningAccountId = resourceOwningAccountId;
            return this;
        }

        public final void setResourceOwningAccountId(String resourceOwningAccountId) {
            this.resourceOwningAccountId = resourceOwningAccountId;
        }

        @Override
        public ResourceInventory build() {
            return new ResourceInventory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
