/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes product information filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductInformationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductInformationFilter.Builder, ProductInformationFilter> {
    private static final SdkField<String> PRODUCT_INFORMATION_FILTER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ProductInformationFilter::productInformationFilterName))
            .setter(setter(Builder::productInformationFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterName")
                    .build()).build();

    private static final SdkField<List<String>> PRODUCT_INFORMATION_FILTER_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ProductInformationFilter::productInformationFilterValue))
            .setter(setter(Builder::productInformationFilterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterValue")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRODUCT_INFORMATION_FILTER_COMPARATOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ProductInformationFilter::productInformationFilterComparator))
            .setter(setter(Builder::productInformationFilterComparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterComparator")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PRODUCT_INFORMATION_FILTER_NAME_FIELD, PRODUCT_INFORMATION_FILTER_VALUE_FIELD,
            PRODUCT_INFORMATION_FILTER_COMPARATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String productInformationFilterName;

    private final List<String> productInformationFilterValue;

    private final String productInformationFilterComparator;

    private ProductInformationFilter(BuilderImpl builder) {
        this.productInformationFilterName = builder.productInformationFilterName;
        this.productInformationFilterValue = builder.productInformationFilterValue;
        this.productInformationFilterComparator = builder.productInformationFilterComparator;
    }

    /**
     * <p>
     * Filter name.
     * </p>
     * 
     * @return Filter name.
     */
    public String productInformationFilterName() {
        return productInformationFilterName;
    }

    /**
     * <p>
     * Filter value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filter value.
     */
    public List<String> productInformationFilterValue() {
        return productInformationFilterValue;
    }

    /**
     * <p>
     * Logical operator.
     * </p>
     * 
     * @return Logical operator.
     */
    public String productInformationFilterComparator() {
        return productInformationFilterComparator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productInformationFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(productInformationFilterValue());
        hashCode = 31 * hashCode + Objects.hashCode(productInformationFilterComparator());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductInformationFilter)) {
            return false;
        }
        ProductInformationFilter other = (ProductInformationFilter) obj;
        return Objects.equals(productInformationFilterName(), other.productInformationFilterName())
                && Objects.equals(productInformationFilterValue(), other.productInformationFilterValue())
                && Objects.equals(productInformationFilterComparator(), other.productInformationFilterComparator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProductInformationFilter").add("ProductInformationFilterName", productInformationFilterName())
                .add("ProductInformationFilterValue", productInformationFilterValue())
                .add("ProductInformationFilterComparator", productInformationFilterComparator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductInformationFilterName":
            return Optional.ofNullable(clazz.cast(productInformationFilterName()));
        case "ProductInformationFilterValue":
            return Optional.ofNullable(clazz.cast(productInformationFilterValue()));
        case "ProductInformationFilterComparator":
            return Optional.ofNullable(clazz.cast(productInformationFilterComparator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductInformationFilter, T> g) {
        return obj -> g.apply((ProductInformationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductInformationFilter> {
        /**
         * <p>
         * Filter name.
         * </p>
         * 
         * @param productInformationFilterName
         *        Filter name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterName(String productInformationFilterName);

        /**
         * <p>
         * Filter value.
         * </p>
         * 
         * @param productInformationFilterValue
         *        Filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterValue(Collection<String> productInformationFilterValue);

        /**
         * <p>
         * Filter value.
         * </p>
         * 
         * @param productInformationFilterValue
         *        Filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterValue(String... productInformationFilterValue);

        /**
         * <p>
         * Logical operator.
         * </p>
         * 
         * @param productInformationFilterComparator
         *        Logical operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterComparator(String productInformationFilterComparator);
    }

    static final class BuilderImpl implements Builder {
        private String productInformationFilterName;

        private List<String> productInformationFilterValue = DefaultSdkAutoConstructList.getInstance();

        private String productInformationFilterComparator;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductInformationFilter model) {
            productInformationFilterName(model.productInformationFilterName);
            productInformationFilterValue(model.productInformationFilterValue);
            productInformationFilterComparator(model.productInformationFilterComparator);
        }

        public final String getProductInformationFilterName() {
            return productInformationFilterName;
        }

        @Override
        public final Builder productInformationFilterName(String productInformationFilterName) {
            this.productInformationFilterName = productInformationFilterName;
            return this;
        }

        public final void setProductInformationFilterName(String productInformationFilterName) {
            this.productInformationFilterName = productInformationFilterName;
        }

        public final Collection<String> getProductInformationFilterValue() {
            return productInformationFilterValue;
        }

        @Override
        public final Builder productInformationFilterValue(Collection<String> productInformationFilterValue) {
            this.productInformationFilterValue = StringListCopier.copy(productInformationFilterValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationFilterValue(String... productInformationFilterValue) {
            productInformationFilterValue(Arrays.asList(productInformationFilterValue));
            return this;
        }

        public final void setProductInformationFilterValue(Collection<String> productInformationFilterValue) {
            this.productInformationFilterValue = StringListCopier.copy(productInformationFilterValue);
        }

        public final String getProductInformationFilterComparator() {
            return productInformationFilterComparator;
        }

        @Override
        public final Builder productInformationFilterComparator(String productInformationFilterComparator) {
            this.productInformationFilterComparator = productInformationFilterComparator;
            return this;
        }

        public final void setProductInformationFilterComparator(String productInformationFilterComparator) {
            this.productInformationFilterComparator = productInformationFilterComparator;
        }

        @Override
        public ProductInformationFilter build() {
            return new ProductInformationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
