/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLicenseSpecificationsForResourceRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<UpdateLicenseSpecificationsForResourceRequest.Builder, UpdateLicenseSpecificationsForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLicenseSpecificationsForResourceRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<LicenseSpecification>> ADD_LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LicenseSpecification>> builder(MarshallingType.LIST)
            .getter(getter(UpdateLicenseSpecificationsForResourceRequest::addLicenseSpecifications))
            .setter(setter(Builder::addLicenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddLicenseSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LicenseSpecification>> REMOVE_LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LicenseSpecification>> builder(MarshallingType.LIST)
            .getter(getter(UpdateLicenseSpecificationsForResourceRequest::removeLicenseSpecifications))
            .setter(setter(Builder::removeLicenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveLicenseSpecifications")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            ADD_LICENSE_SPECIFICATIONS_FIELD, REMOVE_LICENSE_SPECIFICATIONS_FIELD));

    private final String resourceArn;

    private final List<LicenseSpecification> addLicenseSpecifications;

    private final List<LicenseSpecification> removeLicenseSpecifications;

    private UpdateLicenseSpecificationsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.addLicenseSpecifications = builder.addLicenseSpecifications;
        this.removeLicenseSpecifications = builder.removeLicenseSpecifications;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the AWS resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the AWS resource.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * ARNs of the license configurations to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return ARNs of the license configurations to add.
     */
    public List<LicenseSpecification> addLicenseSpecifications() {
        return addLicenseSpecifications;
    }

    /**
     * <p>
     * ARNs of the license configurations to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return ARNs of the license configurations to remove.
     */
    public List<LicenseSpecification> removeLicenseSpecifications() {
        return removeLicenseSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(addLicenseSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(removeLicenseSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLicenseSpecificationsForResourceRequest)) {
            return false;
        }
        UpdateLicenseSpecificationsForResourceRequest other = (UpdateLicenseSpecificationsForResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(addLicenseSpecifications(), other.addLicenseSpecifications())
                && Objects.equals(removeLicenseSpecifications(), other.removeLicenseSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateLicenseSpecificationsForResourceRequest").add("ResourceArn", resourceArn())
                .add("AddLicenseSpecifications", addLicenseSpecifications())
                .add("RemoveLicenseSpecifications", removeLicenseSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "AddLicenseSpecifications":
            return Optional.ofNullable(clazz.cast(addLicenseSpecifications()));
        case "RemoveLicenseSpecifications":
            return Optional.ofNullable(clazz.cast(removeLicenseSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLicenseSpecificationsForResourceRequest, T> g) {
        return obj -> g.apply((UpdateLicenseSpecificationsForResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLicenseSpecificationsForResourceRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the AWS resource.
         * </p>
         * 
         * @param resourceArn
         *        Amazon Resource Name (ARN) of the AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * ARNs of the license configurations to add.
         * </p>
         * 
         * @param addLicenseSpecifications
         *        ARNs of the license configurations to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addLicenseSpecifications(Collection<LicenseSpecification> addLicenseSpecifications);

        /**
         * <p>
         * ARNs of the license configurations to add.
         * </p>
         * 
         * @param addLicenseSpecifications
         *        ARNs of the license configurations to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addLicenseSpecifications(LicenseSpecification... addLicenseSpecifications);

        /**
         * <p>
         * ARNs of the license configurations to add.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LicenseSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<LicenseSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseSpecification>.Builder#build()} is called immediately
         * and its result is passed to {@link #addLicenseSpecifications(List<LicenseSpecification>)}.
         * 
         * @param addLicenseSpecifications
         *        a consumer that will call methods on {@link List<LicenseSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addLicenseSpecifications(List<LicenseSpecification>)
         */
        Builder addLicenseSpecifications(Consumer<LicenseSpecification.Builder>... addLicenseSpecifications);

        /**
         * <p>
         * ARNs of the license configurations to remove.
         * </p>
         * 
         * @param removeLicenseSpecifications
         *        ARNs of the license configurations to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeLicenseSpecifications(Collection<LicenseSpecification> removeLicenseSpecifications);

        /**
         * <p>
         * ARNs of the license configurations to remove.
         * </p>
         * 
         * @param removeLicenseSpecifications
         *        ARNs of the license configurations to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeLicenseSpecifications(LicenseSpecification... removeLicenseSpecifications);

        /**
         * <p>
         * ARNs of the license configurations to remove.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LicenseSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<LicenseSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseSpecification>.Builder#build()} is called immediately
         * and its result is passed to {@link #removeLicenseSpecifications(List<LicenseSpecification>)}.
         * 
         * @param removeLicenseSpecifications
         *        a consumer that will call methods on {@link List<LicenseSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeLicenseSpecifications(List<LicenseSpecification>)
         */
        Builder removeLicenseSpecifications(Consumer<LicenseSpecification.Builder>... removeLicenseSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private List<LicenseSpecification> addLicenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<LicenseSpecification> removeLicenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLicenseSpecificationsForResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            addLicenseSpecifications(model.addLicenseSpecifications);
            removeLicenseSpecifications(model.removeLicenseSpecifications);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<LicenseSpecification.Builder> getAddLicenseSpecifications() {
            return addLicenseSpecifications != null ? addLicenseSpecifications.stream().map(LicenseSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addLicenseSpecifications(Collection<LicenseSpecification> addLicenseSpecifications) {
            this.addLicenseSpecifications = LicenseSpecificationsCopier.copy(addLicenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addLicenseSpecifications(LicenseSpecification... addLicenseSpecifications) {
            addLicenseSpecifications(Arrays.asList(addLicenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addLicenseSpecifications(Consumer<LicenseSpecification.Builder>... addLicenseSpecifications) {
            addLicenseSpecifications(Stream.of(addLicenseSpecifications)
                    .map(c -> LicenseSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddLicenseSpecifications(Collection<LicenseSpecification.BuilderImpl> addLicenseSpecifications) {
            this.addLicenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(addLicenseSpecifications);
        }

        public final Collection<LicenseSpecification.Builder> getRemoveLicenseSpecifications() {
            return removeLicenseSpecifications != null ? removeLicenseSpecifications.stream()
                    .map(LicenseSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder removeLicenseSpecifications(Collection<LicenseSpecification> removeLicenseSpecifications) {
            this.removeLicenseSpecifications = LicenseSpecificationsCopier.copy(removeLicenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeLicenseSpecifications(LicenseSpecification... removeLicenseSpecifications) {
            removeLicenseSpecifications(Arrays.asList(removeLicenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeLicenseSpecifications(Consumer<LicenseSpecification.Builder>... removeLicenseSpecifications) {
            removeLicenseSpecifications(Stream.of(removeLicenseSpecifications)
                    .map(c -> LicenseSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemoveLicenseSpecifications(Collection<LicenseSpecification.BuilderImpl> removeLicenseSpecifications) {
            this.removeLicenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(removeLicenseSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLicenseSpecificationsForResourceRequest build() {
            return new UpdateLicenseSpecificationsForResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
