/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsageForLicenseConfigurationRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<ListUsageForLicenseConfigurationRequest.Builder, ListUsageForLicenseConfigurationRequest> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUsageForLicenseConfigurationRequest::licenseConfigurationArn))
            .setter(setter(Builder::licenseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListUsageForLicenseConfigurationRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUsageForLicenseConfigurationRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(ListUsageForLicenseConfigurationRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private final String licenseConfigurationArn;

    private final Integer maxResults;

    private final String nextToken;

    private final List<Filter> filters;

    private ListUsageForLicenseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license configuration.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license configuration.
     */
    public String licenseConfigurationArn() {
        return licenseConfigurationArn;
    }

    /**
     * <p>
     * Maximum number of results to return in a single call.
     * </p>
     * 
     * @return Maximum number of results to return in a single call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters to scope the results. The following filters and logical operators are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are
     * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resourceType</code> - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI |
     * SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are
     * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters to scope the results. The following filters and logical operators are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are
     *         <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resourceType</code> - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI |
     *         SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are
     *         <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsageForLicenseConfigurationRequest)) {
            return false;
        }
        ListUsageForLicenseConfigurationRequest other = (ListUsageForLicenseConfigurationRequest) obj;
        return Objects.equals(licenseConfigurationArn(), other.licenseConfigurationArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUsageForLicenseConfigurationRequest")
                .add("LicenseConfigurationArn", licenseConfigurationArn()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationArn":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsageForLicenseConfigurationRequest, T> g) {
        return obj -> g.apply((ListUsageForLicenseConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUsageForLicenseConfigurationRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license configuration.
         * </p>
         * 
         * @param licenseConfigurationArn
         *        Amazon Resource Name (ARN) of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArn(String licenseConfigurationArn);

        /**
         * <p>
         * Maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceType</code> - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI |
         * SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are
         *        <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceType</code> - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI |
         *        SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are
         *        <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceType</code> - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI |
         * SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are
         *        <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceType</code> - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI |
         *        SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are
         *        <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceType</code> - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI |
         * SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseConfigurationArn;

        private Integer maxResults;

        private String nextToken;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsageForLicenseConfigurationRequest model) {
            super(model);
            licenseConfigurationArn(model.licenseConfigurationArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final String getLicenseConfigurationArn() {
            return licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListUsageForLicenseConfigurationRequest build() {
            return new ListUsageForLicenseConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
