/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLicenseConfigurationRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateLicenseConfigurationRequest.Builder, CreateLicenseConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLicenseConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLicenseConfigurationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LICENSE_COUNTING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLicenseConfigurationRequest::licenseCountingTypeAsString))
            .setter(setter(Builder::licenseCountingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountingType").build())
            .build();

    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateLicenseConfigurationRequest::licenseCount)).setter(setter(Builder::licenseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()).build();

    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateLicenseConfigurationRequest::licenseCountHardLimit))
            .setter(setter(Builder::licenseCountHardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build())
            .build();

    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateLicenseConfigurationRequest::licenseRules))
            .setter(setter(Builder::licenseRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateLicenseConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProductInformation>> PRODUCT_INFORMATION_LIST_FIELD = SdkField
            .<List<ProductInformation>> builder(MarshallingType.LIST)
            .getter(getter(CreateLicenseConfigurationRequest::productInformationList))
            .setter(setter(Builder::productInformationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            LICENSE_COUNTING_TYPE_FIELD, LICENSE_COUNT_FIELD, LICENSE_COUNT_HARD_LIMIT_FIELD, LICENSE_RULES_FIELD, TAGS_FIELD,
            PRODUCT_INFORMATION_LIST_FIELD));

    private final String name;

    private final String description;

    private final String licenseCountingType;

    private final Long licenseCount;

    private final Boolean licenseCountHardLimit;

    private final List<String> licenseRules;

    private final List<Tag> tags;

    private final List<ProductInformation> productInformationList;

    private CreateLicenseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.licenseCountingType = builder.licenseCountingType;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.licenseRules = builder.licenseRules;
        this.tags = builder.tags;
        this.productInformationList = builder.productInformationList;
    }

    /**
     * <p>
     * Name of the license configuration.
     * </p>
     * 
     * @return Name of the license configuration.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Description of the license configuration.
     * </p>
     * 
     * @return Description of the license configuration.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Dimension used to track the license inventory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseCountingType} will return {@link LicenseCountingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #licenseCountingTypeAsString}.
     * </p>
     * 
     * @return Dimension used to track the license inventory.
     * @see LicenseCountingType
     */
    public LicenseCountingType licenseCountingType() {
        return LicenseCountingType.fromValue(licenseCountingType);
    }

    /**
     * <p>
     * Dimension used to track the license inventory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseCountingType} will return {@link LicenseCountingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #licenseCountingTypeAsString}.
     * </p>
     * 
     * @return Dimension used to track the license inventory.
     * @see LicenseCountingType
     */
    public String licenseCountingTypeAsString() {
        return licenseCountingType;
    }

    /**
     * <p>
     * Number of licenses managed by the license configuration.
     * </p>
     * 
     * @return Number of licenses managed by the license configuration.
     */
    public Long licenseCount() {
        return licenseCount;
    }

    /**
     * <p>
     * Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new
     * instances.
     * </p>
     * 
     * @return Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of
     *         new instances.
     */
    public Boolean licenseCountHardLimit() {
        return licenseCountHardLimit;
    }

    /**
     * Returns true if the LicenseRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLicenseRules() {
        return licenseRules != null && !(licenseRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). Available rules vary
     * by dimension.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
     * <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code>
     * | <code>minimumVcpus</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>maximumSockets</code> |
     * <code>minimumSockets</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> |
     * <code>maximumVcpus</code> | <code>minimumVcpus</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). Available
     *         rules vary by dimension.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
     *         <code>minimumCores</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
     *         <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> |
     *         <code>maximumVcpus</code> | <code>minimumVcpus</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>maximumSockets</code> |
     *         <code>minimumSockets</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> |
     *         <code>maximumVcpus</code> | <code>minimumVcpus</code>
     *         </p>
     *         </li>
     */
    public List<String> licenseRules() {
        return licenseRules;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to add to the license configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags to add to the license configuration.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the ProductInformationList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProductInformationList() {
        return productInformationList != null && !(productInformationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Product information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductInformationList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Product information.
     */
    public List<ProductInformation> productInformationList() {
        return productInformationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCountingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(licenseRules());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(productInformationList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseConfigurationRequest)) {
            return false;
        }
        CreateLicenseConfigurationRequest other = (CreateLicenseConfigurationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(licenseCountingTypeAsString(), other.licenseCountingTypeAsString())
                && Objects.equals(licenseCount(), other.licenseCount())
                && Objects.equals(licenseCountHardLimit(), other.licenseCountHardLimit())
                && Objects.equals(licenseRules(), other.licenseRules()) && Objects.equals(tags(), other.tags())
                && Objects.equals(productInformationList(), other.productInformationList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLicenseConfigurationRequest").add("Name", name()).add("Description", description())
                .add("LicenseCountingType", licenseCountingTypeAsString()).add("LicenseCount", licenseCount())
                .add("LicenseCountHardLimit", licenseCountHardLimit()).add("LicenseRules", licenseRules()).add("Tags", tags())
                .add("ProductInformationList", productInformationList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LicenseCountingType":
            return Optional.ofNullable(clazz.cast(licenseCountingTypeAsString()));
        case "LicenseCount":
            return Optional.ofNullable(clazz.cast(licenseCount()));
        case "LicenseCountHardLimit":
            return Optional.ofNullable(clazz.cast(licenseCountHardLimit()));
        case "LicenseRules":
            return Optional.ofNullable(clazz.cast(licenseRules()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ProductInformationList":
            return Optional.ofNullable(clazz.cast(productInformationList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseConfigurationRequest, T> g) {
        return obj -> g.apply((CreateLicenseConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLicenseConfigurationRequest> {
        /**
         * <p>
         * Name of the license configuration.
         * </p>
         * 
         * @param name
         *        Name of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the license configuration.
         * </p>
         * 
         * @param description
         *        Description of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Dimension used to track the license inventory.
         * </p>
         * 
         * @param licenseCountingType
         *        Dimension used to track the license inventory.
         * @see LicenseCountingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseCountingType
         */
        Builder licenseCountingType(String licenseCountingType);

        /**
         * <p>
         * Dimension used to track the license inventory.
         * </p>
         * 
         * @param licenseCountingType
         *        Dimension used to track the license inventory.
         * @see LicenseCountingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseCountingType
         */
        Builder licenseCountingType(LicenseCountingType licenseCountingType);

        /**
         * <p>
         * Number of licenses managed by the license configuration.
         * </p>
         * 
         * @param licenseCount
         *        Number of licenses managed by the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCount(Long licenseCount);

        /**
         * <p>
         * Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new
         * instances.
         * </p>
         * 
         * @param licenseCountHardLimit
         *        Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch
         *        of new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCountHardLimit(Boolean licenseCountHardLimit);

        /**
         * <p>
         * License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). Available rules
         * vary by dimension.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         * <code>minimumCores</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         * <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> |
         * <code>maximumVcpus</code> | <code>minimumVcpus</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>maximumSockets</code> |
         * <code>minimumSockets</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> |
         * <code>maximumVcpus</code> | <code>minimumVcpus</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param licenseRules
         *        License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). Available
         *        rules vary by dimension.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         *        <code>minimumCores</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         *        <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> |
         *        <code>maximumVcpus</code> | <code>minimumVcpus</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>maximumSockets</code> |
         *        <code>minimumSockets</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> |
         *        <code>maximumVcpus</code> | <code>minimumVcpus</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(Collection<String> licenseRules);

        /**
         * <p>
         * License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). Available rules
         * vary by dimension.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         * <code>minimumCores</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         * <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> |
         * <code>maximumVcpus</code> | <code>minimumVcpus</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>maximumSockets</code> |
         * <code>minimumSockets</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> |
         * <code>maximumVcpus</code> | <code>minimumVcpus</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param licenseRules
         *        License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). Available
         *        rules vary by dimension.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         *        <code>minimumCores</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> |
         *        <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> |
         *        <code>maximumVcpus</code> | <code>minimumVcpus</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>maximumSockets</code> |
         *        <code>minimumSockets</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> |
         *        <code>maximumVcpus</code> | <code>minimumVcpus</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(String... licenseRules);

        /**
         * <p>
         * Tags to add to the license configuration.
         * </p>
         * 
         * @param tags
         *        Tags to add to the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to add to the license configuration.
         * </p>
         * 
         * @param tags
         *        Tags to add to the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to add to the license configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Product information.
         * </p>
         * 
         * @param productInformationList
         *        Product information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationList(Collection<ProductInformation> productInformationList);

        /**
         * <p>
         * Product information.
         * </p>
         * 
         * @param productInformationList
         *        Product information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationList(ProductInformation... productInformationList);

        /**
         * <p>
         * Product information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductInformation>.Builder} avoiding the
         * need to create one manually via {@link List<ProductInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductInformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #productInformationList(List<ProductInformation>)}.
         * 
         * @param productInformationList
         *        a consumer that will call methods on {@link List<ProductInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productInformationList(List<ProductInformation>)
         */
        Builder productInformationList(Consumer<ProductInformation.Builder>... productInformationList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String licenseCountingType;

        private Long licenseCount;

        private Boolean licenseCountHardLimit;

        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<ProductInformation> productInformationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseConfigurationRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            licenseCountingType(model.licenseCountingType);
            licenseCount(model.licenseCount);
            licenseCountHardLimit(model.licenseCountHardLimit);
            licenseRules(model.licenseRules);
            tags(model.tags);
            productInformationList(model.productInformationList);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLicenseCountingTypeAsString() {
            return licenseCountingType;
        }

        @Override
        public final Builder licenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
            return this;
        }

        @Override
        public final Builder licenseCountingType(LicenseCountingType licenseCountingType) {
            this.licenseCountingType(licenseCountingType == null ? null : licenseCountingType.toString());
            return this;
        }

        public final void setLicenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
        }

        public final Long getLicenseCount() {
            return licenseCount;
        }

        @Override
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        public final Boolean getLicenseCountHardLimit() {
            return licenseCountHardLimit;
        }

        @Override
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        public final Collection<String> getLicenseRules() {
            return licenseRules;
        }

        @Override
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRules(String... licenseRules) {
            licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<ProductInformation.Builder> getProductInformationList() {
            return productInformationList != null ? productInformationList.stream().map(ProductInformation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productInformationList(Collection<ProductInformation> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copy(productInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(ProductInformation... productInformationList) {
            productInformationList(Arrays.asList(productInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(Consumer<ProductInformation.Builder>... productInformationList) {
            productInformationList(Stream.of(productInformationList)
                    .map(c -> ProductInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductInformationList(Collection<ProductInformation.BuilderImpl> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copyFromBuilder(productInformationList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseConfigurationRequest build() {
            return new CreateLicenseConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
