/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFailuresForLicenseConfigurationOperationsResponse extends LicenseManagerResponse
        implements
        ToCopyableBuilder<ListFailuresForLicenseConfigurationOperationsResponse.Builder, ListFailuresForLicenseConfigurationOperationsResponse> {
    private static final SdkField<List<LicenseOperationFailure>> LICENSE_OPERATION_FAILURE_LIST_FIELD = SdkField
            .<List<LicenseOperationFailure>> builder(MarshallingType.LIST)
            .memberName("LicenseOperationFailureList")
            .getter(getter(ListFailuresForLicenseConfigurationOperationsResponse::licenseOperationFailureList))
            .setter(setter(Builder::licenseOperationFailureList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseOperationFailureList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseOperationFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseOperationFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFailuresForLicenseConfigurationOperationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_OPERATION_FAILURE_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<LicenseOperationFailure> licenseOperationFailureList;

    private final String nextToken;

    private ListFailuresForLicenseConfigurationOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.licenseOperationFailureList = builder.licenseOperationFailureList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LicenseOperationFailureList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasLicenseOperationFailureList() {
        return licenseOperationFailureList != null && !(licenseOperationFailureList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License configuration operations that failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseOperationFailureList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License configuration operations that failed.
     */
    public List<LicenseOperationFailure> licenseOperationFailureList() {
        return licenseOperationFailureList;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseOperationFailureList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFailuresForLicenseConfigurationOperationsResponse)) {
            return false;
        }
        ListFailuresForLicenseConfigurationOperationsResponse other = (ListFailuresForLicenseConfigurationOperationsResponse) obj;
        return Objects.equals(licenseOperationFailureList(), other.licenseOperationFailureList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFailuresForLicenseConfigurationOperationsResponse")
                .add("LicenseOperationFailureList", licenseOperationFailureList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseOperationFailureList":
            return Optional.ofNullable(clazz.cast(licenseOperationFailureList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFailuresForLicenseConfigurationOperationsResponse, T> g) {
        return obj -> g.apply((ListFailuresForLicenseConfigurationOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFailuresForLicenseConfigurationOperationsResponse> {
        /**
         * <p>
         * License configuration operations that failed.
         * </p>
         * 
         * @param licenseOperationFailureList
         *        License configuration operations that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseOperationFailureList(Collection<LicenseOperationFailure> licenseOperationFailureList);

        /**
         * <p>
         * License configuration operations that failed.
         * </p>
         * 
         * @param licenseOperationFailureList
         *        License configuration operations that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseOperationFailureList(LicenseOperationFailure... licenseOperationFailureList);

        /**
         * <p>
         * License configuration operations that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LicenseOperationFailure>.Builder} avoiding
         * the need to create one manually via {@link List<LicenseOperationFailure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseOperationFailure>.Builder#build()} is called
         * immediately and its result is passed to {@link #licenseOperationFailureList(List<LicenseOperationFailure>)}.
         * 
         * @param licenseOperationFailureList
         *        a consumer that will call methods on {@link List<LicenseOperationFailure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseOperationFailureList(List<LicenseOperationFailure>)
         */
        Builder licenseOperationFailureList(Consumer<LicenseOperationFailure.Builder>... licenseOperationFailureList);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<LicenseOperationFailure> licenseOperationFailureList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFailuresForLicenseConfigurationOperationsResponse model) {
            super(model);
            licenseOperationFailureList(model.licenseOperationFailureList);
            nextToken(model.nextToken);
        }

        public final Collection<LicenseOperationFailure.Builder> getLicenseOperationFailureList() {
            return licenseOperationFailureList != null ? licenseOperationFailureList.stream()
                    .map(LicenseOperationFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseOperationFailureList(Collection<LicenseOperationFailure> licenseOperationFailureList) {
            this.licenseOperationFailureList = LicenseOperationFailureListCopier.copy(licenseOperationFailureList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseOperationFailureList(LicenseOperationFailure... licenseOperationFailureList) {
            licenseOperationFailureList(Arrays.asList(licenseOperationFailureList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseOperationFailureList(Consumer<LicenseOperationFailure.Builder>... licenseOperationFailureList) {
            licenseOperationFailureList(Stream.of(licenseOperationFailureList)
                    .map(c -> LicenseOperationFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseOperationFailureList(
                Collection<LicenseOperationFailure.BuilderImpl> licenseOperationFailureList) {
            this.licenseOperationFailureList = LicenseOperationFailureListCopier.copyFromBuilder(licenseOperationFailureList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFailuresForLicenseConfigurationOperationsResponse build() {
            return new ListFailuresForLicenseConfigurationOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
