/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociationsForLicenseConfigurationResponse extends LicenseManagerResponse
        implements
        ToCopyableBuilder<ListAssociationsForLicenseConfigurationResponse.Builder, ListAssociationsForLicenseConfigurationResponse> {
    private static final SdkField<List<LicenseConfigurationAssociation>> LICENSE_CONFIGURATION_ASSOCIATIONS_FIELD = SdkField
            .<List<LicenseConfigurationAssociation>> builder(MarshallingType.LIST)
            .memberName("LicenseConfigurationAssociations")
            .getter(getter(ListAssociationsForLicenseConfigurationResponse::licenseConfigurationAssociations))
            .setter(setter(Builder::licenseConfigurationAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseConfigurationAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseConfigurationAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAssociationsForLicenseConfigurationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<LicenseConfigurationAssociation> licenseConfigurationAssociations;

    private final String nextToken;

    private ListAssociationsForLicenseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationAssociations = builder.licenseConfigurationAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LicenseConfigurationAssociations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasLicenseConfigurationAssociations() {
        return licenseConfigurationAssociations != null && !(licenseConfigurationAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associations for the license configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseConfigurationAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the associations for the license configuration.
     */
    public List<LicenseConfigurationAssociation> licenseConfigurationAssociations() {
        return licenseConfigurationAssociations;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLicenseConfigurationAssociations() ? licenseConfigurationAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsForLicenseConfigurationResponse)) {
            return false;
        }
        ListAssociationsForLicenseConfigurationResponse other = (ListAssociationsForLicenseConfigurationResponse) obj;
        return hasLicenseConfigurationAssociations() == other.hasLicenseConfigurationAssociations()
                && Objects.equals(licenseConfigurationAssociations(), other.licenseConfigurationAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("ListAssociationsForLicenseConfigurationResponse")
                .add("LicenseConfigurationAssociations",
                        hasLicenseConfigurationAssociations() ? licenseConfigurationAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationAssociations":
            return Optional.ofNullable(clazz.cast(licenseConfigurationAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociationsForLicenseConfigurationResponse, T> g) {
        return obj -> g.apply((ListAssociationsForLicenseConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssociationsForLicenseConfigurationResponse> {
        /**
         * <p>
         * Information about the associations for the license configuration.
         * </p>
         * 
         * @param licenseConfigurationAssociations
         *        Information about the associations for the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationAssociations(Collection<LicenseConfigurationAssociation> licenseConfigurationAssociations);

        /**
         * <p>
         * Information about the associations for the license configuration.
         * </p>
         * 
         * @param licenseConfigurationAssociations
         *        Information about the associations for the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationAssociations(LicenseConfigurationAssociation... licenseConfigurationAssociations);

        /**
         * <p>
         * Information about the associations for the license configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LicenseConfigurationAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<LicenseConfigurationAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseConfigurationAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #licenseConfigurationAssociations(List<LicenseConfigurationAssociation>)}.
         * 
         * @param licenseConfigurationAssociations
         *        a consumer that will call methods on {@link List<LicenseConfigurationAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseConfigurationAssociations(List<LicenseConfigurationAssociation>)
         */
        Builder licenseConfigurationAssociations(
                Consumer<LicenseConfigurationAssociation.Builder>... licenseConfigurationAssociations);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<LicenseConfigurationAssociation> licenseConfigurationAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationsForLicenseConfigurationResponse model) {
            super(model);
            licenseConfigurationAssociations(model.licenseConfigurationAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<LicenseConfigurationAssociation.Builder> getLicenseConfigurationAssociations() {
            if (licenseConfigurationAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseConfigurationAssociations != null ? licenseConfigurationAssociations.stream()
                    .map(LicenseConfigurationAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseConfigurationAssociations(
                Collection<LicenseConfigurationAssociation> licenseConfigurationAssociations) {
            this.licenseConfigurationAssociations = LicenseConfigurationAssociationsCopier.copy(licenseConfigurationAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationAssociations(LicenseConfigurationAssociation... licenseConfigurationAssociations) {
            licenseConfigurationAssociations(Arrays.asList(licenseConfigurationAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationAssociations(
                Consumer<LicenseConfigurationAssociation.Builder>... licenseConfigurationAssociations) {
            licenseConfigurationAssociations(Stream.of(licenseConfigurationAssociations)
                    .map(c -> LicenseConfigurationAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseConfigurationAssociations(
                Collection<LicenseConfigurationAssociation.BuilderImpl> licenseConfigurationAssociations) {
            this.licenseConfigurationAssociations = LicenseConfigurationAssociationsCopier
                    .copyFromBuilder(licenseConfigurationAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociationsForLicenseConfigurationResponse build() {
            return new ListAssociationsForLicenseConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
