/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLicenseSpecificationsForResourceResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListLicenseSpecificationsForResourceResponse.Builder, ListLicenseSpecificationsForResourceResponse> {
    private static final SdkField<List<LicenseSpecification>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LicenseSpecification>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(ListLicenseSpecificationsForResourceResponse::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLicenseSpecificationsForResourceResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_SPECIFICATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LicenseSpecification> licenseSpecifications;

    private final String nextToken;

    private ListLicenseSpecificationsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.licenseSpecifications = builder.licenseSpecifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LicenseSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License configurations associated with a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License configurations associated with a resource.
     */
    public List<LicenseSpecification> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseSpecificationsForResourceResponse)) {
            return false;
        }
        ListLicenseSpecificationsForResourceResponse other = (ListLicenseSpecificationsForResourceResponse) obj;
        return hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListLicenseSpecificationsForResourceResponse")
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseSpecificationsForResourceResponse, T> g) {
        return obj -> g.apply((ListLicenseSpecificationsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLicenseSpecificationsForResourceResponse> {
        /**
         * <p>
         * License configurations associated with a resource.
         * </p>
         * 
         * @param licenseSpecifications
         *        License configurations associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<LicenseSpecification> licenseSpecifications);

        /**
         * <p>
         * License configurations associated with a resource.
         * </p>
         * 
         * @param licenseSpecifications
         *        License configurations associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(LicenseSpecification... licenseSpecifications);

        /**
         * <p>
         * License configurations associated with a resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LicenseSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<LicenseSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseSpecification>.Builder#build()} is called immediately
         * and its result is passed to {@link #licenseSpecifications(List<LicenseSpecification>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on {@link List<LicenseSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(List<LicenseSpecification>)
         */
        Builder licenseSpecifications(Consumer<LicenseSpecification.Builder>... licenseSpecifications);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<LicenseSpecification> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseSpecificationsForResourceResponse model) {
            super(model);
            licenseSpecifications(model.licenseSpecifications);
            nextToken(model.nextToken);
        }

        public final Collection<LicenseSpecification.Builder> getLicenseSpecifications() {
            if (licenseSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseSpecifications != null ? licenseSpecifications.stream().map(LicenseSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseSpecifications(Collection<LicenseSpecification> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LicenseSpecification... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LicenseSpecification.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> LicenseSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseSpecifications(Collection<LicenseSpecification.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(licenseSpecifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLicenseSpecificationsForResourceResponse build() {
            return new ListLicenseSpecificationsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
