/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata associated with received licenses and grants.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReceivedMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ReceivedMetadata.Builder, ReceivedMetadata> {
    private static final SdkField<String> RECEIVED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReceivedStatus").getter(getter(ReceivedMetadata::receivedStatusAsString))
            .setter(setter(Builder::receivedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedStatus").build()).build();

    private static final SdkField<List<String>> ALLOWED_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOperations")
            .getter(getter(ReceivedMetadata::allowedOperationsAsStrings))
            .setter(setter(Builder::allowedOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECEIVED_STATUS_FIELD,
            ALLOWED_OPERATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String receivedStatus;

    private final List<String> allowedOperations;

    private ReceivedMetadata(BuilderImpl builder) {
        this.receivedStatus = builder.receivedStatus;
        this.allowedOperations = builder.allowedOperations;
    }

    /**
     * <p>
     * Received status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #receivedStatus}
     * will return {@link ReceivedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #receivedStatusAsString}.
     * </p>
     * 
     * @return Received status.
     * @see ReceivedStatus
     */
    public ReceivedStatus receivedStatus() {
        return ReceivedStatus.fromValue(receivedStatus);
    }

    /**
     * <p>
     * Received status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #receivedStatus}
     * will return {@link ReceivedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #receivedStatusAsString}.
     * </p>
     * 
     * @return Received status.
     * @see ReceivedStatus
     */
    public String receivedStatusAsString() {
        return receivedStatus;
    }

    /**
     * <p>
     * Allowed operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Allowed operations.
     */
    public List<AllowedOperation> allowedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(allowedOperations);
    }

    /**
     * Returns true if the AllowedOperations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAllowedOperations() {
        return allowedOperations != null && !(allowedOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allowed operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Allowed operations.
     */
    public List<String> allowedOperationsAsStrings() {
        return allowedOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(receivedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOperations() ? allowedOperationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceivedMetadata)) {
            return false;
        }
        ReceivedMetadata other = (ReceivedMetadata) obj;
        return Objects.equals(receivedStatusAsString(), other.receivedStatusAsString())
                && hasAllowedOperations() == other.hasAllowedOperations()
                && Objects.equals(allowedOperationsAsStrings(), other.allowedOperationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReceivedMetadata").add("ReceivedStatus", receivedStatusAsString())
                .add("AllowedOperations", hasAllowedOperations() ? allowedOperationsAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReceivedStatus":
            return Optional.ofNullable(clazz.cast(receivedStatusAsString()));
        case "AllowedOperations":
            return Optional.ofNullable(clazz.cast(allowedOperationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReceivedMetadata, T> g) {
        return obj -> g.apply((ReceivedMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReceivedMetadata> {
        /**
         * <p>
         * Received status.
         * </p>
         * 
         * @param receivedStatus
         *        Received status.
         * @see ReceivedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceivedStatus
         */
        Builder receivedStatus(String receivedStatus);

        /**
         * <p>
         * Received status.
         * </p>
         * 
         * @param receivedStatus
         *        Received status.
         * @see ReceivedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceivedStatus
         */
        Builder receivedStatus(ReceivedStatus receivedStatus);

        /**
         * <p>
         * Allowed operations.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperationsWithStrings(Collection<String> allowedOperations);

        /**
         * <p>
         * Allowed operations.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperationsWithStrings(String... allowedOperations);

        /**
         * <p>
         * Allowed operations.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperations(Collection<AllowedOperation> allowedOperations);

        /**
         * <p>
         * Allowed operations.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperations(AllowedOperation... allowedOperations);
    }

    static final class BuilderImpl implements Builder {
        private String receivedStatus;

        private List<String> allowedOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReceivedMetadata model) {
            receivedStatus(model.receivedStatus);
            allowedOperationsWithStrings(model.allowedOperations);
        }

        public final String getReceivedStatus() {
            return receivedStatus;
        }

        @Override
        public final Builder receivedStatus(String receivedStatus) {
            this.receivedStatus = receivedStatus;
            return this;
        }

        @Override
        public final Builder receivedStatus(ReceivedStatus receivedStatus) {
            this.receivedStatus(receivedStatus == null ? null : receivedStatus.toString());
            return this;
        }

        public final void setReceivedStatus(String receivedStatus) {
            this.receivedStatus = receivedStatus;
        }

        public final Collection<String> getAllowedOperations() {
            if (allowedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOperations;
        }

        @Override
        public final Builder allowedOperationsWithStrings(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperationsWithStrings(String... allowedOperations) {
            allowedOperationsWithStrings(Arrays.asList(allowedOperations));
            return this;
        }

        @Override
        public final Builder allowedOperations(Collection<AllowedOperation> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copyEnumToString(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperations(AllowedOperation... allowedOperations) {
            allowedOperations(Arrays.asList(allowedOperations));
            return this;
        }

        public final void setAllowedOperations(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
        }

        @Override
        public ReceivedMetadata build() {
            return new ReceivedMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
