/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessTokenRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<GetAccessTokenRequest.Builder, GetAccessTokenRequest> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Token")
            .getter(getter(GetAccessTokenRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()).build();

    private static final SdkField<List<String>> TOKEN_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TokenProperties")
            .getter(getter(GetAccessTokenRequest::tokenProperties))
            .setter(setter(Builder::tokenProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_FIELD,
            TOKEN_PROPERTIES_FIELD));

    private final String token;

    private final List<String> tokenProperties;

    private GetAccessTokenRequest(BuilderImpl builder) {
        super(builder);
        this.token = builder.token;
        this.tokenProperties = builder.tokenProperties;
    }

    /**
     * <p>
     * Refresh token, encoded as a JWT token.
     * </p>
     * 
     * @return Refresh token, encoded as a JWT token.
     */
    public String token() {
        return token;
    }

    /**
     * Returns true if the TokenProperties property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTokenProperties() {
        return tokenProperties != null && !(tokenProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Token properties to validate against those present in the JWT token.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTokenProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Token properties to validate against those present in the JWT token.
     */
    public List<String> tokenProperties() {
        return tokenProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenProperties() ? tokenProperties() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessTokenRequest)) {
            return false;
        }
        GetAccessTokenRequest other = (GetAccessTokenRequest) obj;
        return Objects.equals(token(), other.token()) && hasTokenProperties() == other.hasTokenProperties()
                && Objects.equals(tokenProperties(), other.tokenProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAccessTokenRequest").add("Token", token())
                .add("TokenProperties", hasTokenProperties() ? tokenProperties() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Token":
            return Optional.ofNullable(clazz.cast(token()));
        case "TokenProperties":
            return Optional.ofNullable(clazz.cast(tokenProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessTokenRequest, T> g) {
        return obj -> g.apply((GetAccessTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessTokenRequest> {
        /**
         * <p>
         * Refresh token, encoded as a JWT token.
         * </p>
         * 
         * @param token
         *        Refresh token, encoded as a JWT token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * Token properties to validate against those present in the JWT token.
         * </p>
         * 
         * @param tokenProperties
         *        Token properties to validate against those present in the JWT token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenProperties(Collection<String> tokenProperties);

        /**
         * <p>
         * Token properties to validate against those present in the JWT token.
         * </p>
         * 
         * @param tokenProperties
         *        Token properties to validate against those present in the JWT token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenProperties(String... tokenProperties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String token;

        private List<String> tokenProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessTokenRequest model) {
            super(model);
            token(model.token);
            tokenProperties(model.tokenProperties);
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final Collection<String> getTokenProperties() {
            if (tokenProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return tokenProperties;
        }

        @Override
        public final Builder tokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenProperties(String... tokenProperties) {
            tokenProperties(Arrays.asList(tokenProperties));
            return this;
        }

        public final void setTokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccessTokenRequest build() {
            return new GetAccessTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
