/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TokenData implements SdkPojo, Serializable, ToCopyableBuilder<TokenData.Builder, TokenData> {
    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenId").getter(getter(TokenData::tokenId)).setter(setter(Builder::tokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenId").build()).build();

    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenType").getter(getter(TokenData::tokenType)).setter(setter(Builder::tokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenType").build()).build();

    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(TokenData::licenseArn)).setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<String> EXPIRATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationTime").getter(getter(TokenData::expirationTime)).setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final SdkField<List<String>> TOKEN_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TokenProperties")
            .getter(getter(TokenData::tokenProperties))
            .setter(setter(Builder::tokenProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoleArns")
            .getter(getter(TokenData::roleArns))
            .setter(setter(Builder::roleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TokenData::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_ID_FIELD,
            TOKEN_TYPE_FIELD, LICENSE_ARN_FIELD, EXPIRATION_TIME_FIELD, TOKEN_PROPERTIES_FIELD, ROLE_ARNS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tokenId;

    private final String tokenType;

    private final String licenseArn;

    private final String expirationTime;

    private final List<String> tokenProperties;

    private final List<String> roleArns;

    private final String status;

    private TokenData(BuilderImpl builder) {
        this.tokenId = builder.tokenId;
        this.tokenType = builder.tokenType;
        this.licenseArn = builder.licenseArn;
        this.expirationTime = builder.expirationTime;
        this.tokenProperties = builder.tokenProperties;
        this.roleArns = builder.roleArns;
        this.status = builder.status;
    }

    /**
     * <p>
     * Token ID.
     * </p>
     * 
     * @return Token ID.
     */
    public String tokenId() {
        return tokenId;
    }

    /**
     * <p>
     * Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.
     * </p>
     * 
     * @return Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.
     */
    public String tokenType() {
        return tokenType;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license.
     */
    public String licenseArn() {
        return licenseArn;
    }

    /**
     * <p>
     * Token expiration time, in ISO8601-UTC format.
     * </p>
     * 
     * @return Token expiration time, in ISO8601-UTC format.
     */
    public String expirationTime() {
        return expirationTime;
    }

    /**
     * Returns true if the TokenProperties property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTokenProperties() {
        return tokenProperties != null && !(tokenProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Data specified by the caller.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTokenProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Data specified by the caller.
     */
    public List<String> tokenProperties() {
        return tokenProperties;
    }

    /**
     * Returns true if the RoleArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRoleArns() {
        return roleArns != null && !(roleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon Resource Names (ARN) of the roles included in the token.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRoleArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Amazon Resource Names (ARN) of the roles included in the token.
     */
    public List<String> roleArns() {
        return roleArns;
    }

    /**
     * <p>
     * Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.
     * </p>
     * 
     * @return Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenProperties() ? tokenProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleArns() ? roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenData)) {
            return false;
        }
        TokenData other = (TokenData) obj;
        return Objects.equals(tokenId(), other.tokenId()) && Objects.equals(tokenType(), other.tokenType())
                && Objects.equals(licenseArn(), other.licenseArn()) && Objects.equals(expirationTime(), other.expirationTime())
                && hasTokenProperties() == other.hasTokenProperties()
                && Objects.equals(tokenProperties(), other.tokenProperties()) && hasRoleArns() == other.hasRoleArns()
                && Objects.equals(roleArns(), other.roleArns()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TokenData").add("TokenId", tokenId()).add("TokenType", tokenType())
                .add("LicenseArn", licenseArn()).add("ExpirationTime", expirationTime())
                .add("TokenProperties", hasTokenProperties() ? tokenProperties() : null)
                .add("RoleArns", hasRoleArns() ? roleArns() : null).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TokenId":
            return Optional.ofNullable(clazz.cast(tokenId()));
        case "TokenType":
            return Optional.ofNullable(clazz.cast(tokenType()));
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "TokenProperties":
            return Optional.ofNullable(clazz.cast(tokenProperties()));
        case "RoleArns":
            return Optional.ofNullable(clazz.cast(roleArns()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TokenData, T> g) {
        return obj -> g.apply((TokenData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TokenData> {
        /**
         * <p>
         * Token ID.
         * </p>
         * 
         * @param tokenId
         *        Token ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenId(String tokenId);

        /**
         * <p>
         * Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.
         * </p>
         * 
         * @param tokenType
         *        Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenType(String tokenType);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the license.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * Token expiration time, in ISO8601-UTC format.
         * </p>
         * 
         * @param expirationTime
         *        Token expiration time, in ISO8601-UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(String expirationTime);

        /**
         * <p>
         * Data specified by the caller.
         * </p>
         * 
         * @param tokenProperties
         *        Data specified by the caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenProperties(Collection<String> tokenProperties);

        /**
         * <p>
         * Data specified by the caller.
         * </p>
         * 
         * @param tokenProperties
         *        Data specified by the caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenProperties(String... tokenProperties);

        /**
         * <p>
         * Amazon Resource Names (ARN) of the roles included in the token.
         * </p>
         * 
         * @param roleArns
         *        Amazon Resource Names (ARN) of the roles included in the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(Collection<String> roleArns);

        /**
         * <p>
         * Amazon Resource Names (ARN) of the roles included in the token.
         * </p>
         * 
         * @param roleArns
         *        Amazon Resource Names (ARN) of the roles included in the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(String... roleArns);

        /**
         * <p>
         * Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.
         * </p>
         * 
         * @param status
         *        Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String tokenId;

        private String tokenType;

        private String licenseArn;

        private String expirationTime;

        private List<String> tokenProperties = DefaultSdkAutoConstructList.getInstance();

        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TokenData model) {
            tokenId(model.tokenId);
            tokenType(model.tokenType);
            licenseArn(model.licenseArn);
            expirationTime(model.expirationTime);
            tokenProperties(model.tokenProperties);
            roleArns(model.roleArns);
            status(model.status);
        }

        public final String getTokenId() {
            return tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        public final String getTokenType() {
            return tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        public final String getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final Collection<String> getTokenProperties() {
            if (tokenProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return tokenProperties;
        }

        @Override
        public final Builder tokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenProperties(String... tokenProperties) {
            tokenProperties(Arrays.asList(tokenProperties));
            return this;
        }

        public final void setTokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
        }

        public final Collection<String> getRoleArns() {
            if (roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return roleArns;
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String... roleArns) {
            roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public TokenData build() {
            return new TokenData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
