/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckoutBorrowLicenseRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CheckoutBorrowLicenseRequest.Builder, CheckoutBorrowLicenseRequest> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(CheckoutBorrowLicenseRequest::licenseArn))
            .setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_FIELD = SdkField
            .<List<EntitlementData>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(CheckoutBorrowLicenseRequest::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitlementData> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitlementData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIGITAL_SIGNATURE_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DigitalSignatureMethod").getter(getter(CheckoutBorrowLicenseRequest::digitalSignatureMethodAsString))
            .setter(setter(Builder::digitalSignatureMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigitalSignatureMethod").build())
            .build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(CheckoutBorrowLicenseRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<List<Metadata>> CHECKOUT_METADATA_FIELD = SdkField
            .<List<Metadata>> builder(MarshallingType.LIST)
            .memberName("CheckoutMetadata")
            .getter(getter(CheckoutBorrowLicenseRequest::checkoutMetadata))
            .setter(setter(Builder::checkoutMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CheckoutBorrowLicenseRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD,
            ENTITLEMENTS_FIELD, DIGITAL_SIGNATURE_METHOD_FIELD, NODE_ID_FIELD, CHECKOUT_METADATA_FIELD, CLIENT_TOKEN_FIELD));

    private final String licenseArn;

    private final List<EntitlementData> entitlements;

    private final String digitalSignatureMethod;

    private final String nodeId;

    private final List<Metadata> checkoutMetadata;

    private final String clientToken;

    private CheckoutBorrowLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.entitlements = builder.entitlements;
        this.digitalSignatureMethod = builder.digitalSignatureMethod;
        this.nodeId = builder.nodeId;
        this.checkoutMetadata = builder.checkoutMetadata;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.
     */
    public String licenseArn() {
        return licenseArn;
    }

    /**
     * Returns true if the Entitlements property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License entitlements. Partial checkouts are not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntitlements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License entitlements. Partial checkouts are not supported.
     */
    public List<EntitlementData> entitlements() {
        return entitlements;
    }

    /**
     * <p>
     * Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information,
     * see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #digitalSignatureMethod} will return {@link DigitalSignatureMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #digitalSignatureMethodAsString}.
     * </p>
     * 
     * @return Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more
     *         information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature
     *         with RSASSA-PSS</a>.
     * @see DigitalSignatureMethod
     */
    public DigitalSignatureMethod digitalSignatureMethod() {
        return DigitalSignatureMethod.fromValue(digitalSignatureMethod);
    }

    /**
     * <p>
     * Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information,
     * see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #digitalSignatureMethod} will return {@link DigitalSignatureMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #digitalSignatureMethodAsString}.
     * </p>
     * 
     * @return Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more
     *         information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature
     *         with RSASSA-PSS</a>.
     * @see DigitalSignatureMethod
     */
    public String digitalSignatureMethodAsString() {
        return digitalSignatureMethod;
    }

    /**
     * <p>
     * Node ID.
     * </p>
     * 
     * @return Node ID.
     */
    public String nodeId() {
        return nodeId;
    }

    /**
     * Returns true if the CheckoutMetadata property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCheckoutMetadata() {
        return checkoutMetadata != null && !(checkoutMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about constraints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCheckoutMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about constraints.
     */
    public List<Metadata> checkoutMetadata() {
        return checkoutMetadata;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(digitalSignatureMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCheckoutMetadata() ? checkoutMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutBorrowLicenseRequest)) {
            return false;
        }
        CheckoutBorrowLicenseRequest other = (CheckoutBorrowLicenseRequest) obj;
        return Objects.equals(licenseArn(), other.licenseArn()) && hasEntitlements() == other.hasEntitlements()
                && Objects.equals(entitlements(), other.entitlements())
                && Objects.equals(digitalSignatureMethodAsString(), other.digitalSignatureMethodAsString())
                && Objects.equals(nodeId(), other.nodeId()) && hasCheckoutMetadata() == other.hasCheckoutMetadata()
                && Objects.equals(checkoutMetadata(), other.checkoutMetadata())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CheckoutBorrowLicenseRequest").add("LicenseArn", licenseArn())
                .add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("DigitalSignatureMethod", digitalSignatureMethodAsString()).add("NodeId", nodeId())
                .add("CheckoutMetadata", hasCheckoutMetadata() ? checkoutMetadata() : null).add("ClientToken", clientToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "DigitalSignatureMethod":
            return Optional.ofNullable(clazz.cast(digitalSignatureMethodAsString()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "CheckoutMetadata":
            return Optional.ofNullable(clazz.cast(checkoutMetadata()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckoutBorrowLicenseRequest, T> g) {
        return obj -> g.apply((CheckoutBorrowLicenseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckoutBorrowLicenseRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * License entitlements. Partial checkouts are not supported.
         * </p>
         * 
         * @param entitlements
         *        License entitlements. Partial checkouts are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<EntitlementData> entitlements);

        /**
         * <p>
         * License entitlements. Partial checkouts are not supported.
         * </p>
         * 
         * @param entitlements
         *        License entitlements. Partial checkouts are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(EntitlementData... entitlements);

        /**
         * <p>
         * License entitlements. Partial checkouts are not supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntitlementData>.Builder} avoiding the need
         * to create one manually via {@link List<EntitlementData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntitlementData>.Builder#build()} is called immediately and
         * its result is passed to {@link #entitlements(List<EntitlementData>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<EntitlementData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<EntitlementData>)
         */
        Builder entitlements(Consumer<EntitlementData.Builder>... entitlements);

        /**
         * <p>
         * Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more
         * information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with
         * RSASSA-PSS</a>.
         * </p>
         * 
         * @param digitalSignatureMethod
         *        Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more
         *        information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature
         *        with RSASSA-PSS</a>.
         * @see DigitalSignatureMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DigitalSignatureMethod
         */
        Builder digitalSignatureMethod(String digitalSignatureMethod);

        /**
         * <p>
         * Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more
         * information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with
         * RSASSA-PSS</a>.
         * </p>
         * 
         * @param digitalSignatureMethod
         *        Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more
         *        information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature
         *        with RSASSA-PSS</a>.
         * @see DigitalSignatureMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DigitalSignatureMethod
         */
        Builder digitalSignatureMethod(DigitalSignatureMethod digitalSignatureMethod);

        /**
         * <p>
         * Node ID.
         * </p>
         * 
         * @param nodeId
         *        Node ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * Information about constraints.
         * </p>
         * 
         * @param checkoutMetadata
         *        Information about constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkoutMetadata(Collection<Metadata> checkoutMetadata);

        /**
         * <p>
         * Information about constraints.
         * </p>
         * 
         * @param checkoutMetadata
         *        Information about constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkoutMetadata(Metadata... checkoutMetadata);

        /**
         * <p>
         * Information about constraints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Metadata>.Builder} avoiding the need to
         * create one manually via {@link List<Metadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #checkoutMetadata(List<Metadata>)}.
         * 
         * @param checkoutMetadata
         *        a consumer that will call methods on {@link List<Metadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkoutMetadata(List<Metadata>)
         */
        Builder checkoutMetadata(Consumer<Metadata.Builder>... checkoutMetadata);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseArn;

        private List<EntitlementData> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String digitalSignatureMethod;

        private String nodeId;

        private List<Metadata> checkoutMetadata = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutBorrowLicenseRequest model) {
            super(model);
            licenseArn(model.licenseArn);
            entitlements(model.entitlements);
            digitalSignatureMethod(model.digitalSignatureMethod);
            nodeId(model.nodeId);
            checkoutMetadata(model.checkoutMetadata);
            clientToken(model.clientToken);
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        public final Collection<EntitlementData.Builder> getEntitlements() {
            if (entitlements instanceof SdkAutoConstructList) {
                return null;
            }
            return entitlements != null ? entitlements.stream().map(EntitlementData::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entitlements(Collection<EntitlementData> entitlements) {
            this.entitlements = EntitlementDataListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(EntitlementData... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<EntitlementData.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> EntitlementData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<EntitlementData.BuilderImpl> entitlements) {
            this.entitlements = EntitlementDataListCopier.copyFromBuilder(entitlements);
        }

        public final String getDigitalSignatureMethod() {
            return digitalSignatureMethod;
        }

        @Override
        public final Builder digitalSignatureMethod(String digitalSignatureMethod) {
            this.digitalSignatureMethod = digitalSignatureMethod;
            return this;
        }

        @Override
        public final Builder digitalSignatureMethod(DigitalSignatureMethod digitalSignatureMethod) {
            this.digitalSignatureMethod(digitalSignatureMethod == null ? null : digitalSignatureMethod.toString());
            return this;
        }

        public final void setDigitalSignatureMethod(String digitalSignatureMethod) {
            this.digitalSignatureMethod = digitalSignatureMethod;
        }

        public final String getNodeId() {
            return nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public final Collection<Metadata.Builder> getCheckoutMetadata() {
            if (checkoutMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return checkoutMetadata != null ? checkoutMetadata.stream().map(Metadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder checkoutMetadata(Collection<Metadata> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copy(checkoutMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkoutMetadata(Metadata... checkoutMetadata) {
            checkoutMetadata(Arrays.asList(checkoutMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkoutMetadata(Consumer<Metadata.Builder>... checkoutMetadata) {
            checkoutMetadata(Stream.of(checkoutMetadata).map(c -> Metadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCheckoutMetadata(Collection<Metadata.BuilderImpl> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copyFromBuilder(checkoutMetadata);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckoutBorrowLicenseRequest build() {
            return new CheckoutBorrowLicenseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
