/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage;
import software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsageListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsageForLicenseConfigurationResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListUsageForLicenseConfigurationResponse> {
    private static final SdkField<List<LicenseConfigurationUsage>> LICENSE_CONFIGURATION_USAGE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseConfigurationUsageList").getter(ListUsageForLicenseConfigurationResponse.getter(ListUsageForLicenseConfigurationResponse::licenseConfigurationUsageList)).setter(ListUsageForLicenseConfigurationResponse.setter(Builder::licenseConfigurationUsageList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationUsageList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseConfigurationUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUsageForLicenseConfigurationResponse.getter(ListUsageForLicenseConfigurationResponse::nextToken)).setter(ListUsageForLicenseConfigurationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATION_USAGE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<LicenseConfigurationUsage> licenseConfigurationUsageList;
    private final String nextToken;

    private ListUsageForLicenseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationUsageList = builder.licenseConfigurationUsageList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLicenseConfigurationUsageList() {
        return this.licenseConfigurationUsageList != null && !(this.licenseConfigurationUsageList instanceof SdkAutoConstructList);
    }

    public final List<LicenseConfigurationUsage> licenseConfigurationUsageList() {
        return this.licenseConfigurationUsageList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseConfigurationUsageList() ? this.licenseConfigurationUsageList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsageForLicenseConfigurationResponse)) {
            return false;
        }
        ListUsageForLicenseConfigurationResponse other = (ListUsageForLicenseConfigurationResponse)((Object)obj);
        return this.hasLicenseConfigurationUsageList() == other.hasLicenseConfigurationUsageList() && Objects.equals(this.licenseConfigurationUsageList(), other.licenseConfigurationUsageList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsageForLicenseConfigurationResponse").add("LicenseConfigurationUsageList", this.hasLicenseConfigurationUsageList() ? this.licenseConfigurationUsageList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConfigurationUsageList": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationUsageList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsageForLicenseConfigurationResponse, T> g) {
        return obj -> g.apply((ListUsageForLicenseConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseConfigurationUsage> licenseConfigurationUsageList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsageForLicenseConfigurationResponse model) {
            super(model);
            this.licenseConfigurationUsageList(model.licenseConfigurationUsageList);
            this.nextToken(model.nextToken);
        }

        public final Collection<LicenseConfigurationUsage.Builder> getLicenseConfigurationUsageList() {
            if (this.licenseConfigurationUsageList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseConfigurationUsageList != null ? (Collection)this.licenseConfigurationUsageList.stream().map(LicenseConfigurationUsage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseConfigurationUsageList(Collection<LicenseConfigurationUsage> licenseConfigurationUsageList) {
            this.licenseConfigurationUsageList = LicenseConfigurationUsageListCopier.copy(licenseConfigurationUsageList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationUsageList(LicenseConfigurationUsage ... licenseConfigurationUsageList) {
            this.licenseConfigurationUsageList(Arrays.asList(licenseConfigurationUsageList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationUsageList(Consumer<LicenseConfigurationUsage.Builder> ... licenseConfigurationUsageList) {
            this.licenseConfigurationUsageList(Stream.of(licenseConfigurationUsageList).map(c -> (LicenseConfigurationUsage)((LicenseConfigurationUsage.Builder)LicenseConfigurationUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseConfigurationUsageList(Collection<LicenseConfigurationUsage.BuilderImpl> licenseConfigurationUsageList) {
            this.licenseConfigurationUsageList = LicenseConfigurationUsageListCopier.copyFromBuilder(licenseConfigurationUsageList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUsageForLicenseConfigurationResponse build() {
            return new ListUsageForLicenseConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsageForLicenseConfigurationResponse> {
        public Builder licenseConfigurationUsageList(Collection<LicenseConfigurationUsage> var1);

        public Builder licenseConfigurationUsageList(LicenseConfigurationUsage ... var1);

        public Builder licenseConfigurationUsageList(Consumer<LicenseConfigurationUsage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

