/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLicenseConfigurationsRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<ListLicenseConfigurationsRequest.Builder, ListLicenseConfigurationsRequest> {
    private static final SdkField<List<String>> LICENSE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LicenseConfigurationArns")
            .getter(getter(ListLicenseConfigurationsRequest::licenseConfigurationArns))
            .setter(setter(Builder::licenseConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLicenseConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLicenseConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListLicenseConfigurationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_ARNS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private final List<String> licenseConfigurationArns;

    private final Integer maxResults;

    private final String nextToken;

    private final List<Filter> filters;

    private ListLicenseConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationArns = builder.licenseConfigurationArns;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * Returns true if the LicenseConfigurationArns property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLicenseConfigurationArns() {
        return licenseConfigurationArns != null && !(licenseConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon Resource Names (ARN) of the license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseConfigurationArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Amazon Resource Names (ARN) of the license configurations.
     */
    public final List<String> licenseConfigurationArns() {
        return licenseConfigurationArns;
    }

    /**
     * <p>
     * Maximum number of results to return in a single call.
     * </p>
     * 
     * @return Maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters to scope the results. The following filters and logical operators are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>licenseCountingType</code> - The dimension on which licenses are counted. Possible values are
     * <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are
     * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used.
     * Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been
     * exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters to scope the results. The following filters and logical operators are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>licenseCountingType</code> - The dimension on which licenses are counted. Possible values are
     *         <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators
     *         are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is
     *         used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been
     *         exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseConfigurationArns() ? licenseConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseConfigurationsRequest)) {
            return false;
        }
        ListLicenseConfigurationsRequest other = (ListLicenseConfigurationsRequest) obj;
        return hasLicenseConfigurationArns() == other.hasLicenseConfigurationArns()
                && Objects.equals(licenseConfigurationArns(), other.licenseConfigurationArns())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLicenseConfigurationsRequest")
                .add("LicenseConfigurationArns", hasLicenseConfigurationArns() ? licenseConfigurationArns() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Filters", hasFilters() ? filters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationArns":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArns()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseConfigurationsRequest, T> g) {
        return obj -> g.apply((ListLicenseConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLicenseConfigurationsRequest> {
        /**
         * <p>
         * Amazon Resource Names (ARN) of the license configurations.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        Amazon Resource Names (ARN) of the license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns);

        /**
         * <p>
         * Amazon Resource Names (ARN) of the license configurations.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        Amazon Resource Names (ARN) of the license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(String... licenseConfigurationArns);

        /**
         * <p>
         * Maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>licenseCountingType</code> - The dimension on which licenses are counted. Possible values are
         * <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used.
         * Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been
         * exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>licenseCountingType</code> - The dimension on which licenses are counted. Possible values are
         *        <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators
         *        are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is
         *        used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have
         *        been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>licenseCountingType</code> - The dimension on which licenses are counted. Possible values are
         * <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used.
         * Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been
         * exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>licenseCountingType</code> - The dimension on which licenses are counted. Possible values are
         *        <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators
         *        are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is
         *        used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have
         *        been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>licenseCountingType</code> - The dimension on which licenses are counted. Possible values are
         * <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are
         * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used.
         * Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been
         * exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private List<String> licenseConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseConfigurationsRequest model) {
            super(model);
            licenseConfigurationArns(model.licenseConfigurationArns);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final Collection<String> getLicenseConfigurationArns() {
            if (licenseConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseConfigurationArns;
        }

        @Override
        public final Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = StringListCopier.copy(licenseConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationArns(String... licenseConfigurationArns) {
            licenseConfigurationArns(Arrays.asList(licenseConfigurationArns));
            return this;
        }

        public final void setLicenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = StringListCopier.copy(licenseConfigurationArns);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLicenseConfigurationsRequest build() {
            return new ListLicenseConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
