/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLicenseRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateLicenseRequest.Builder, CreateLicenseRequest> {
    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseName").getter(getter(CreateLicenseRequest::licenseName)).setter(setter(Builder::licenseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseName").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(CreateLicenseRequest::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> PRODUCT_SKU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductSKU").getter(getter(CreateLicenseRequest::productSKU)).setter(setter(Builder::productSKU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSKU").build()).build();

    private static final SdkField<Issuer> ISSUER_FIELD = SdkField.<Issuer> builder(MarshallingType.SDK_POJO).memberName("Issuer")
            .getter(getter(CreateLicenseRequest::issuer)).setter(setter(Builder::issuer)).constructor(Issuer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(CreateLicenseRequest::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<DatetimeRange> VALIDITY_FIELD = SdkField.<DatetimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("Validity").getter(getter(CreateLicenseRequest::validity)).setter(setter(Builder::validity))
            .constructor(DatetimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()).build();

    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<Entitlement>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(CreateLicenseRequest::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Beneficiary").getter(getter(CreateLicenseRequest::beneficiary)).setter(setter(Builder::beneficiary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()).build();

    private static final SdkField<ConsumptionConfiguration> CONSUMPTION_CONFIGURATION_FIELD = SdkField
            .<ConsumptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConsumptionConfiguration")
            .getter(getter(CreateLicenseRequest::consumptionConfiguration)).setter(setter(Builder::consumptionConfiguration))
            .constructor(ConsumptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumptionConfiguration").build())
            .build();

    private static final SdkField<List<Metadata>> LICENSE_METADATA_FIELD = SdkField
            .<List<Metadata>> builder(MarshallingType.LIST)
            .memberName("LicenseMetadata")
            .getter(getter(CreateLicenseRequest::licenseMetadata))
            .setter(setter(Builder::licenseMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateLicenseRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_NAME_FIELD,
            PRODUCT_NAME_FIELD, PRODUCT_SKU_FIELD, ISSUER_FIELD, HOME_REGION_FIELD, VALIDITY_FIELD, ENTITLEMENTS_FIELD,
            BENEFICIARY_FIELD, CONSUMPTION_CONFIGURATION_FIELD, LICENSE_METADATA_FIELD, CLIENT_TOKEN_FIELD));

    private final String licenseName;

    private final String productName;

    private final String productSKU;

    private final Issuer issuer;

    private final String homeRegion;

    private final DatetimeRange validity;

    private final List<Entitlement> entitlements;

    private final String beneficiary;

    private final ConsumptionConfiguration consumptionConfiguration;

    private final List<Metadata> licenseMetadata;

    private final String clientToken;

    private CreateLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.licenseName = builder.licenseName;
        this.productName = builder.productName;
        this.productSKU = builder.productSKU;
        this.issuer = builder.issuer;
        this.homeRegion = builder.homeRegion;
        this.validity = builder.validity;
        this.entitlements = builder.entitlements;
        this.beneficiary = builder.beneficiary;
        this.consumptionConfiguration = builder.consumptionConfiguration;
        this.licenseMetadata = builder.licenseMetadata;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * License name.
     * </p>
     * 
     * @return License name.
     */
    public final String licenseName() {
        return licenseName;
    }

    /**
     * <p>
     * Product name.
     * </p>
     * 
     * @return Product name.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * Product SKU.
     * </p>
     * 
     * @return Product SKU.
     */
    public final String productSKU() {
        return productSKU;
    }

    /**
     * <p>
     * License issuer.
     * </p>
     * 
     * @return License issuer.
     */
    public final Issuer issuer() {
        return issuer;
    }

    /**
     * <p>
     * Home Region for the license.
     * </p>
     * 
     * @return Home Region for the license.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * Date and time range during which the license is valid, in ISO8601-UTC format.
     * </p>
     * 
     * @return Date and time range during which the license is valid, in ISO8601-UTC format.
     */
    public final DatetimeRange validity() {
        return validity;
    }

    /**
     * Returns true if the Entitlements property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License entitlements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntitlements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License entitlements.
     */
    public final List<Entitlement> entitlements() {
        return entitlements;
    }

    /**
     * <p>
     * License beneficiary.
     * </p>
     * 
     * @return License beneficiary.
     */
    public final String beneficiary() {
        return beneficiary;
    }

    /**
     * <p>
     * Configuration for consumption of the license. Choose a provisional configuration for workloads running with
     * continuous connectivity. Choose a borrow configuration for workloads with offline usage.
     * </p>
     * 
     * @return Configuration for consumption of the license. Choose a provisional configuration for workloads running
     *         with continuous connectivity. Choose a borrow configuration for workloads with offline usage.
     */
    public final ConsumptionConfiguration consumptionConfiguration() {
        return consumptionConfiguration;
    }

    /**
     * Returns true if the LicenseMetadata property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLicenseMetadata() {
        return licenseMetadata != null && !(licenseMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the license.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the license.
     */
    public final List<Metadata> licenseMetadata() {
        return licenseMetadata;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseName());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(productSKU());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(beneficiary());
        hashCode = 31 * hashCode + Objects.hashCode(consumptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseMetadata() ? licenseMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseRequest)) {
            return false;
        }
        CreateLicenseRequest other = (CreateLicenseRequest) obj;
        return Objects.equals(licenseName(), other.licenseName()) && Objects.equals(productName(), other.productName())
                && Objects.equals(productSKU(), other.productSKU()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(homeRegion(), other.homeRegion()) && Objects.equals(validity(), other.validity())
                && hasEntitlements() == other.hasEntitlements() && Objects.equals(entitlements(), other.entitlements())
                && Objects.equals(beneficiary(), other.beneficiary())
                && Objects.equals(consumptionConfiguration(), other.consumptionConfiguration())
                && hasLicenseMetadata() == other.hasLicenseMetadata()
                && Objects.equals(licenseMetadata(), other.licenseMetadata())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLicenseRequest").add("LicenseName", licenseName()).add("ProductName", productName())
                .add("ProductSKU", productSKU()).add("Issuer", issuer()).add("HomeRegion", homeRegion())
                .add("Validity", validity()).add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("Beneficiary", beneficiary()).add("ConsumptionConfiguration", consumptionConfiguration())
                .add("LicenseMetadata", hasLicenseMetadata() ? licenseMetadata() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseName":
            return Optional.ofNullable(clazz.cast(licenseName()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "ProductSKU":
            return Optional.ofNullable(clazz.cast(productSKU()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "Validity":
            return Optional.ofNullable(clazz.cast(validity()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "Beneficiary":
            return Optional.ofNullable(clazz.cast(beneficiary()));
        case "ConsumptionConfiguration":
            return Optional.ofNullable(clazz.cast(consumptionConfiguration()));
        case "LicenseMetadata":
            return Optional.ofNullable(clazz.cast(licenseMetadata()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseRequest, T> g) {
        return obj -> g.apply((CreateLicenseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLicenseRequest> {
        /**
         * <p>
         * License name.
         * </p>
         * 
         * @param licenseName
         *        License name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseName(String licenseName);

        /**
         * <p>
         * Product name.
         * </p>
         * 
         * @param productName
         *        Product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * Product SKU.
         * </p>
         * 
         * @param productSKU
         *        Product SKU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productSKU(String productSKU);

        /**
         * <p>
         * License issuer.
         * </p>
         * 
         * @param issuer
         *        License issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(Issuer issuer);

        /**
         * <p>
         * License issuer.
         * </p>
         * This is a convenience that creates an instance of the {@link Issuer.Builder} avoiding the need to create one
         * manually via {@link Issuer#builder()}.
         *
         * When the {@link Consumer} completes, {@link Issuer.Builder#build()} is called immediately and its result is
         * passed to {@link #issuer(Issuer)}.
         * 
         * @param issuer
         *        a consumer that will call methods on {@link Issuer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuer(Issuer)
         */
        default Builder issuer(Consumer<Issuer.Builder> issuer) {
            return issuer(Issuer.builder().applyMutation(issuer).build());
        }

        /**
         * <p>
         * Home Region for the license.
         * </p>
         * 
         * @param homeRegion
         *        Home Region for the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * Date and time range during which the license is valid, in ISO8601-UTC format.
         * </p>
         * 
         * @param validity
         *        Date and time range during which the license is valid, in ISO8601-UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(DatetimeRange validity);

        /**
         * <p>
         * Date and time range during which the license is valid, in ISO8601-UTC format.
         * </p>
         * This is a convenience that creates an instance of the {@link DatetimeRange.Builder} avoiding the need to
         * create one manually via {@link DatetimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatetimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #validity(DatetimeRange)}.
         * 
         * @param validity
         *        a consumer that will call methods on {@link DatetimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validity(DatetimeRange)
         */
        default Builder validity(Consumer<DatetimeRange.Builder> validity) {
            return validity(DatetimeRange.builder().applyMutation(validity).build());
        }

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<Entitlement> entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Entitlement... entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Entitlement>.Builder} avoiding the need to
         * create one manually via {@link List<Entitlement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entitlement>.Builder#build()} is called immediately and its
         * result is passed to {@link #entitlements(List<Entitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<Entitlement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<Entitlement>)
         */
        Builder entitlements(Consumer<Entitlement.Builder>... entitlements);

        /**
         * <p>
         * License beneficiary.
         * </p>
         * 
         * @param beneficiary
         *        License beneficiary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beneficiary(String beneficiary);

        /**
         * <p>
         * Configuration for consumption of the license. Choose a provisional configuration for workloads running with
         * continuous connectivity. Choose a borrow configuration for workloads with offline usage.
         * </p>
         * 
         * @param consumptionConfiguration
         *        Configuration for consumption of the license. Choose a provisional configuration for workloads running
         *        with continuous connectivity. Choose a borrow configuration for workloads with offline usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration);

        /**
         * <p>
         * Configuration for consumption of the license. Choose a provisional configuration for workloads running with
         * continuous connectivity. Choose a borrow configuration for workloads with offline usage.
         * </p>
         * This is a convenience that creates an instance of the {@link ConsumptionConfiguration.Builder} avoiding the
         * need to create one manually via {@link ConsumptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConsumptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #consumptionConfiguration(ConsumptionConfiguration)}.
         * 
         * @param consumptionConfiguration
         *        a consumer that will call methods on {@link ConsumptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumptionConfiguration(ConsumptionConfiguration)
         */
        default Builder consumptionConfiguration(Consumer<ConsumptionConfiguration.Builder> consumptionConfiguration) {
            return consumptionConfiguration(ConsumptionConfiguration.builder().applyMutation(consumptionConfiguration).build());
        }

        /**
         * <p>
         * Information about the license.
         * </p>
         * 
         * @param licenseMetadata
         *        Information about the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseMetadata(Collection<Metadata> licenseMetadata);

        /**
         * <p>
         * Information about the license.
         * </p>
         * 
         * @param licenseMetadata
         *        Information about the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseMetadata(Metadata... licenseMetadata);

        /**
         * <p>
         * Information about the license.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Metadata>.Builder} avoiding the need to
         * create one manually via {@link List<Metadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #licenseMetadata(List<Metadata>)}.
         * 
         * @param licenseMetadata
         *        a consumer that will call methods on {@link List<Metadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseMetadata(List<Metadata>)
         */
        Builder licenseMetadata(Consumer<Metadata.Builder>... licenseMetadata);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseName;

        private String productName;

        private String productSKU;

        private Issuer issuer;

        private String homeRegion;

        private DatetimeRange validity;

        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String beneficiary;

        private ConsumptionConfiguration consumptionConfiguration;

        private List<Metadata> licenseMetadata = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseRequest model) {
            super(model);
            licenseName(model.licenseName);
            productName(model.productName);
            productSKU(model.productSKU);
            issuer(model.issuer);
            homeRegion(model.homeRegion);
            validity(model.validity);
            entitlements(model.entitlements);
            beneficiary(model.beneficiary);
            consumptionConfiguration(model.consumptionConfiguration);
            licenseMetadata(model.licenseMetadata);
            clientToken(model.clientToken);
        }

        public final String getLicenseName() {
            return licenseName;
        }

        @Override
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        public final String getProductName() {
            return productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        public final String getProductSKU() {
            return productSKU;
        }

        @Override
        public final Builder productSKU(String productSKU) {
            this.productSKU = productSKU;
            return this;
        }

        public final void setProductSKU(String productSKU) {
            this.productSKU = productSKU;
        }

        public final Issuer.Builder getIssuer() {
            return issuer != null ? issuer.toBuilder() : null;
        }

        @Override
        public final Builder issuer(Issuer issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(Issuer.BuilderImpl issuer) {
            this.issuer = issuer != null ? issuer.build() : null;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        public final DatetimeRange.Builder getValidity() {
            return validity != null ? validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(DatetimeRange validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(DatetimeRange.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public final Collection<Entitlement.Builder> getEntitlements() {
            if (entitlements instanceof SdkAutoConstructList) {
                return null;
            }
            return entitlements != null ? entitlements.stream().map(Entitlement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = EntitlementListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> Entitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = EntitlementListCopier.copyFromBuilder(entitlements);
        }

        public final String getBeneficiary() {
            return beneficiary;
        }

        @Override
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        public final ConsumptionConfiguration.Builder getConsumptionConfiguration() {
            return consumptionConfiguration != null ? consumptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        public final void setConsumptionConfiguration(ConsumptionConfiguration.BuilderImpl consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration != null ? consumptionConfiguration.build() : null;
        }

        public final Collection<Metadata.Builder> getLicenseMetadata() {
            if (licenseMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseMetadata != null ? licenseMetadata.stream().map(Metadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder licenseMetadata(Collection<Metadata> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copy(licenseMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Metadata... licenseMetadata) {
            licenseMetadata(Arrays.asList(licenseMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Consumer<Metadata.Builder>... licenseMetadata) {
            licenseMetadata(Stream.of(licenseMetadata).map(c -> Metadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseMetadata(Collection<Metadata.BuilderImpl> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copyFromBuilder(licenseMetadata);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseRequest build() {
            return new CreateLicenseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
