/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the entitlement usage associated with a license.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseUsage implements SdkPojo, Serializable, ToCopyableBuilder<LicenseUsage.Builder, LicenseUsage> {
    private static final SdkField<List<EntitlementUsage>> ENTITLEMENT_USAGES_FIELD = SdkField
            .<List<EntitlementUsage>> builder(MarshallingType.LIST)
            .memberName("EntitlementUsages")
            .getter(getter(LicenseUsage::entitlementUsages))
            .setter(setter(Builder::entitlementUsages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementUsages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitlementUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitlementUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENT_USAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EntitlementUsage> entitlementUsages;

    private LicenseUsage(BuilderImpl builder) {
        this.entitlementUsages = builder.entitlementUsages;
    }

    /**
     * Returns true if the EntitlementUsages property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEntitlementUsages() {
        return entitlementUsages != null && !(entitlementUsages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License entitlement usages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntitlementUsages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License entitlement usages.
     */
    public final List<EntitlementUsage> entitlementUsages() {
        return entitlementUsages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlementUsages() ? entitlementUsages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseUsage)) {
            return false;
        }
        LicenseUsage other = (LicenseUsage) obj;
        return hasEntitlementUsages() == other.hasEntitlementUsages()
                && Objects.equals(entitlementUsages(), other.entitlementUsages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseUsage").add("EntitlementUsages", hasEntitlementUsages() ? entitlementUsages() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntitlementUsages":
            return Optional.ofNullable(clazz.cast(entitlementUsages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseUsage, T> g) {
        return obj -> g.apply((LicenseUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseUsage> {
        /**
         * <p>
         * License entitlement usages.
         * </p>
         * 
         * @param entitlementUsages
         *        License entitlement usages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementUsages(Collection<EntitlementUsage> entitlementUsages);

        /**
         * <p>
         * License entitlement usages.
         * </p>
         * 
         * @param entitlementUsages
         *        License entitlement usages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementUsages(EntitlementUsage... entitlementUsages);

        /**
         * <p>
         * License entitlement usages.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntitlementUsage>.Builder} avoiding the
         * need to create one manually via {@link List<EntitlementUsage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntitlementUsage>.Builder#build()} is called immediately and
         * its result is passed to {@link #entitlementUsages(List<EntitlementUsage>)}.
         * 
         * @param entitlementUsages
         *        a consumer that will call methods on {@link List<EntitlementUsage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlementUsages(List<EntitlementUsage>)
         */
        Builder entitlementUsages(Consumer<EntitlementUsage.Builder>... entitlementUsages);
    }

    static final class BuilderImpl implements Builder {
        private List<EntitlementUsage> entitlementUsages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseUsage model) {
            entitlementUsages(model.entitlementUsages);
        }

        public final Collection<EntitlementUsage.Builder> getEntitlementUsages() {
            if (entitlementUsages instanceof SdkAutoConstructList) {
                return null;
            }
            return entitlementUsages != null ? entitlementUsages.stream().map(EntitlementUsage::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlementUsages(Collection<EntitlementUsage> entitlementUsages) {
            this.entitlementUsages = EntitlementUsageListCopier.copy(entitlementUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementUsages(EntitlementUsage... entitlementUsages) {
            entitlementUsages(Arrays.asList(entitlementUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementUsages(Consumer<EntitlementUsage.Builder>... entitlementUsages) {
            entitlementUsages(Stream.of(entitlementUsages).map(c -> EntitlementUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlementUsages(Collection<EntitlementUsage.BuilderImpl> entitlementUsages) {
            this.entitlementUsages = EntitlementUsageListCopier.copyFromBuilder(entitlementUsages);
        }

        @Override
        public LicenseUsage build() {
            return new LicenseUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
