/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the issuer of a license.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Issuer implements SdkPojo, Serializable, ToCopyableBuilder<Issuer.Builder, Issuer> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Issuer::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SIGN_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignKey").getter(getter(Issuer::signKey)).setter(setter(Builder::signKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SIGN_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String signKey;

    private Issuer(BuilderImpl builder) {
        this.name = builder.name;
        this.signKey = builder.signKey;
    }

    /**
     * <p>
     * Issuer name.
     * </p>
     * 
     * @return Issuer name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Asymmetric CMK from AWS Key Management Service. The CMK must have a key usage of sign and verify, and support the
     * RSASSA-PSS SHA-256 signing algorithm.
     * </p>
     * 
     * @return Asymmetric CMK from AWS Key Management Service. The CMK must have a key usage of sign and verify, and
     *         support the RSASSA-PSS SHA-256 signing algorithm.
     */
    public final String signKey() {
        return signKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(signKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Issuer)) {
            return false;
        }
        Issuer other = (Issuer) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(signKey(), other.signKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Issuer").add("Name", name()).add("SignKey", signKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SignKey":
            return Optional.ofNullable(clazz.cast(signKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Issuer, T> g) {
        return obj -> g.apply((Issuer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Issuer> {
        /**
         * <p>
         * Issuer name.
         * </p>
         * 
         * @param name
         *        Issuer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Asymmetric CMK from AWS Key Management Service. The CMK must have a key usage of sign and verify, and support
         * the RSASSA-PSS SHA-256 signing algorithm.
         * </p>
         * 
         * @param signKey
         *        Asymmetric CMK from AWS Key Management Service. The CMK must have a key usage of sign and verify, and
         *        support the RSASSA-PSS SHA-256 signing algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signKey(String signKey);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String signKey;

        private BuilderImpl() {
        }

        private BuilderImpl(Issuer model) {
            name(model.name);
            signKey(model.signKey);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSignKey() {
            return signKey;
        }

        @Override
        public final Builder signKey(String signKey) {
            this.signKey = signKey;
            return this;
        }

        public final void setSignKey(String signKey) {
            this.signKey = signKey;
        }

        @Override
        public Issuer build() {
            return new Issuer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
