/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGrantVersionRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateGrantVersionRequest.Builder, CreateGrantVersionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateGrantVersionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> GRANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantArn").getter(getter(CreateGrantVersionRequest::grantArn)).setter(setter(Builder::grantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantArn").build()).build();

    private static final SdkField<String> GRANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantName").getter(getter(CreateGrantVersionRequest::grantName)).setter(setter(Builder::grantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantName").build()).build();

    private static final SdkField<List<String>> ALLOWED_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOperations")
            .getter(getter(CreateGrantVersionRequest::allowedOperationsAsStrings))
            .setter(setter(Builder::allowedOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateGrantVersionRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceVersion").getter(getter(CreateGrantVersionRequest::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GRANT_ARN_FIELD, GRANT_NAME_FIELD, ALLOWED_OPERATIONS_FIELD, STATUS_FIELD, SOURCE_VERSION_FIELD));

    private final String clientToken;

    private final String grantArn;

    private final String grantName;

    private final List<String> allowedOperations;

    private final String status;

    private final String sourceVersion;

    private CreateGrantVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.grantArn = builder.grantArn;
        this.grantName = builder.grantName;
        this.allowedOperations = builder.allowedOperations;
        this.status = builder.status;
        this.sourceVersion = builder.sourceVersion;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the grant.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the grant.
     */
    public final String grantArn() {
        return grantArn;
    }

    /**
     * <p>
     * Grant name.
     * </p>
     * 
     * @return Grant name.
     */
    public final String grantName() {
        return grantName;
    }

    /**
     * <p>
     * Allowed operations for the grant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Allowed operations for the grant.
     */
    public final List<AllowedOperation> allowedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(allowedOperations);
    }

    /**
     * Returns true if the AllowedOperations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAllowedOperations() {
        return allowedOperations != null && !(allowedOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allowed operations for the grant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Allowed operations for the grant.
     */
    public final List<String> allowedOperationsAsStrings() {
        return allowedOperations;
    }

    /**
     * <p>
     * Grant status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Grant status.
     * @see GrantStatus
     */
    public final GrantStatus status() {
        return GrantStatus.fromValue(status);
    }

    /**
     * <p>
     * Grant status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Grant status.
     * @see GrantStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Current version of the grant.
     * </p>
     * 
     * @return Current version of the grant.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(grantArn());
        hashCode = 31 * hashCode + Objects.hashCode(grantName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOperations() ? allowedOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantVersionRequest)) {
            return false;
        }
        CreateGrantVersionRequest other = (CreateGrantVersionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(grantArn(), other.grantArn())
                && Objects.equals(grantName(), other.grantName()) && hasAllowedOperations() == other.hasAllowedOperations()
                && Objects.equals(allowedOperationsAsStrings(), other.allowedOperationsAsStrings())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceVersion(), other.sourceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGrantVersionRequest").add("ClientToken", clientToken()).add("GrantArn", grantArn())
                .add("GrantName", grantName())
                .add("AllowedOperations", hasAllowedOperations() ? allowedOperationsAsStrings() : null)
                .add("Status", statusAsString()).add("SourceVersion", sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "GrantArn":
            return Optional.ofNullable(clazz.cast(grantArn()));
        case "GrantName":
            return Optional.ofNullable(clazz.cast(grantName()));
        case "AllowedOperations":
            return Optional.ofNullable(clazz.cast(allowedOperationsAsStrings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantVersionRequest, T> g) {
        return obj -> g.apply((CreateGrantVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGrantVersionRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the grant.
         * </p>
         * 
         * @param grantArn
         *        Amazon Resource Name (ARN) of the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantArn(String grantArn);

        /**
         * <p>
         * Grant name.
         * </p>
         * 
         * @param grantName
         *        Grant name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantName(String grantName);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperationsWithStrings(Collection<String> allowedOperations);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperationsWithStrings(String... allowedOperations);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperations(Collection<AllowedOperation> allowedOperations);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperations(AllowedOperation... allowedOperations);

        /**
         * <p>
         * Grant status.
         * </p>
         * 
         * @param status
         *        Grant status.
         * @see GrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Grant status.
         * </p>
         * 
         * @param status
         *        Grant status.
         * @see GrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantStatus
         */
        Builder status(GrantStatus status);

        /**
         * <p>
         * Current version of the grant.
         * </p>
         * 
         * @param sourceVersion
         *        Current version of the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String grantArn;

        private String grantName;

        private List<String> allowedOperations = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantVersionRequest model) {
            super(model);
            clientToken(model.clientToken);
            grantArn(model.grantArn);
            grantName(model.grantName);
            allowedOperationsWithStrings(model.allowedOperations);
            status(model.status);
            sourceVersion(model.sourceVersion);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getGrantArn() {
            return grantArn;
        }

        @Override
        public final Builder grantArn(String grantArn) {
            this.grantArn = grantArn;
            return this;
        }

        public final void setGrantArn(String grantArn) {
            this.grantArn = grantArn;
        }

        public final String getGrantName() {
            return grantName;
        }

        @Override
        public final Builder grantName(String grantName) {
            this.grantName = grantName;
            return this;
        }

        public final void setGrantName(String grantName) {
            this.grantName = grantName;
        }

        public final Collection<String> getAllowedOperations() {
            if (allowedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOperations;
        }

        @Override
        public final Builder allowedOperationsWithStrings(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperationsWithStrings(String... allowedOperations) {
            allowedOperationsWithStrings(Arrays.asList(allowedOperations));
            return this;
        }

        @Override
        public final Builder allowedOperations(Collection<AllowedOperation> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copyEnumToString(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperations(AllowedOperation... allowedOperations) {
            allowedOperations(Arrays.asList(allowedOperations));
            return this;
        }

        public final void setAllowedOperations(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGrantVersionRequest build() {
            return new CreateGrantVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
