/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceInventoryResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListResourceInventoryResponse.Builder, ListResourceInventoryResponse> {
    private static final SdkField<List<ResourceInventory>> RESOURCE_INVENTORY_LIST_FIELD = SdkField
            .<List<ResourceInventory>> builder(MarshallingType.LIST)
            .memberName("ResourceInventoryList")
            .getter(getter(ListResourceInventoryResponse::resourceInventoryList))
            .setter(setter(Builder::resourceInventoryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceInventoryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceInventory> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceInventory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceInventoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_INVENTORY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ResourceInventory> resourceInventoryList;

    private final String nextToken;

    private ListResourceInventoryResponse(BuilderImpl builder) {
        super(builder);
        this.resourceInventoryList = builder.resourceInventoryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ResourceInventoryList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResourceInventoryList() {
        return resourceInventoryList != null && !(resourceInventoryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceInventoryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the resources.
     */
    public final List<ResourceInventory> resourceInventoryList() {
        return resourceInventoryList;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceInventoryList() ? resourceInventoryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceInventoryResponse)) {
            return false;
        }
        ListResourceInventoryResponse other = (ListResourceInventoryResponse) obj;
        return hasResourceInventoryList() == other.hasResourceInventoryList()
                && Objects.equals(resourceInventoryList(), other.resourceInventoryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceInventoryResponse")
                .add("ResourceInventoryList", hasResourceInventoryList() ? resourceInventoryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceInventoryList":
            return Optional.ofNullable(clazz.cast(resourceInventoryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceInventoryResponse, T> g) {
        return obj -> g.apply((ListResourceInventoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceInventoryResponse> {
        /**
         * <p>
         * Information about the resources.
         * </p>
         * 
         * @param resourceInventoryList
         *        Information about the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceInventoryList(Collection<ResourceInventory> resourceInventoryList);

        /**
         * <p>
         * Information about the resources.
         * </p>
         * 
         * @param resourceInventoryList
         *        Information about the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceInventoryList(ResourceInventory... resourceInventoryList);

        /**
         * <p>
         * Information about the resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceInventory>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceInventory>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceInventory>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceInventoryList(List<ResourceInventory>)}.
         * 
         * @param resourceInventoryList
         *        a consumer that will call methods on {@link List<ResourceInventory>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceInventoryList(List<ResourceInventory>)
         */
        Builder resourceInventoryList(Consumer<ResourceInventory.Builder>... resourceInventoryList);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<ResourceInventory> resourceInventoryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceInventoryResponse model) {
            super(model);
            resourceInventoryList(model.resourceInventoryList);
            nextToken(model.nextToken);
        }

        public final Collection<ResourceInventory.Builder> getResourceInventoryList() {
            if (resourceInventoryList instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceInventoryList != null ? resourceInventoryList.stream().map(ResourceInventory::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceInventoryList(Collection<ResourceInventory> resourceInventoryList) {
            this.resourceInventoryList = ResourceInventoryListCopier.copy(resourceInventoryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceInventoryList(ResourceInventory... resourceInventoryList) {
            resourceInventoryList(Arrays.asList(resourceInventoryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceInventoryList(Consumer<ResourceInventory.Builder>... resourceInventoryList) {
            resourceInventoryList(Stream.of(resourceInventoryList).map(c -> ResourceInventory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceInventoryList(Collection<ResourceInventory.BuilderImpl> resourceInventoryList) {
            this.resourceInventoryList = ResourceInventoryListCopier.copyFromBuilder(resourceInventoryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceInventoryResponse build() {
            return new ListResourceInventoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
