/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTokensResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListTokensResponse.Builder, ListTokensResponse> {
    private static final SdkField<List<TokenData>> TOKENS_FIELD = SdkField
            .<List<TokenData>> builder(MarshallingType.LIST)
            .memberName("Tokens")
            .getter(getter(ListTokensResponse::tokens))
            .setter(setter(Builder::tokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tokens").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TokenData> builder(MarshallingType.SDK_POJO)
                                            .constructor(TokenData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTokensResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOKENS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TokenData> tokens;

    private final String nextToken;

    private ListTokensResponse(BuilderImpl builder) {
        super(builder);
        this.tokens = builder.tokens;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Tokens property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTokens() {
        return tokens != null && !(tokens instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Received token details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTokens()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Received token details.
     */
    public final List<TokenData> tokens() {
        return tokens;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTokens() ? tokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTokensResponse)) {
            return false;
        }
        ListTokensResponse other = (ListTokensResponse) obj;
        return hasTokens() == other.hasTokens() && Objects.equals(tokens(), other.tokens())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTokensResponse").add("Tokens", hasTokens() ? tokens() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tokens":
            return Optional.ofNullable(clazz.cast(tokens()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTokensResponse, T> g) {
        return obj -> g.apply((ListTokensResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTokensResponse> {
        /**
         * <p>
         * Received token details.
         * </p>
         * 
         * @param tokens
         *        Received token details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokens(Collection<TokenData> tokens);

        /**
         * <p>
         * Received token details.
         * </p>
         * 
         * @param tokens
         *        Received token details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokens(TokenData... tokens);

        /**
         * <p>
         * Received token details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TokenData>.Builder} avoiding the need to
         * create one manually via {@link List<TokenData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TokenData>.Builder#build()} is called immediately and its
         * result is passed to {@link #tokens(List<TokenData>)}.
         * 
         * @param tokens
         *        a consumer that will call methods on {@link List<TokenData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokens(List<TokenData>)
         */
        Builder tokens(Consumer<TokenData.Builder>... tokens);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<TokenData> tokens = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTokensResponse model) {
            super(model);
            tokens(model.tokens);
            nextToken(model.nextToken);
        }

        public final Collection<TokenData.Builder> getTokens() {
            if (tokens instanceof SdkAutoConstructList) {
                return null;
            }
            return tokens != null ? tokens.stream().map(TokenData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tokens(Collection<TokenData> tokens) {
            this.tokens = TokenListCopier.copy(tokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokens(TokenData... tokens) {
            tokens(Arrays.asList(tokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokens(Consumer<TokenData.Builder>... tokens) {
            tokens(Stream.of(tokens).map(c -> TokenData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTokens(Collection<TokenData.BuilderImpl> tokens) {
            this.tokens = TokenListCopier.copyFromBuilder(tokens);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTokensResponse build() {
            return new ListTokensResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
