/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Usage associated with an entitlement resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntitlementUsage implements SdkPojo, Serializable,
        ToCopyableBuilder<EntitlementUsage.Builder, EntitlementUsage> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EntitlementUsage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CONSUMED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumedValue").getter(getter(EntitlementUsage::consumedValue)).setter(setter(Builder::consumedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedValue").build()).build();

    private static final SdkField<String> MAX_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxCount").getter(getter(EntitlementUsage::maxCount)).setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCount").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(EntitlementUsage::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONSUMED_VALUE_FIELD, MAX_COUNT_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String consumedValue;

    private final String maxCount;

    private final String unit;

    private EntitlementUsage(BuilderImpl builder) {
        this.name = builder.name;
        this.consumedValue = builder.consumedValue;
        this.maxCount = builder.maxCount;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * Entitlement usage name.
     * </p>
     * 
     * @return Entitlement usage name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Resource usage consumed.
     * </p>
     * 
     * @return Resource usage consumed.
     */
    public final String consumedValue() {
        return consumedValue;
    }

    /**
     * <p>
     * Maximum entitlement usage count.
     * </p>
     * 
     * @return Maximum entitlement usage count.
     */
    public final String maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * Entitlement usage unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link EntitlementDataUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Entitlement usage unit.
     * @see EntitlementDataUnit
     */
    public final EntitlementDataUnit unit() {
        return EntitlementDataUnit.fromValue(unit);
    }

    /**
     * <p>
     * Entitlement usage unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link EntitlementDataUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Entitlement usage unit.
     * @see EntitlementDataUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(consumedValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitlementUsage)) {
            return false;
        }
        EntitlementUsage other = (EntitlementUsage) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(consumedValue(), other.consumedValue())
                && Objects.equals(maxCount(), other.maxCount()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntitlementUsage").add("Name", name()).add("ConsumedValue", consumedValue())
                .add("MaxCount", maxCount()).add("Unit", unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ConsumedValue":
            return Optional.ofNullable(clazz.cast(consumedValue()));
        case "MaxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntitlementUsage, T> g) {
        return obj -> g.apply((EntitlementUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntitlementUsage> {
        /**
         * <p>
         * Entitlement usage name.
         * </p>
         * 
         * @param name
         *        Entitlement usage name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Resource usage consumed.
         * </p>
         * 
         * @param consumedValue
         *        Resource usage consumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedValue(String consumedValue);

        /**
         * <p>
         * Maximum entitlement usage count.
         * </p>
         * 
         * @param maxCount
         *        Maximum entitlement usage count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(String maxCount);

        /**
         * <p>
         * Entitlement usage unit.
         * </p>
         * 
         * @param unit
         *        Entitlement usage unit.
         * @see EntitlementDataUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementDataUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * Entitlement usage unit.
         * </p>
         * 
         * @param unit
         *        Entitlement usage unit.
         * @see EntitlementDataUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementDataUnit
         */
        Builder unit(EntitlementDataUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String consumedValue;

        private String maxCount;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitlementUsage model) {
            name(model.name);
            consumedValue(model.consumedValue);
            maxCount(model.maxCount);
            unit(model.unit);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getConsumedValue() {
            return consumedValue;
        }

        @Override
        public final Builder consumedValue(String consumedValue) {
            this.consumedValue = consumedValue;
            return this;
        }

        public final void setConsumedValue(String consumedValue) {
            this.consumedValue = consumedValue;
        }

        public final String getMaxCount() {
            return maxCount;
        }

        @Override
        public final Builder maxCount(String maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final void setMaxCount(String maxCount) {
            this.maxCount = maxCount;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(EntitlementDataUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public EntitlementUsage build() {
            return new EntitlementUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
