/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation;
import software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociationsCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociationsForLicenseConfigurationResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListAssociationsForLicenseConfigurationResponse> {
    private static final SdkField<List<LicenseConfigurationAssociation>> LICENSE_CONFIGURATION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseConfigurationAssociations").getter(ListAssociationsForLicenseConfigurationResponse.getter(ListAssociationsForLicenseConfigurationResponse::licenseConfigurationAssociations)).setter(ListAssociationsForLicenseConfigurationResponse.setter(Builder::licenseConfigurationAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseConfigurationAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssociationsForLicenseConfigurationResponse.getter(ListAssociationsForLicenseConfigurationResponse::nextToken)).setter(ListAssociationsForLicenseConfigurationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATION_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LicenseConfigurationAssociation> licenseConfigurationAssociations;
    private final String nextToken;

    private ListAssociationsForLicenseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationAssociations = builder.licenseConfigurationAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLicenseConfigurationAssociations() {
        return this.licenseConfigurationAssociations != null && !(this.licenseConfigurationAssociations instanceof SdkAutoConstructList);
    }

    public final List<LicenseConfigurationAssociation> licenseConfigurationAssociations() {
        return this.licenseConfigurationAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseConfigurationAssociations() ? this.licenseConfigurationAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsForLicenseConfigurationResponse)) {
            return false;
        }
        ListAssociationsForLicenseConfigurationResponse other = (ListAssociationsForLicenseConfigurationResponse)((Object)obj);
        return this.hasLicenseConfigurationAssociations() == other.hasLicenseConfigurationAssociations() && Objects.equals(this.licenseConfigurationAssociations(), other.licenseConfigurationAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociationsForLicenseConfigurationResponse").add("LicenseConfigurationAssociations", this.hasLicenseConfigurationAssociations() ? this.licenseConfigurationAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConfigurationAssociations": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociationsForLicenseConfigurationResponse, T> g) {
        return obj -> g.apply((ListAssociationsForLicenseConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseConfigurationAssociation> licenseConfigurationAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationsForLicenseConfigurationResponse model) {
            super(model);
            this.licenseConfigurationAssociations(model.licenseConfigurationAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<LicenseConfigurationAssociation.Builder> getLicenseConfigurationAssociations() {
            List<LicenseConfigurationAssociation.Builder> result = LicenseConfigurationAssociationsCopier.copyToBuilder(this.licenseConfigurationAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder licenseConfigurationAssociations(Collection<LicenseConfigurationAssociation> licenseConfigurationAssociations) {
            this.licenseConfigurationAssociations = LicenseConfigurationAssociationsCopier.copy(licenseConfigurationAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationAssociations(LicenseConfigurationAssociation ... licenseConfigurationAssociations) {
            this.licenseConfigurationAssociations(Arrays.asList(licenseConfigurationAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationAssociations(Consumer<LicenseConfigurationAssociation.Builder> ... licenseConfigurationAssociations) {
            this.licenseConfigurationAssociations(Stream.of(licenseConfigurationAssociations).map(c -> (LicenseConfigurationAssociation)((LicenseConfigurationAssociation.Builder)LicenseConfigurationAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseConfigurationAssociations(Collection<LicenseConfigurationAssociation.BuilderImpl> licenseConfigurationAssociations) {
            this.licenseConfigurationAssociations = LicenseConfigurationAssociationsCopier.copyFromBuilder(licenseConfigurationAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociationsForLicenseConfigurationResponse build() {
            return new ListAssociationsForLicenseConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociationsForLicenseConfigurationResponse> {
        public Builder licenseConfigurationAssociations(Collection<LicenseConfigurationAssociation> var1);

        public Builder licenseConfigurationAssociations(LicenseConfigurationAssociation ... var1);

        public Builder licenseConfigurationAssociations(Consumer<LicenseConfigurationAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

