/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLicenseVersionsResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListLicenseVersionsResponse.Builder, ListLicenseVersionsResponse> {
    private static final SdkField<List<License>> LICENSES_FIELD = SdkField
            .<List<License>> builder(MarshallingType.LIST)
            .memberName("Licenses")
            .getter(getter(ListLicenseVersionsResponse::licenses))
            .setter(setter(Builder::licenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Licenses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<License> builder(MarshallingType.SDK_POJO)
                                            .constructor(License::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLicenseVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<License> licenses;

    private final String nextToken;

    private ListLicenseVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.licenses = builder.licenses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Licenses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLicenses() {
        return licenses != null && !(licenses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License details.
     */
    public final List<License> licenses() {
        return licenses;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenses() ? licenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseVersionsResponse)) {
            return false;
        }
        ListLicenseVersionsResponse other = (ListLicenseVersionsResponse) obj;
        return hasLicenses() == other.hasLicenses() && Objects.equals(licenses(), other.licenses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLicenseVersionsResponse").add("Licenses", hasLicenses() ? licenses() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Licenses":
            return Optional.ofNullable(clazz.cast(licenses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseVersionsResponse, T> g) {
        return obj -> g.apply((ListLicenseVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLicenseVersionsResponse> {
        /**
         * <p>
         * License details.
         * </p>
         * 
         * @param licenses
         *        License details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenses(Collection<License> licenses);

        /**
         * <p>
         * License details.
         * </p>
         * 
         * @param licenses
         *        License details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenses(License... licenses);

        /**
         * <p>
         * License details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<License>.Builder} avoiding the need to
         * create one manually via {@link List<License>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<License>.Builder#build()} is called immediately and its
         * result is passed to {@link #licenses(List<License>)}.
         * 
         * @param licenses
         *        a consumer that will call methods on {@link List<License>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenses(List<License>)
         */
        Builder licenses(Consumer<License.Builder>... licenses);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<License> licenses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseVersionsResponse model) {
            super(model);
            licenses(model.licenses);
            nextToken(model.nextToken);
        }

        public final List<License.Builder> getLicenses() {
            List<License.Builder> result = LicenseListCopier.copyToBuilder(this.licenses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder licenses(Collection<License> licenses) {
            this.licenses = LicenseListCopier.copy(licenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(License... licenses) {
            licenses(Arrays.asList(licenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(Consumer<License.Builder>... licenses) {
            licenses(Stream.of(licenses).map(c -> License.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenses(Collection<License.BuilderImpl> licenses) {
            this.licenses = LicenseListCopier.copyFromBuilder(licenses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLicenseVersionsResponse build() {
            return new ListLicenseVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
