/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributedGrantsResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListDistributedGrantsResponse.Builder, ListDistributedGrantsResponse> {
    private static final SdkField<List<Grant>> GRANTS_FIELD = SdkField
            .<List<Grant>> builder(MarshallingType.LIST)
            .memberName("Grants")
            .getter(getter(ListDistributedGrantsResponse::grants))
            .setter(setter(Builder::grants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Grant> builder(MarshallingType.SDK_POJO)
                                            .constructor(Grant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDistributedGrantsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GRANTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Grant> grants;

    private final String nextToken;

    private ListDistributedGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.grants = builder.grants;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Grants property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGrants() {
        return grants != null && !(grants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Distributed grant details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGrants()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Distributed grant details.
     */
    public final List<Grant> grants() {
        return grants;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGrants() ? grants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributedGrantsResponse)) {
            return false;
        }
        ListDistributedGrantsResponse other = (ListDistributedGrantsResponse) obj;
        return hasGrants() == other.hasGrants() && Objects.equals(grants(), other.grants())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributedGrantsResponse").add("Grants", hasGrants() ? grants() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Grants":
            return Optional.ofNullable(clazz.cast(grants()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributedGrantsResponse, T> g) {
        return obj -> g.apply((ListDistributedGrantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributedGrantsResponse> {
        /**
         * <p>
         * Distributed grant details.
         * </p>
         * 
         * @param grants
         *        Distributed grant details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Collection<Grant> grants);

        /**
         * <p>
         * Distributed grant details.
         * </p>
         * 
         * @param grants
         *        Distributed grant details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Grant... grants);

        /**
         * <p>
         * Distributed grant details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Grant>.Builder} avoiding the need to create
         * one manually via {@link List<Grant>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Grant>.Builder#build()} is called immediately and its result
         * is passed to {@link #grants(List<Grant>)}.
         * 
         * @param grants
         *        a consumer that will call methods on {@link List<Grant>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grants(List<Grant>)
         */
        Builder grants(Consumer<Grant.Builder>... grants);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<Grant> grants = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributedGrantsResponse model) {
            super(model);
            grants(model.grants);
            nextToken(model.nextToken);
        }

        public final List<Grant.Builder> getGrants() {
            List<Grant.Builder> result = GrantListCopier.copyToBuilder(this.grants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder grants(Collection<Grant> grants) {
            this.grants = GrantListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Grant... grants) {
            grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<Grant.Builder>... grants) {
            grants(Stream.of(grants).map(c -> Grant.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGrants(Collection<Grant.BuilderImpl> grants) {
            this.grants = GrantListCopier.copyFromBuilder(grants);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDistributedGrantsResponse build() {
            return new ListDistributedGrantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
