/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLicenseConfigurationRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<UpdateLicenseConfigurationRequest.Builder, UpdateLicenseConfigurationRequest> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConfigurationArn").getter(getter(UpdateLicenseConfigurationRequest::licenseConfigurationArn))
            .setter(setter(Builder::licenseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build())
            .build();

    private static final SdkField<String> LICENSE_CONFIGURATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LicenseConfigurationStatus")
            .getter(getter(UpdateLicenseConfigurationRequest::licenseConfigurationStatusAsString))
            .setter(setter(Builder::licenseConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationStatus").build())
            .build();

    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LicenseRules")
            .getter(getter(UpdateLicenseConfigurationRequest::licenseRules))
            .setter(setter(Builder::licenseRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LicenseCount").getter(getter(UpdateLicenseConfigurationRequest::licenseCount))
            .setter(setter(Builder::licenseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()).build();

    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LicenseCountHardLimit").getter(getter(UpdateLicenseConfigurationRequest::licenseCountHardLimit))
            .setter(setter(Builder::licenseCountHardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateLicenseConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateLicenseConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<ProductInformation>> PRODUCT_INFORMATION_LIST_FIELD = SdkField
            .<List<ProductInformation>> builder(MarshallingType.LIST)
            .memberName("ProductInformationList")
            .getter(getter(UpdateLicenseConfigurationRequest::productInformationList))
            .setter(setter(Builder::productInformationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISASSOCIATE_WHEN_NOT_FOUND_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DisassociateWhenNotFound")
            .getter(getter(UpdateLicenseConfigurationRequest::disassociateWhenNotFound))
            .setter(setter(Builder::disassociateWhenNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateWhenNotFound").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_ARN_FIELD, LICENSE_CONFIGURATION_STATUS_FIELD, LICENSE_RULES_FIELD, LICENSE_COUNT_FIELD,
            LICENSE_COUNT_HARD_LIMIT_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PRODUCT_INFORMATION_LIST_FIELD,
            DISASSOCIATE_WHEN_NOT_FOUND_FIELD));

    private final String licenseConfigurationArn;

    private final String licenseConfigurationStatus;

    private final List<String> licenseRules;

    private final Long licenseCount;

    private final Boolean licenseCountHardLimit;

    private final String name;

    private final String description;

    private final List<ProductInformation> productInformationList;

    private final Boolean disassociateWhenNotFound;

    private UpdateLicenseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.licenseConfigurationStatus = builder.licenseConfigurationStatus;
        this.licenseRules = builder.licenseRules;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.name = builder.name;
        this.description = builder.description;
        this.productInformationList = builder.productInformationList;
        this.disassociateWhenNotFound = builder.disassociateWhenNotFound;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license configuration.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license configuration.
     */
    public final String licenseConfigurationArn() {
        return licenseConfigurationArn;
    }

    /**
     * <p>
     * New status of the license configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseConfigurationStatus} will return {@link LicenseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #licenseConfigurationStatusAsString}.
     * </p>
     * 
     * @return New status of the license configuration.
     * @see LicenseConfigurationStatus
     */
    public final LicenseConfigurationStatus licenseConfigurationStatus() {
        return LicenseConfigurationStatus.fromValue(licenseConfigurationStatus);
    }

    /**
     * <p>
     * New status of the license configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseConfigurationStatus} will return {@link LicenseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #licenseConfigurationStatusAsString}.
     * </p>
     * 
     * @return New status of the license configuration.
     * @see LicenseConfigurationStatus
     */
    public final String licenseConfigurationStatusAsString() {
        return licenseConfigurationStatus;
    }

    /**
     * Returns true if the LicenseRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLicenseRules() {
        return licenseRules != null && !(licenseRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * New license rule. The only rule that you can add after you create a license configuration is
     * licenseAffinityToHost.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return New license rule. The only rule that you can add after you create a license configuration is
     *         licenseAffinityToHost.
     */
    public final List<String> licenseRules() {
        return licenseRules;
    }

    /**
     * <p>
     * New number of licenses managed by the license configuration.
     * </p>
     * 
     * @return New number of licenses managed by the license configuration.
     */
    public final Long licenseCount() {
        return licenseCount;
    }

    /**
     * <p>
     * New hard limit of the number of available licenses.
     * </p>
     * 
     * @return New hard limit of the number of available licenses.
     */
    public final Boolean licenseCountHardLimit() {
        return licenseCountHardLimit;
    }

    /**
     * <p>
     * New name of the license configuration.
     * </p>
     * 
     * @return New name of the license configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * New description of the license configuration.
     * </p>
     * 
     * @return New description of the license configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the ProductInformationList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProductInformationList() {
        return productInformationList != null && !(productInformationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * New product information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductInformationList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return New product information.
     */
    public final List<ProductInformation> productInformationList() {
        return productInformationList;
    }

    /**
     * <p>
     * When true, disassociates a resource when software is uninstalled.
     * </p>
     * 
     * @return When true, disassociates a resource when software is uninstalled.
     */
    public final Boolean disassociateWhenNotFound() {
        return disassociateWhenNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseRules() ? licenseRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductInformationList() ? productInformationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disassociateWhenNotFound());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLicenseConfigurationRequest)) {
            return false;
        }
        UpdateLicenseConfigurationRequest other = (UpdateLicenseConfigurationRequest) obj;
        return Objects.equals(licenseConfigurationArn(), other.licenseConfigurationArn())
                && Objects.equals(licenseConfigurationStatusAsString(), other.licenseConfigurationStatusAsString())
                && hasLicenseRules() == other.hasLicenseRules() && Objects.equals(licenseRules(), other.licenseRules())
                && Objects.equals(licenseCount(), other.licenseCount())
                && Objects.equals(licenseCountHardLimit(), other.licenseCountHardLimit()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && hasProductInformationList() == other.hasProductInformationList()
                && Objects.equals(productInformationList(), other.productInformationList())
                && Objects.equals(disassociateWhenNotFound(), other.disassociateWhenNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLicenseConfigurationRequest").add("LicenseConfigurationArn", licenseConfigurationArn())
                .add("LicenseConfigurationStatus", licenseConfigurationStatusAsString())
                .add("LicenseRules", hasLicenseRules() ? licenseRules() : null).add("LicenseCount", licenseCount())
                .add("LicenseCountHardLimit", licenseCountHardLimit()).add("Name", name()).add("Description", description())
                .add("ProductInformationList", hasProductInformationList() ? productInformationList() : null)
                .add("DisassociateWhenNotFound", disassociateWhenNotFound()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationArn":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArn()));
        case "LicenseConfigurationStatus":
            return Optional.ofNullable(clazz.cast(licenseConfigurationStatusAsString()));
        case "LicenseRules":
            return Optional.ofNullable(clazz.cast(licenseRules()));
        case "LicenseCount":
            return Optional.ofNullable(clazz.cast(licenseCount()));
        case "LicenseCountHardLimit":
            return Optional.ofNullable(clazz.cast(licenseCountHardLimit()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ProductInformationList":
            return Optional.ofNullable(clazz.cast(productInformationList()));
        case "DisassociateWhenNotFound":
            return Optional.ofNullable(clazz.cast(disassociateWhenNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLicenseConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLicenseConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLicenseConfigurationRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license configuration.
         * </p>
         * 
         * @param licenseConfigurationArn
         *        Amazon Resource Name (ARN) of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArn(String licenseConfigurationArn);

        /**
         * <p>
         * New status of the license configuration.
         * </p>
         * 
         * @param licenseConfigurationStatus
         *        New status of the license configuration.
         * @see LicenseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseConfigurationStatus
         */
        Builder licenseConfigurationStatus(String licenseConfigurationStatus);

        /**
         * <p>
         * New status of the license configuration.
         * </p>
         * 
         * @param licenseConfigurationStatus
         *        New status of the license configuration.
         * @see LicenseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseConfigurationStatus
         */
        Builder licenseConfigurationStatus(LicenseConfigurationStatus licenseConfigurationStatus);

        /**
         * <p>
         * New license rule. The only rule that you can add after you create a license configuration is
         * licenseAffinityToHost.
         * </p>
         * 
         * @param licenseRules
         *        New license rule. The only rule that you can add after you create a license configuration is
         *        licenseAffinityToHost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(Collection<String> licenseRules);

        /**
         * <p>
         * New license rule. The only rule that you can add after you create a license configuration is
         * licenseAffinityToHost.
         * </p>
         * 
         * @param licenseRules
         *        New license rule. The only rule that you can add after you create a license configuration is
         *        licenseAffinityToHost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(String... licenseRules);

        /**
         * <p>
         * New number of licenses managed by the license configuration.
         * </p>
         * 
         * @param licenseCount
         *        New number of licenses managed by the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCount(Long licenseCount);

        /**
         * <p>
         * New hard limit of the number of available licenses.
         * </p>
         * 
         * @param licenseCountHardLimit
         *        New hard limit of the number of available licenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCountHardLimit(Boolean licenseCountHardLimit);

        /**
         * <p>
         * New name of the license configuration.
         * </p>
         * 
         * @param name
         *        New name of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * New description of the license configuration.
         * </p>
         * 
         * @param description
         *        New description of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * New product information.
         * </p>
         * 
         * @param productInformationList
         *        New product information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationList(Collection<ProductInformation> productInformationList);

        /**
         * <p>
         * New product information.
         * </p>
         * 
         * @param productInformationList
         *        New product information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationList(ProductInformation... productInformationList);

        /**
         * <p>
         * New product information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductInformation>.Builder} avoiding the
         * need to create one manually via {@link List<ProductInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductInformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #productInformationList(List<ProductInformation>)}.
         * 
         * @param productInformationList
         *        a consumer that will call methods on {@link List<ProductInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productInformationList(List<ProductInformation>)
         */
        Builder productInformationList(Consumer<ProductInformation.Builder>... productInformationList);

        /**
         * <p>
         * When true, disassociates a resource when software is uninstalled.
         * </p>
         * 
         * @param disassociateWhenNotFound
         *        When true, disassociates a resource when software is uninstalled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateWhenNotFound(Boolean disassociateWhenNotFound);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseConfigurationArn;

        private String licenseConfigurationStatus;

        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();

        private Long licenseCount;

        private Boolean licenseCountHardLimit;

        private String name;

        private String description;

        private List<ProductInformation> productInformationList = DefaultSdkAutoConstructList.getInstance();

        private Boolean disassociateWhenNotFound;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLicenseConfigurationRequest model) {
            super(model);
            licenseConfigurationArn(model.licenseConfigurationArn);
            licenseConfigurationStatus(model.licenseConfigurationStatus);
            licenseRules(model.licenseRules);
            licenseCount(model.licenseCount);
            licenseCountHardLimit(model.licenseCountHardLimit);
            name(model.name);
            description(model.description);
            productInformationList(model.productInformationList);
            disassociateWhenNotFound(model.disassociateWhenNotFound);
        }

        public final String getLicenseConfigurationArn() {
            return licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        public final String getLicenseConfigurationStatus() {
            return licenseConfigurationStatus;
        }

        @Override
        public final Builder licenseConfigurationStatus(String licenseConfigurationStatus) {
            this.licenseConfigurationStatus = licenseConfigurationStatus;
            return this;
        }

        @Override
        public final Builder licenseConfigurationStatus(LicenseConfigurationStatus licenseConfigurationStatus) {
            this.licenseConfigurationStatus(licenseConfigurationStatus == null ? null : licenseConfigurationStatus.toString());
            return this;
        }

        public final void setLicenseConfigurationStatus(String licenseConfigurationStatus) {
            this.licenseConfigurationStatus = licenseConfigurationStatus;
        }

        public final Collection<String> getLicenseRules() {
            if (licenseRules instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseRules;
        }

        @Override
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRules(String... licenseRules) {
            licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        public final Long getLicenseCount() {
            return licenseCount;
        }

        @Override
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        public final Boolean getLicenseCountHardLimit() {
            return licenseCountHardLimit;
        }

        @Override
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<ProductInformation.Builder> getProductInformationList() {
            List<ProductInformation.Builder> result = ProductInformationListCopier.copyToBuilder(this.productInformationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder productInformationList(Collection<ProductInformation> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copy(productInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(ProductInformation... productInformationList) {
            productInformationList(Arrays.asList(productInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(Consumer<ProductInformation.Builder>... productInformationList) {
            productInformationList(Stream.of(productInformationList)
                    .map(c -> ProductInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductInformationList(Collection<ProductInformation.BuilderImpl> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copyFromBuilder(productInformationList);
        }

        public final Boolean getDisassociateWhenNotFound() {
            return disassociateWhenNotFound;
        }

        @Override
        public final Builder disassociateWhenNotFound(Boolean disassociateWhenNotFound) {
            this.disassociateWhenNotFound = disassociateWhenNotFound;
            return this;
        }

        public final void setDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
            this.disassociateWhenNotFound = disassociateWhenNotFound;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLicenseConfigurationRequest build() {
            return new UpdateLicenseConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
