/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a license type conversion task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseConversionTask implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseConversionTask.Builder, LicenseConversionTask> {
    private static final SdkField<String> LICENSE_CONVERSION_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConversionTaskId").getter(getter(LicenseConversionTask::licenseConversionTaskId))
            .setter(setter(Builder::licenseConversionTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConversionTaskId").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(LicenseConversionTask::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<LicenseConversionContext> SOURCE_LICENSE_CONTEXT_FIELD = SdkField
            .<LicenseConversionContext> builder(MarshallingType.SDK_POJO).memberName("SourceLicenseContext")
            .getter(getter(LicenseConversionTask::sourceLicenseContext)).setter(setter(Builder::sourceLicenseContext))
            .constructor(LicenseConversionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLicenseContext").build())
            .build();

    private static final SdkField<LicenseConversionContext> DESTINATION_LICENSE_CONTEXT_FIELD = SdkField
            .<LicenseConversionContext> builder(MarshallingType.SDK_POJO).memberName("DestinationLicenseContext")
            .getter(getter(LicenseConversionTask::destinationLicenseContext)).setter(setter(Builder::destinationLicenseContext))
            .constructor(LicenseConversionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLicenseContext").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LicenseConversionTask::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(LicenseConversionTask::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(LicenseConversionTask::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> LICENSE_CONVERSION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LicenseConversionTime").getter(getter(LicenseConversionTask::licenseConversionTime))
            .setter(setter(Builder::licenseConversionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConversionTime").build())
            .build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(LicenseConversionTask::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONVERSION_TASK_ID_FIELD, RESOURCE_ARN_FIELD, SOURCE_LICENSE_CONTEXT_FIELD,
            DESTINATION_LICENSE_CONTEXT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, START_TIME_FIELD,
            LICENSE_CONVERSION_TIME_FIELD, END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String licenseConversionTaskId;

    private final String resourceArn;

    private final LicenseConversionContext sourceLicenseContext;

    private final LicenseConversionContext destinationLicenseContext;

    private final String status;

    private final String statusMessage;

    private final Instant startTime;

    private final Instant licenseConversionTime;

    private final Instant endTime;

    private LicenseConversionTask(BuilderImpl builder) {
        this.licenseConversionTaskId = builder.licenseConversionTaskId;
        this.resourceArn = builder.resourceArn;
        this.sourceLicenseContext = builder.sourceLicenseContext;
        this.destinationLicenseContext = builder.destinationLicenseContext;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.startTime = builder.startTime;
        this.licenseConversionTime = builder.licenseConversionTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ID of the license type conversion task.
     * </p>
     * 
     * @return The ID of the license type conversion task.
     */
    public final String licenseConversionTaskId() {
        return licenseConversionTaskId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource associated with the license type conversion task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource associated with the license type conversion task.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Information about the license type this conversion task converted from.
     * </p>
     * 
     * @return Information about the license type this conversion task converted from.
     */
    public final LicenseConversionContext sourceLicenseContext() {
        return sourceLicenseContext;
    }

    /**
     * <p>
     * Information about the license type this conversion task converted to.
     * </p>
     * 
     * @return Information about the license type this conversion task converted to.
     */
    public final LicenseConversionContext destinationLicenseContext() {
        return destinationLicenseContext;
    }

    /**
     * <p>
     * The status of the conversion task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseConversionTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the conversion task.
     * @see LicenseConversionTaskStatus
     */
    public final LicenseConversionTaskStatus status() {
        return LicenseConversionTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the conversion task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseConversionTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the conversion task.
     * @see LicenseConversionTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message for the conversion task.
     * </p>
     * 
     * @return The status message for the conversion task.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time the conversion task was started at.
     * </p>
     * 
     * @return The time the conversion task was started at.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the usage operation value of the resource was changed.
     * </p>
     * 
     * @return The time the usage operation value of the resource was changed.
     */
    public final Instant licenseConversionTime() {
        return licenseConversionTime;
    }

    /**
     * <p>
     * The time the conversion task was completed.
     * </p>
     * 
     * @return The time the conversion task was completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseConversionTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLicenseContext());
        hashCode = 31 * hashCode + Objects.hashCode(destinationLicenseContext());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(licenseConversionTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConversionTask)) {
            return false;
        }
        LicenseConversionTask other = (LicenseConversionTask) obj;
        return Objects.equals(licenseConversionTaskId(), other.licenseConversionTaskId())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(sourceLicenseContext(), other.sourceLicenseContext())
                && Objects.equals(destinationLicenseContext(), other.destinationLicenseContext())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(licenseConversionTime(), other.licenseConversionTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseConversionTask").add("LicenseConversionTaskId", licenseConversionTaskId())
                .add("ResourceArn", resourceArn()).add("SourceLicenseContext", sourceLicenseContext())
                .add("DestinationLicenseContext", destinationLicenseContext()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("StartTime", startTime())
                .add("LicenseConversionTime", licenseConversionTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConversionTaskId":
            return Optional.ofNullable(clazz.cast(licenseConversionTaskId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "SourceLicenseContext":
            return Optional.ofNullable(clazz.cast(sourceLicenseContext()));
        case "DestinationLicenseContext":
            return Optional.ofNullable(clazz.cast(destinationLicenseContext()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "LicenseConversionTime":
            return Optional.ofNullable(clazz.cast(licenseConversionTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseConversionTask, T> g) {
        return obj -> g.apply((LicenseConversionTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseConversionTask> {
        /**
         * <p>
         * The ID of the license type conversion task.
         * </p>
         * 
         * @param licenseConversionTaskId
         *        The ID of the license type conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConversionTaskId(String licenseConversionTaskId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource associated with the license type conversion task.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource associated with the license type conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Information about the license type this conversion task converted from.
         * </p>
         * 
         * @param sourceLicenseContext
         *        Information about the license type this conversion task converted from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLicenseContext(LicenseConversionContext sourceLicenseContext);

        /**
         * <p>
         * Information about the license type this conversion task converted from.
         * </p>
         * This is a convenience that creates an instance of the {@link LicenseConversionContext.Builder} avoiding the
         * need to create one manually via {@link LicenseConversionContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link LicenseConversionContext.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceLicenseContext(LicenseConversionContext)}.
         * 
         * @param sourceLicenseContext
         *        a consumer that will call methods on {@link LicenseConversionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceLicenseContext(LicenseConversionContext)
         */
        default Builder sourceLicenseContext(Consumer<LicenseConversionContext.Builder> sourceLicenseContext) {
            return sourceLicenseContext(LicenseConversionContext.builder().applyMutation(sourceLicenseContext).build());
        }

        /**
         * <p>
         * Information about the license type this conversion task converted to.
         * </p>
         * 
         * @param destinationLicenseContext
         *        Information about the license type this conversion task converted to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationLicenseContext(LicenseConversionContext destinationLicenseContext);

        /**
         * <p>
         * Information about the license type this conversion task converted to.
         * </p>
         * This is a convenience that creates an instance of the {@link LicenseConversionContext.Builder} avoiding the
         * need to create one manually via {@link LicenseConversionContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link LicenseConversionContext.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationLicenseContext(LicenseConversionContext)}.
         * 
         * @param destinationLicenseContext
         *        a consumer that will call methods on {@link LicenseConversionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationLicenseContext(LicenseConversionContext)
         */
        default Builder destinationLicenseContext(Consumer<LicenseConversionContext.Builder> destinationLicenseContext) {
            return destinationLicenseContext(LicenseConversionContext.builder().applyMutation(destinationLicenseContext).build());
        }

        /**
         * <p>
         * The status of the conversion task.
         * </p>
         * 
         * @param status
         *        The status of the conversion task.
         * @see LicenseConversionTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseConversionTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the conversion task.
         * </p>
         * 
         * @param status
         *        The status of the conversion task.
         * @see LicenseConversionTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseConversionTaskStatus
         */
        Builder status(LicenseConversionTaskStatus status);

        /**
         * <p>
         * The status message for the conversion task.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time the conversion task was started at.
         * </p>
         * 
         * @param startTime
         *        The time the conversion task was started at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the usage operation value of the resource was changed.
         * </p>
         * 
         * @param licenseConversionTime
         *        The time the usage operation value of the resource was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConversionTime(Instant licenseConversionTime);

        /**
         * <p>
         * The time the conversion task was completed.
         * </p>
         * 
         * @param endTime
         *        The time the conversion task was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String licenseConversionTaskId;

        private String resourceArn;

        private LicenseConversionContext sourceLicenseContext;

        private LicenseConversionContext destinationLicenseContext;

        private String status;

        private String statusMessage;

        private Instant startTime;

        private Instant licenseConversionTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConversionTask model) {
            licenseConversionTaskId(model.licenseConversionTaskId);
            resourceArn(model.resourceArn);
            sourceLicenseContext(model.sourceLicenseContext);
            destinationLicenseContext(model.destinationLicenseContext);
            status(model.status);
            statusMessage(model.statusMessage);
            startTime(model.startTime);
            licenseConversionTime(model.licenseConversionTime);
            endTime(model.endTime);
        }

        public final String getLicenseConversionTaskId() {
            return licenseConversionTaskId;
        }

        public final void setLicenseConversionTaskId(String licenseConversionTaskId) {
            this.licenseConversionTaskId = licenseConversionTaskId;
        }

        @Override
        @Transient
        public final Builder licenseConversionTaskId(String licenseConversionTaskId) {
            this.licenseConversionTaskId = licenseConversionTaskId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final LicenseConversionContext.Builder getSourceLicenseContext() {
            return sourceLicenseContext != null ? sourceLicenseContext.toBuilder() : null;
        }

        public final void setSourceLicenseContext(LicenseConversionContext.BuilderImpl sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext != null ? sourceLicenseContext.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceLicenseContext(LicenseConversionContext sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext;
            return this;
        }

        public final LicenseConversionContext.Builder getDestinationLicenseContext() {
            return destinationLicenseContext != null ? destinationLicenseContext.toBuilder() : null;
        }

        public final void setDestinationLicenseContext(LicenseConversionContext.BuilderImpl destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext != null ? destinationLicenseContext.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationLicenseContext(LicenseConversionContext destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(LicenseConversionTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLicenseConversionTime() {
            return licenseConversionTime;
        }

        public final void setLicenseConversionTime(Instant licenseConversionTime) {
            this.licenseConversionTime = licenseConversionTime;
        }

        @Override
        @Transient
        public final Builder licenseConversionTime(Instant licenseConversionTime) {
            this.licenseConversionTime = licenseConversionTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public LicenseConversionTask build() {
            return new LicenseConversionTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
