/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGrantRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateGrantRequest.Builder, CreateGrantRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateGrantRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> GRANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantName").getter(getter(CreateGrantRequest::grantName)).setter(setter(Builder::grantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantName").build()).build();

    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(CreateGrantRequest::licenseArn)).setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Principals")
            .getter(getter(CreateGrantRequest::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(CreateGrantRequest::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<List<String>> ALLOWED_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOperations")
            .getter(getter(CreateGrantRequest::allowedOperationsAsStrings))
            .setter(setter(Builder::allowedOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GRANT_NAME_FIELD, LICENSE_ARN_FIELD, PRINCIPALS_FIELD, HOME_REGION_FIELD, ALLOWED_OPERATIONS_FIELD));

    private final String clientToken;

    private final String grantName;

    private final String licenseArn;

    private final List<String> principals;

    private final String homeRegion;

    private final List<String> allowedOperations;

    private CreateGrantRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.grantName = builder.grantName;
        this.licenseArn = builder.licenseArn;
        this.principals = builder.principals;
        this.homeRegion = builder.homeRegion;
        this.allowedOperations = builder.allowedOperations;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Grant name.
     * </p>
     * 
     * @return Grant name.
     */
    public final String grantName() {
        return grantName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license.
     */
    public final String licenseArn() {
        return licenseArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The grant principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipals} method.
     * </p>
     * 
     * @return The grant principals.
     */
    public final List<String> principals() {
        return principals;
    }

    /**
     * <p>
     * Home Region of the grant.
     * </p>
     * 
     * @return Home Region of the grant.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * Allowed operations for the grant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOperations} method.
     * </p>
     * 
     * @return Allowed operations for the grant.
     */
    public final List<AllowedOperation> allowedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(allowedOperations);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedOperations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedOperations() {
        return allowedOperations != null && !(allowedOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allowed operations for the grant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOperations} method.
     * </p>
     * 
     * @return Allowed operations for the grant.
     */
    public final List<String> allowedOperationsAsStrings() {
        return allowedOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(grantName());
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipals() ? principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOperations() ? allowedOperationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest other = (CreateGrantRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(grantName(), other.grantName())
                && Objects.equals(licenseArn(), other.licenseArn()) && hasPrincipals() == other.hasPrincipals()
                && Objects.equals(principals(), other.principals()) && Objects.equals(homeRegion(), other.homeRegion())
                && hasAllowedOperations() == other.hasAllowedOperations()
                && Objects.equals(allowedOperationsAsStrings(), other.allowedOperationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGrantRequest").add("ClientToken", clientToken()).add("GrantName", grantName())
                .add("LicenseArn", licenseArn()).add("Principals", hasPrincipals() ? principals() : null)
                .add("HomeRegion", homeRegion())
                .add("AllowedOperations", hasAllowedOperations() ? allowedOperationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "GrantName":
            return Optional.ofNullable(clazz.cast(grantName()));
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "Principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "AllowedOperations":
            return Optional.ofNullable(clazz.cast(allowedOperationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantRequest, T> g) {
        return obj -> g.apply((CreateGrantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGrantRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Grant name.
         * </p>
         * 
         * @param grantName
         *        Grant name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantName(String grantName);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the license.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * The grant principals.
         * </p>
         * 
         * @param principals
         *        The grant principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * The grant principals.
         * </p>
         * 
         * @param principals
         *        The grant principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);

        /**
         * <p>
         * Home Region of the grant.
         * </p>
         * 
         * @param homeRegion
         *        Home Region of the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperationsWithStrings(Collection<String> allowedOperations);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperationsWithStrings(String... allowedOperations);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperations(Collection<AllowedOperation> allowedOperations);

        /**
         * <p>
         * Allowed operations for the grant.
         * </p>
         * 
         * @param allowedOperations
         *        Allowed operations for the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOperations(AllowedOperation... allowedOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String grantName;

        private String licenseArn;

        private List<String> principals = DefaultSdkAutoConstructList.getInstance();

        private String homeRegion;

        private List<String> allowedOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantRequest model) {
            super(model);
            clientToken(model.clientToken);
            grantName(model.grantName);
            licenseArn(model.licenseArn);
            principals(model.principals);
            homeRegion(model.homeRegion);
            allowedOperationsWithStrings(model.allowedOperations);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGrantName() {
            return grantName;
        }

        public final void setGrantName(String grantName) {
            this.grantName = grantName;
        }

        @Override
        @Transient
        public final Builder grantName(String grantName) {
            this.grantName = grantName;
            return this;
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        @Transient
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final Collection<String> getPrincipals() {
            if (principals instanceof SdkAutoConstructList) {
                return null;
            }
            return principals;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalArnListCopier.copy(principals);
        }

        @Override
        @Transient
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalArnListCopier.copy(principals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        @Transient
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final Collection<String> getAllowedOperations() {
            if (allowedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOperations;
        }

        public final void setAllowedOperations(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
        }

        @Override
        @Transient
        public final Builder allowedOperationsWithStrings(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedOperationsWithStrings(String... allowedOperations) {
            allowedOperationsWithStrings(Arrays.asList(allowedOperations));
            return this;
        }

        @Override
        @Transient
        public final Builder allowedOperations(Collection<AllowedOperation> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copyEnumToString(allowedOperations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedOperations(AllowedOperation... allowedOperations) {
            allowedOperations(Arrays.asList(allowedOperations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGrantRequest build() {
            return new CreateGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
