/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtendLicenseConsumptionResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ExtendLicenseConsumptionResponse.Builder, ExtendLicenseConsumptionResponse> {
    private static final SdkField<String> LICENSE_CONSUMPTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConsumptionToken").getter(getter(ExtendLicenseConsumptionResponse::licenseConsumptionToken))
            .setter(setter(Builder::licenseConsumptionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConsumptionToken").build())
            .build();

    private static final SdkField<String> EXPIRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expiration").getter(getter(ExtendLicenseConsumptionResponse::expiration))
            .setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONSUMPTION_TOKEN_FIELD, EXPIRATION_FIELD));

    private final String licenseConsumptionToken;

    private final String expiration;

    private ExtendLicenseConsumptionResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConsumptionToken = builder.licenseConsumptionToken;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * License consumption token.
     * </p>
     * 
     * @return License consumption token.
     */
    public final String licenseConsumptionToken() {
        return licenseConsumptionToken;
    }

    /**
     * <p>
     * Date and time at which the license consumption expires.
     * </p>
     * 
     * @return Date and time at which the license consumption expires.
     */
    public final String expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseConsumptionToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendLicenseConsumptionResponse)) {
            return false;
        }
        ExtendLicenseConsumptionResponse other = (ExtendLicenseConsumptionResponse) obj;
        return Objects.equals(licenseConsumptionToken(), other.licenseConsumptionToken())
                && Objects.equals(expiration(), other.expiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtendLicenseConsumptionResponse").add("LicenseConsumptionToken", licenseConsumptionToken())
                .add("Expiration", expiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConsumptionToken":
            return Optional.ofNullable(clazz.cast(licenseConsumptionToken()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtendLicenseConsumptionResponse, T> g) {
        return obj -> g.apply((ExtendLicenseConsumptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExtendLicenseConsumptionResponse> {
        /**
         * <p>
         * License consumption token.
         * </p>
         * 
         * @param licenseConsumptionToken
         *        License consumption token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConsumptionToken(String licenseConsumptionToken);

        /**
         * <p>
         * Date and time at which the license consumption expires.
         * </p>
         * 
         * @param expiration
         *        Date and time at which the license consumption expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(String expiration);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String licenseConsumptionToken;

        private String expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendLicenseConsumptionResponse model) {
            super(model);
            licenseConsumptionToken(model.licenseConsumptionToken);
            expiration(model.expiration);
        }

        public final String getLicenseConsumptionToken() {
            return licenseConsumptionToken;
        }

        public final void setLicenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
        }

        @Override
        @Transient
        public final Builder licenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
            return this;
        }

        public final String getExpiration() {
            return expiration;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        @Transient
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public ExtendLicenseConsumptionResponse build() {
            return new ExtendLicenseConsumptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
