/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLicenseResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<GetLicenseResponse.Builder, GetLicenseResponse> {
    private static final SdkField<License> LICENSE_FIELD = SdkField.<License> builder(MarshallingType.SDK_POJO)
            .memberName("License").getter(getter(GetLicenseResponse::license)).setter(setter(Builder::license))
            .constructor(License::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("License").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_FIELD));

    private final License license;

    private GetLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.license = builder.license;
    }

    /**
     * <p>
     * License details.
     * </p>
     * 
     * @return License details.
     */
    public final License license() {
        return license;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(license());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseResponse)) {
            return false;
        }
        GetLicenseResponse other = (GetLicenseResponse) obj;
        return Objects.equals(license(), other.license());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLicenseResponse").add("License", license()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "License":
            return Optional.ofNullable(clazz.cast(license()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseResponse, T> g) {
        return obj -> g.apply((GetLicenseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLicenseResponse> {
        /**
         * <p>
         * License details.
         * </p>
         * 
         * @param license
         *        License details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder license(License license);

        /**
         * <p>
         * License details.
         * </p>
         * This is a convenience that creates an instance of the {@link License.Builder} avoiding the need to create one
         * manually via {@link License#builder()}.
         *
         * When the {@link Consumer} completes, {@link License.Builder#build()} is called immediately and its result is
         * passed to {@link #license(License)}.
         * 
         * @param license
         *        a consumer that will call methods on {@link License.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #license(License)
         */
        default Builder license(Consumer<License.Builder> license) {
            return license(License.builder().applyMutation(license).build());
        }
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private License license;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseResponse model) {
            super(model);
            license(model.license);
        }

        public final License.Builder getLicense() {
            return license != null ? license.toBuilder() : null;
        }

        public final void setLicense(License.BuilderImpl license) {
            this.license = license != null ? license.build() : null;
        }

        @Override
        @Transient
        public final Builder license(License license) {
            this.license = license;
            return this;
        }

        @Override
        public GetLicenseResponse build() {
            return new GetLicenseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
