/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckoutBorrowLicenseResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<CheckoutBorrowLicenseResponse.Builder, CheckoutBorrowLicenseResponse> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(CheckoutBorrowLicenseResponse::licenseArn))
            .setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<String> LICENSE_CONSUMPTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConsumptionToken").getter(getter(CheckoutBorrowLicenseResponse::licenseConsumptionToken))
            .setter(setter(Builder::licenseConsumptionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConsumptionToken").build())
            .build();

    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_ALLOWED_FIELD = SdkField
            .<List<EntitlementData>> builder(MarshallingType.LIST)
            .memberName("EntitlementsAllowed")
            .getter(getter(CheckoutBorrowLicenseResponse::entitlementsAllowed))
            .setter(setter(Builder::entitlementsAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementsAllowed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitlementData> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitlementData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(CheckoutBorrowLicenseResponse::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> SIGNED_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignedToken").getter(getter(CheckoutBorrowLicenseResponse::signedToken))
            .setter(setter(Builder::signedToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedToken").build()).build();

    private static final SdkField<String> ISSUED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IssuedAt").getter(getter(CheckoutBorrowLicenseResponse::issuedAt)).setter(setter(Builder::issuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()).build();

    private static final SdkField<String> EXPIRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expiration").getter(getter(CheckoutBorrowLicenseResponse::expiration))
            .setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final SdkField<List<Metadata>> CHECKOUT_METADATA_FIELD = SdkField
            .<List<Metadata>> builder(MarshallingType.LIST)
            .memberName("CheckoutMetadata")
            .getter(getter(CheckoutBorrowLicenseResponse::checkoutMetadata))
            .setter(setter(Builder::checkoutMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD,
            LICENSE_CONSUMPTION_TOKEN_FIELD, ENTITLEMENTS_ALLOWED_FIELD, NODE_ID_FIELD, SIGNED_TOKEN_FIELD, ISSUED_AT_FIELD,
            EXPIRATION_FIELD, CHECKOUT_METADATA_FIELD));

    private final String licenseArn;

    private final String licenseConsumptionToken;

    private final List<EntitlementData> entitlementsAllowed;

    private final String nodeId;

    private final String signedToken;

    private final String issuedAt;

    private final String expiration;

    private final List<Metadata> checkoutMetadata;

    private CheckoutBorrowLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.licenseConsumptionToken = builder.licenseConsumptionToken;
        this.entitlementsAllowed = builder.entitlementsAllowed;
        this.nodeId = builder.nodeId;
        this.signedToken = builder.signedToken;
        this.issuedAt = builder.issuedAt;
        this.expiration = builder.expiration;
        this.checkoutMetadata = builder.checkoutMetadata;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license.
     */
    public final String licenseArn() {
        return licenseArn;
    }

    /**
     * <p>
     * License consumption token.
     * </p>
     * 
     * @return License consumption token.
     */
    public final String licenseConsumptionToken() {
        return licenseConsumptionToken;
    }

    /**
     * Returns true if the EntitlementsAllowed property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEntitlementsAllowed() {
        return entitlementsAllowed != null && !(entitlementsAllowed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allowed license entitlements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntitlementsAllowed()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Allowed license entitlements.
     */
    public final List<EntitlementData> entitlementsAllowed() {
        return entitlementsAllowed;
    }

    /**
     * <p>
     * Node ID.
     * </p>
     * 
     * @return Node ID.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * Signed token.
     * </p>
     * 
     * @return Signed token.
     */
    public final String signedToken() {
        return signedToken;
    }

    /**
     * <p>
     * Date and time at which the license checkout is issued.
     * </p>
     * 
     * @return Date and time at which the license checkout is issued.
     */
    public final String issuedAt() {
        return issuedAt;
    }

    /**
     * <p>
     * Date and time at which the license checkout expires.
     * </p>
     * 
     * @return Date and time at which the license checkout expires.
     */
    public final String expiration() {
        return expiration;
    }

    /**
     * Returns true if the CheckoutMetadata property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCheckoutMetadata() {
        return checkoutMetadata != null && !(checkoutMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about constraints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCheckoutMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about constraints.
     */
    public final List<Metadata> checkoutMetadata() {
        return checkoutMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseConsumptionToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlementsAllowed() ? entitlementsAllowed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(signedToken());
        hashCode = 31 * hashCode + Objects.hashCode(issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCheckoutMetadata() ? checkoutMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutBorrowLicenseResponse)) {
            return false;
        }
        CheckoutBorrowLicenseResponse other = (CheckoutBorrowLicenseResponse) obj;
        return Objects.equals(licenseArn(), other.licenseArn())
                && Objects.equals(licenseConsumptionToken(), other.licenseConsumptionToken())
                && hasEntitlementsAllowed() == other.hasEntitlementsAllowed()
                && Objects.equals(entitlementsAllowed(), other.entitlementsAllowed()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(signedToken(), other.signedToken()) && Objects.equals(issuedAt(), other.issuedAt())
                && Objects.equals(expiration(), other.expiration()) && hasCheckoutMetadata() == other.hasCheckoutMetadata()
                && Objects.equals(checkoutMetadata(), other.checkoutMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckoutBorrowLicenseResponse").add("LicenseArn", licenseArn())
                .add("LicenseConsumptionToken", licenseConsumptionToken())
                .add("EntitlementsAllowed", hasEntitlementsAllowed() ? entitlementsAllowed() : null).add("NodeId", nodeId())
                .add("SignedToken", signedToken()).add("IssuedAt", issuedAt()).add("Expiration", expiration())
                .add("CheckoutMetadata", hasCheckoutMetadata() ? checkoutMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "LicenseConsumptionToken":
            return Optional.ofNullable(clazz.cast(licenseConsumptionToken()));
        case "EntitlementsAllowed":
            return Optional.ofNullable(clazz.cast(entitlementsAllowed()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "SignedToken":
            return Optional.ofNullable(clazz.cast(signedToken()));
        case "IssuedAt":
            return Optional.ofNullable(clazz.cast(issuedAt()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "CheckoutMetadata":
            return Optional.ofNullable(clazz.cast(checkoutMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckoutBorrowLicenseResponse, T> g) {
        return obj -> g.apply((CheckoutBorrowLicenseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckoutBorrowLicenseResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * License consumption token.
         * </p>
         * 
         * @param licenseConsumptionToken
         *        License consumption token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConsumptionToken(String licenseConsumptionToken);

        /**
         * <p>
         * Allowed license entitlements.
         * </p>
         * 
         * @param entitlementsAllowed
         *        Allowed license entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementsAllowed(Collection<EntitlementData> entitlementsAllowed);

        /**
         * <p>
         * Allowed license entitlements.
         * </p>
         * 
         * @param entitlementsAllowed
         *        Allowed license entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementsAllowed(EntitlementData... entitlementsAllowed);

        /**
         * <p>
         * Allowed license entitlements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntitlementData>.Builder} avoiding the need
         * to create one manually via {@link List<EntitlementData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntitlementData>.Builder#build()} is called immediately and
         * its result is passed to {@link #entitlementsAllowed(List<EntitlementData>)}.
         * 
         * @param entitlementsAllowed
         *        a consumer that will call methods on {@link List<EntitlementData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlementsAllowed(List<EntitlementData>)
         */
        Builder entitlementsAllowed(Consumer<EntitlementData.Builder>... entitlementsAllowed);

        /**
         * <p>
         * Node ID.
         * </p>
         * 
         * @param nodeId
         *        Node ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * Signed token.
         * </p>
         * 
         * @param signedToken
         *        Signed token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedToken(String signedToken);

        /**
         * <p>
         * Date and time at which the license checkout is issued.
         * </p>
         * 
         * @param issuedAt
         *        Date and time at which the license checkout is issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedAt(String issuedAt);

        /**
         * <p>
         * Date and time at which the license checkout expires.
         * </p>
         * 
         * @param expiration
         *        Date and time at which the license checkout expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(String expiration);

        /**
         * <p>
         * Information about constraints.
         * </p>
         * 
         * @param checkoutMetadata
         *        Information about constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkoutMetadata(Collection<Metadata> checkoutMetadata);

        /**
         * <p>
         * Information about constraints.
         * </p>
         * 
         * @param checkoutMetadata
         *        Information about constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkoutMetadata(Metadata... checkoutMetadata);

        /**
         * <p>
         * Information about constraints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Metadata>.Builder} avoiding the need to
         * create one manually via {@link List<Metadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #checkoutMetadata(List<Metadata>)}.
         * 
         * @param checkoutMetadata
         *        a consumer that will call methods on {@link List<Metadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkoutMetadata(List<Metadata>)
         */
        Builder checkoutMetadata(Consumer<Metadata.Builder>... checkoutMetadata);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String licenseArn;

        private String licenseConsumptionToken;

        private List<EntitlementData> entitlementsAllowed = DefaultSdkAutoConstructList.getInstance();

        private String nodeId;

        private String signedToken;

        private String issuedAt;

        private String expiration;

        private List<Metadata> checkoutMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutBorrowLicenseResponse model) {
            super(model);
            licenseArn(model.licenseArn);
            licenseConsumptionToken(model.licenseConsumptionToken);
            entitlementsAllowed(model.entitlementsAllowed);
            nodeId(model.nodeId);
            signedToken(model.signedToken);
            issuedAt(model.issuedAt);
            expiration(model.expiration);
            checkoutMetadata(model.checkoutMetadata);
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        @Transient
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getLicenseConsumptionToken() {
            return licenseConsumptionToken;
        }

        public final void setLicenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
        }

        @Override
        @Transient
        public final Builder licenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
            return this;
        }

        public final List<EntitlementData.Builder> getEntitlementsAllowed() {
            List<EntitlementData.Builder> result = EntitlementDataListCopier.copyToBuilder(this.entitlementsAllowed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlementsAllowed(Collection<EntitlementData.BuilderImpl> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copyFromBuilder(entitlementsAllowed);
        }

        @Override
        @Transient
        public final Builder entitlementsAllowed(Collection<EntitlementData> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copy(entitlementsAllowed);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlementsAllowed(EntitlementData... entitlementsAllowed) {
            entitlementsAllowed(Arrays.asList(entitlementsAllowed));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlementsAllowed(Consumer<EntitlementData.Builder>... entitlementsAllowed) {
            entitlementsAllowed(Stream.of(entitlementsAllowed).map(c -> EntitlementData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        @Transient
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getSignedToken() {
            return signedToken;
        }

        public final void setSignedToken(String signedToken) {
            this.signedToken = signedToken;
        }

        @Override
        @Transient
        public final Builder signedToken(String signedToken) {
            this.signedToken = signedToken;
            return this;
        }

        public final String getIssuedAt() {
            return issuedAt;
        }

        public final void setIssuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        @Transient
        public final Builder issuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final String getExpiration() {
            return expiration;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        @Transient
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final List<Metadata.Builder> getCheckoutMetadata() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.checkoutMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckoutMetadata(Collection<Metadata.BuilderImpl> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copyFromBuilder(checkoutMetadata);
        }

        @Override
        @Transient
        public final Builder checkoutMetadata(Collection<Metadata> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copy(checkoutMetadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder checkoutMetadata(Metadata... checkoutMetadata) {
            checkoutMetadata(Arrays.asList(checkoutMetadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder checkoutMetadata(Consumer<Metadata.Builder>... checkoutMetadata) {
            checkoutMetadata(Stream.of(checkoutMetadata).map(c -> Metadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CheckoutBorrowLicenseResponse build() {
            return new CheckoutBorrowLicenseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
