/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the failure of a license operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseOperationFailure implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseOperationFailure.Builder, LicenseOperationFailure> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(LicenseOperationFailure::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(LicenseOperationFailure::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(LicenseOperationFailure::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> FAILURE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FailureTime").getter(getter(LicenseOperationFailure::failureTime)).setter(setter(Builder::failureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureTime").build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(LicenseOperationFailure::operationName))
            .setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwnerId").getter(getter(LicenseOperationFailure::resourceOwnerId))
            .setter(setter(Builder::resourceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").build()).build();

    private static final SdkField<String> OPERATION_REQUESTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationRequestedBy").getter(getter(LicenseOperationFailure::operationRequestedBy))
            .setter(setter(Builder::operationRequestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationRequestedBy").build())
            .build();

    private static final SdkField<List<Metadata>> METADATA_LIST_FIELD = SdkField
            .<List<Metadata>> builder(MarshallingType.LIST)
            .memberName("MetadataList")
            .getter(getter(LicenseOperationFailure::metadataList))
            .setter(setter(Builder::metadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            RESOURCE_TYPE_FIELD, ERROR_MESSAGE_FIELD, FAILURE_TIME_FIELD, OPERATION_NAME_FIELD, RESOURCE_OWNER_ID_FIELD,
            OPERATION_REQUESTED_BY_FIELD, METADATA_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String resourceType;

    private final String errorMessage;

    private final Instant failureTime;

    private final String operationName;

    private final String resourceOwnerId;

    private final String operationRequestedBy;

    private final List<Metadata> metadataList;

    private LicenseOperationFailure(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.errorMessage = builder.errorMessage;
        this.failureTime = builder.failureTime;
        this.operationName = builder.operationName;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.operationRequestedBy = builder.operationRequestedBy;
        this.metadataList = builder.metadataList;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Resource type.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Resource type.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Error message.
     * </p>
     * 
     * @return Error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Failure time.
     * </p>
     * 
     * @return Failure time.
     */
    public final Instant failureTime() {
        return failureTime;
    }

    /**
     * <p>
     * Name of the operation.
     * </p>
     * 
     * @return Name of the operation.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * ID of the AWS account that owns the resource.
     * </p>
     * 
     * @return ID of the AWS account that owns the resource.
     */
    public final String resourceOwnerId() {
        return resourceOwnerId;
    }

    /**
     * <p>
     * The requester is "License Manager Automated Discovery".
     * </p>
     * 
     * @return The requester is "License Manager Automated Discovery".
     */
    public final String operationRequestedBy() {
        return operationRequestedBy;
    }

    /**
     * Returns true if the MetadataList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetadataList() {
        return metadataList != null && !(metadataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetadataList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Reserved.
     */
    public final List<Metadata> metadataList() {
        return metadataList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(failureTime());
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(operationRequestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataList() ? metadataList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseOperationFailure)) {
            return false;
        }
        LicenseOperationFailure other = (LicenseOperationFailure) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(failureTime(), other.failureTime())
                && Objects.equals(operationName(), other.operationName())
                && Objects.equals(resourceOwnerId(), other.resourceOwnerId())
                && Objects.equals(operationRequestedBy(), other.operationRequestedBy())
                && hasMetadataList() == other.hasMetadataList() && Objects.equals(metadataList(), other.metadataList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseOperationFailure").add("ResourceArn", resourceArn())
                .add("ResourceType", resourceTypeAsString()).add("ErrorMessage", errorMessage())
                .add("FailureTime", failureTime()).add("OperationName", operationName())
                .add("ResourceOwnerId", resourceOwnerId()).add("OperationRequestedBy", operationRequestedBy())
                .add("MetadataList", hasMetadataList() ? metadataList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "FailureTime":
            return Optional.ofNullable(clazz.cast(failureTime()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "ResourceOwnerId":
            return Optional.ofNullable(clazz.cast(resourceOwnerId()));
        case "OperationRequestedBy":
            return Optional.ofNullable(clazz.cast(operationRequestedBy()));
        case "MetadataList":
            return Optional.ofNullable(clazz.cast(metadataList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseOperationFailure, T> g) {
        return obj -> g.apply((LicenseOperationFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseOperationFailure> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Resource type.
         * </p>
         * 
         * @param resourceType
         *        Resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Resource type.
         * </p>
         * 
         * @param resourceType
         *        Resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Error message.
         * </p>
         * 
         * @param errorMessage
         *        Error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Failure time.
         * </p>
         * 
         * @param failureTime
         *        Failure time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureTime(Instant failureTime);

        /**
         * <p>
         * Name of the operation.
         * </p>
         * 
         * @param operationName
         *        Name of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * ID of the AWS account that owns the resource.
         * </p>
         * 
         * @param resourceOwnerId
         *        ID of the AWS account that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerId(String resourceOwnerId);

        /**
         * <p>
         * The requester is "License Manager Automated Discovery".
         * </p>
         * 
         * @param operationRequestedBy
         *        The requester is "License Manager Automated Discovery".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationRequestedBy(String operationRequestedBy);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param metadataList
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataList(Collection<Metadata> metadataList);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param metadataList
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataList(Metadata... metadataList);

        /**
         * <p>
         * Reserved.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Metadata>.Builder} avoiding the need to
         * create one manually via {@link List<Metadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataList(List<Metadata>)}.
         * 
         * @param metadataList
         *        a consumer that will call methods on {@link List<Metadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataList(List<Metadata>)
         */
        Builder metadataList(Consumer<Metadata.Builder>... metadataList);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceType;

        private String errorMessage;

        private Instant failureTime;

        private String operationName;

        private String resourceOwnerId;

        private String operationRequestedBy;

        private List<Metadata> metadataList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseOperationFailure model) {
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            errorMessage(model.errorMessage);
            failureTime(model.failureTime);
            operationName(model.operationName);
            resourceOwnerId(model.resourceOwnerId);
            operationRequestedBy(model.operationRequestedBy);
            metadataList(model.metadataList);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getFailureTime() {
            return failureTime;
        }

        public final void setFailureTime(Instant failureTime) {
            this.failureTime = failureTime;
        }

        @Override
        @Transient
        public final Builder failureTime(Instant failureTime) {
            this.failureTime = failureTime;
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        @Transient
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getResourceOwnerId() {
            return resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        @Transient
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final String getOperationRequestedBy() {
            return operationRequestedBy;
        }

        public final void setOperationRequestedBy(String operationRequestedBy) {
            this.operationRequestedBy = operationRequestedBy;
        }

        @Override
        @Transient
        public final Builder operationRequestedBy(String operationRequestedBy) {
            this.operationRequestedBy = operationRequestedBy;
            return this;
        }

        public final List<Metadata.Builder> getMetadataList() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.metadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataList(Collection<Metadata.BuilderImpl> metadataList) {
            this.metadataList = MetadataListCopier.copyFromBuilder(metadataList);
        }

        @Override
        @Transient
        public final Builder metadataList(Collection<Metadata> metadataList) {
            this.metadataList = MetadataListCopier.copy(metadataList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metadataList(Metadata... metadataList) {
            metadataList(Arrays.asList(metadataList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metadataList(Consumer<Metadata.Builder>... metadataList) {
            metadataList(Stream.of(metadataList).map(c -> Metadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LicenseOperationFailure build() {
            return new LicenseOperationFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
