/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLicenseConfigurationResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<GetLicenseConfigurationResponse.Builder, GetLicenseConfigurationResponse> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConfigurationId").getter(getter(GetLicenseConfigurationResponse::licenseConfigurationId))
            .setter(setter(Builder::licenseConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationId").build())
            .build();

    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConfigurationArn").getter(getter(GetLicenseConfigurationResponse::licenseConfigurationArn))
            .setter(setter(Builder::licenseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetLicenseConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetLicenseConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LICENSE_COUNTING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseCountingType").getter(getter(GetLicenseConfigurationResponse::licenseCountingTypeAsString))
            .setter(setter(Builder::licenseCountingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountingType").build())
            .build();

    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LicenseRules")
            .getter(getter(GetLicenseConfigurationResponse::licenseRules))
            .setter(setter(Builder::licenseRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LicenseCount").getter(getter(GetLicenseConfigurationResponse::licenseCount))
            .setter(setter(Builder::licenseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()).build();

    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LicenseCountHardLimit").getter(getter(GetLicenseConfigurationResponse::licenseCountHardLimit))
            .setter(setter(Builder::licenseCountHardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build())
            .build();

    private static final SdkField<Long> CONSUMED_LICENSES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ConsumedLicenses").getter(getter(GetLicenseConfigurationResponse::consumedLicenses))
            .setter(setter(Builder::consumedLicenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenses").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetLicenseConfigurationResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(GetLicenseConfigurationResponse::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<List<ConsumedLicenseSummary>> CONSUMED_LICENSE_SUMMARY_LIST_FIELD = SdkField
            .<List<ConsumedLicenseSummary>> builder(MarshallingType.LIST)
            .memberName("ConsumedLicenseSummaryList")
            .getter(getter(GetLicenseConfigurationResponse::consumedLicenseSummaryList))
            .setter(setter(Builder::consumedLicenseSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenseSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConsumedLicenseSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConsumedLicenseSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ManagedResourceSummary>> MANAGED_RESOURCE_SUMMARY_LIST_FIELD = SdkField
            .<List<ManagedResourceSummary>> builder(MarshallingType.LIST)
            .memberName("ManagedResourceSummaryList")
            .getter(getter(GetLicenseConfigurationResponse::managedResourceSummaryList))
            .setter(setter(Builder::managedResourceSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedResourceSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedResourceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedResourceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GetLicenseConfigurationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProductInformation>> PRODUCT_INFORMATION_LIST_FIELD = SdkField
            .<List<ProductInformation>> builder(MarshallingType.LIST)
            .memberName("ProductInformationList")
            .getter(getter(GetLicenseConfigurationResponse::productInformationList))
            .setter(setter(Builder::productInformationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutomatedDiscoveryInformation> AUTOMATED_DISCOVERY_INFORMATION_FIELD = SdkField
            .<AutomatedDiscoveryInformation> builder(MarshallingType.SDK_POJO)
            .memberName("AutomatedDiscoveryInformation")
            .getter(getter(GetLicenseConfigurationResponse::automatedDiscoveryInformation))
            .setter(setter(Builder::automatedDiscoveryInformation))
            .constructor(AutomatedDiscoveryInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedDiscoveryInformation")
                    .build()).build();

    private static final SdkField<Boolean> DISASSOCIATE_WHEN_NOT_FOUND_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DisassociateWhenNotFound")
            .getter(getter(GetLicenseConfigurationResponse::disassociateWhenNotFound))
            .setter(setter(Builder::disassociateWhenNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateWhenNotFound").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_ID_FIELD, LICENSE_CONFIGURATION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD,
            LICENSE_COUNTING_TYPE_FIELD, LICENSE_RULES_FIELD, LICENSE_COUNT_FIELD, LICENSE_COUNT_HARD_LIMIT_FIELD,
            CONSUMED_LICENSES_FIELD, STATUS_FIELD, OWNER_ACCOUNT_ID_FIELD, CONSUMED_LICENSE_SUMMARY_LIST_FIELD,
            MANAGED_RESOURCE_SUMMARY_LIST_FIELD, TAGS_FIELD, PRODUCT_INFORMATION_LIST_FIELD,
            AUTOMATED_DISCOVERY_INFORMATION_FIELD, DISASSOCIATE_WHEN_NOT_FOUND_FIELD));

    private final String licenseConfigurationId;

    private final String licenseConfigurationArn;

    private final String name;

    private final String description;

    private final String licenseCountingType;

    private final List<String> licenseRules;

    private final Long licenseCount;

    private final Boolean licenseCountHardLimit;

    private final Long consumedLicenses;

    private final String status;

    private final String ownerAccountId;

    private final List<ConsumedLicenseSummary> consumedLicenseSummaryList;

    private final List<ManagedResourceSummary> managedResourceSummaryList;

    private final List<Tag> tags;

    private final List<ProductInformation> productInformationList;

    private final AutomatedDiscoveryInformation automatedDiscoveryInformation;

    private final Boolean disassociateWhenNotFound;

    private GetLicenseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationId = builder.licenseConfigurationId;
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.licenseCountingType = builder.licenseCountingType;
        this.licenseRules = builder.licenseRules;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.consumedLicenses = builder.consumedLicenses;
        this.status = builder.status;
        this.ownerAccountId = builder.ownerAccountId;
        this.consumedLicenseSummaryList = builder.consumedLicenseSummaryList;
        this.managedResourceSummaryList = builder.managedResourceSummaryList;
        this.tags = builder.tags;
        this.productInformationList = builder.productInformationList;
        this.automatedDiscoveryInformation = builder.automatedDiscoveryInformation;
        this.disassociateWhenNotFound = builder.disassociateWhenNotFound;
    }

    /**
     * <p>
     * Unique ID for the license configuration.
     * </p>
     * 
     * @return Unique ID for the license configuration.
     */
    public final String licenseConfigurationId() {
        return licenseConfigurationId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license configuration.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license configuration.
     */
    public final String licenseConfigurationArn() {
        return licenseConfigurationArn;
    }

    /**
     * <p>
     * Name of the license configuration.
     * </p>
     * 
     * @return Name of the license configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description of the license configuration.
     * </p>
     * 
     * @return Description of the license configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Dimension for which the licenses are counted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseCountingType} will return {@link LicenseCountingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #licenseCountingTypeAsString}.
     * </p>
     * 
     * @return Dimension for which the licenses are counted.
     * @see LicenseCountingType
     */
    public final LicenseCountingType licenseCountingType() {
        return LicenseCountingType.fromValue(licenseCountingType);
    }

    /**
     * <p>
     * Dimension for which the licenses are counted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseCountingType} will return {@link LicenseCountingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #licenseCountingTypeAsString}.
     * </p>
     * 
     * @return Dimension for which the licenses are counted.
     * @see LicenseCountingType
     */
    public final String licenseCountingTypeAsString() {
        return licenseCountingType;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLicenseRules() {
        return licenseRules != null && !(licenseRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseRules} method.
     * </p>
     * 
     * @return License rules.
     */
    public final List<String> licenseRules() {
        return licenseRules;
    }

    /**
     * <p>
     * Number of available licenses.
     * </p>
     * 
     * @return Number of available licenses.
     */
    public final Long licenseCount() {
        return licenseCount;
    }

    /**
     * <p>
     * Sets the number of available licenses as a hard limit.
     * </p>
     * 
     * @return Sets the number of available licenses as a hard limit.
     */
    public final Boolean licenseCountHardLimit() {
        return licenseCountHardLimit;
    }

    /**
     * <p>
     * Number of licenses assigned to resources.
     * </p>
     * 
     * @return Number of licenses assigned to resources.
     */
    public final Long consumedLicenses() {
        return consumedLicenses;
    }

    /**
     * <p>
     * License configuration status.
     * </p>
     * 
     * @return License configuration status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Account ID of the owner of the license configuration.
     * </p>
     * 
     * @return Account ID of the owner of the license configuration.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConsumedLicenseSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConsumedLicenseSummaryList() {
        return consumedLicenseSummaryList != null && !(consumedLicenseSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the licenses consumed by resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConsumedLicenseSummaryList} method.
     * </p>
     * 
     * @return Summaries of the licenses consumed by resources.
     */
    public final List<ConsumedLicenseSummary> consumedLicenseSummaryList() {
        return consumedLicenseSummaryList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedResourceSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasManagedResourceSummaryList() {
        return managedResourceSummaryList != null && !(managedResourceSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the managed resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedResourceSummaryList} method.
     * </p>
     * 
     * @return Summaries of the managed resources.
     */
    public final List<ManagedResourceSummary> managedResourceSummaryList() {
        return managedResourceSummaryList;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags for the license configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the license configuration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductInformationList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProductInformationList() {
        return productInformationList != null && !(productInformationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Product information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductInformationList} method.
     * </p>
     * 
     * @return Product information.
     */
    public final List<ProductInformation> productInformationList() {
        return productInformationList;
    }

    /**
     * <p>
     * Automated discovery information.
     * </p>
     * 
     * @return Automated discovery information.
     */
    public final AutomatedDiscoveryInformation automatedDiscoveryInformation() {
        return automatedDiscoveryInformation;
    }

    /**
     * <p>
     * When true, disassociates a resource when software is uninstalled.
     * </p>
     * 
     * @return When true, disassociates a resource when software is uninstalled.
     */
    public final Boolean disassociateWhenNotFound() {
        return disassociateWhenNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCountingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseRules() ? licenseRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(consumedLicenses());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumedLicenseSummaryList() ? consumedLicenseSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedResourceSummaryList() ? managedResourceSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProductInformationList() ? productInformationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(automatedDiscoveryInformation());
        hashCode = 31 * hashCode + Objects.hashCode(disassociateWhenNotFound());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseConfigurationResponse)) {
            return false;
        }
        GetLicenseConfigurationResponse other = (GetLicenseConfigurationResponse) obj;
        return Objects.equals(licenseConfigurationId(), other.licenseConfigurationId())
                && Objects.equals(licenseConfigurationArn(), other.licenseConfigurationArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(licenseCountingTypeAsString(), other.licenseCountingTypeAsString())
                && hasLicenseRules() == other.hasLicenseRules() && Objects.equals(licenseRules(), other.licenseRules())
                && Objects.equals(licenseCount(), other.licenseCount())
                && Objects.equals(licenseCountHardLimit(), other.licenseCountHardLimit())
                && Objects.equals(consumedLicenses(), other.consumedLicenses()) && Objects.equals(status(), other.status())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && hasConsumedLicenseSummaryList() == other.hasConsumedLicenseSummaryList()
                && Objects.equals(consumedLicenseSummaryList(), other.consumedLicenseSummaryList())
                && hasManagedResourceSummaryList() == other.hasManagedResourceSummaryList()
                && Objects.equals(managedResourceSummaryList(), other.managedResourceSummaryList())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasProductInformationList() == other.hasProductInformationList()
                && Objects.equals(productInformationList(), other.productInformationList())
                && Objects.equals(automatedDiscoveryInformation(), other.automatedDiscoveryInformation())
                && Objects.equals(disassociateWhenNotFound(), other.disassociateWhenNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLicenseConfigurationResponse").add("LicenseConfigurationId", licenseConfigurationId())
                .add("LicenseConfigurationArn", licenseConfigurationArn()).add("Name", name()).add("Description", description())
                .add("LicenseCountingType", licenseCountingTypeAsString())
                .add("LicenseRules", hasLicenseRules() ? licenseRules() : null).add("LicenseCount", licenseCount())
                .add("LicenseCountHardLimit", licenseCountHardLimit()).add("ConsumedLicenses", consumedLicenses())
                .add("Status", status()).add("OwnerAccountId", ownerAccountId())
                .add("ConsumedLicenseSummaryList", hasConsumedLicenseSummaryList() ? consumedLicenseSummaryList() : null)
                .add("ManagedResourceSummaryList", hasManagedResourceSummaryList() ? managedResourceSummaryList() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("ProductInformationList", hasProductInformationList() ? productInformationList() : null)
                .add("AutomatedDiscoveryInformation", automatedDiscoveryInformation())
                .add("DisassociateWhenNotFound", disassociateWhenNotFound()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationId":
            return Optional.ofNullable(clazz.cast(licenseConfigurationId()));
        case "LicenseConfigurationArn":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LicenseCountingType":
            return Optional.ofNullable(clazz.cast(licenseCountingTypeAsString()));
        case "LicenseRules":
            return Optional.ofNullable(clazz.cast(licenseRules()));
        case "LicenseCount":
            return Optional.ofNullable(clazz.cast(licenseCount()));
        case "LicenseCountHardLimit":
            return Optional.ofNullable(clazz.cast(licenseCountHardLimit()));
        case "ConsumedLicenses":
            return Optional.ofNullable(clazz.cast(consumedLicenses()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "ConsumedLicenseSummaryList":
            return Optional.ofNullable(clazz.cast(consumedLicenseSummaryList()));
        case "ManagedResourceSummaryList":
            return Optional.ofNullable(clazz.cast(managedResourceSummaryList()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ProductInformationList":
            return Optional.ofNullable(clazz.cast(productInformationList()));
        case "AutomatedDiscoveryInformation":
            return Optional.ofNullable(clazz.cast(automatedDiscoveryInformation()));
        case "DisassociateWhenNotFound":
            return Optional.ofNullable(clazz.cast(disassociateWhenNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseConfigurationResponse, T> g) {
        return obj -> g.apply((GetLicenseConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLicenseConfigurationResponse> {
        /**
         * <p>
         * Unique ID for the license configuration.
         * </p>
         * 
         * @param licenseConfigurationId
         *        Unique ID for the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationId(String licenseConfigurationId);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the license configuration.
         * </p>
         * 
         * @param licenseConfigurationArn
         *        Amazon Resource Name (ARN) of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArn(String licenseConfigurationArn);

        /**
         * <p>
         * Name of the license configuration.
         * </p>
         * 
         * @param name
         *        Name of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the license configuration.
         * </p>
         * 
         * @param description
         *        Description of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Dimension for which the licenses are counted.
         * </p>
         * 
         * @param licenseCountingType
         *        Dimension for which the licenses are counted.
         * @see LicenseCountingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseCountingType
         */
        Builder licenseCountingType(String licenseCountingType);

        /**
         * <p>
         * Dimension for which the licenses are counted.
         * </p>
         * 
         * @param licenseCountingType
         *        Dimension for which the licenses are counted.
         * @see LicenseCountingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseCountingType
         */
        Builder licenseCountingType(LicenseCountingType licenseCountingType);

        /**
         * <p>
         * License rules.
         * </p>
         * 
         * @param licenseRules
         *        License rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(Collection<String> licenseRules);

        /**
         * <p>
         * License rules.
         * </p>
         * 
         * @param licenseRules
         *        License rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(String... licenseRules);

        /**
         * <p>
         * Number of available licenses.
         * </p>
         * 
         * @param licenseCount
         *        Number of available licenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCount(Long licenseCount);

        /**
         * <p>
         * Sets the number of available licenses as a hard limit.
         * </p>
         * 
         * @param licenseCountHardLimit
         *        Sets the number of available licenses as a hard limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCountHardLimit(Boolean licenseCountHardLimit);

        /**
         * <p>
         * Number of licenses assigned to resources.
         * </p>
         * 
         * @param consumedLicenses
         *        Number of licenses assigned to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedLicenses(Long consumedLicenses);

        /**
         * <p>
         * License configuration status.
         * </p>
         * 
         * @param status
         *        License configuration status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Account ID of the owner of the license configuration.
         * </p>
         * 
         * @param ownerAccountId
         *        Account ID of the owner of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * Summaries of the licenses consumed by resources.
         * </p>
         * 
         * @param consumedLicenseSummaryList
         *        Summaries of the licenses consumed by resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedLicenseSummaryList(Collection<ConsumedLicenseSummary> consumedLicenseSummaryList);

        /**
         * <p>
         * Summaries of the licenses consumed by resources.
         * </p>
         * 
         * @param consumedLicenseSummaryList
         *        Summaries of the licenses consumed by resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedLicenseSummaryList(ConsumedLicenseSummary... consumedLicenseSummaryList);

        /**
         * <p>
         * Summaries of the licenses consumed by resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ConsumedLicenseSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ConsumedLicenseSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConsumedLicenseSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #consumedLicenseSummaryList(List<ConsumedLicenseSummary>)}.
         * 
         * @param consumedLicenseSummaryList
         *        a consumer that will call methods on {@link List<ConsumedLicenseSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedLicenseSummaryList(List<ConsumedLicenseSummary>)
         */
        Builder consumedLicenseSummaryList(Consumer<ConsumedLicenseSummary.Builder>... consumedLicenseSummaryList);

        /**
         * <p>
         * Summaries of the managed resources.
         * </p>
         * 
         * @param managedResourceSummaryList
         *        Summaries of the managed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedResourceSummaryList(Collection<ManagedResourceSummary> managedResourceSummaryList);

        /**
         * <p>
         * Summaries of the managed resources.
         * </p>
         * 
         * @param managedResourceSummaryList
         *        Summaries of the managed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedResourceSummaryList(ManagedResourceSummary... managedResourceSummaryList);

        /**
         * <p>
         * Summaries of the managed resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ManagedResourceSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ManagedResourceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ManagedResourceSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #managedResourceSummaryList(List<ManagedResourceSummary>)}.
         * 
         * @param managedResourceSummaryList
         *        a consumer that will call methods on {@link List<ManagedResourceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedResourceSummaryList(List<ManagedResourceSummary>)
         */
        Builder managedResourceSummaryList(Consumer<ManagedResourceSummary.Builder>... managedResourceSummaryList);

        /**
         * <p>
         * Tags for the license configuration.
         * </p>
         * 
         * @param tags
         *        Tags for the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags for the license configuration.
         * </p>
         * 
         * @param tags
         *        Tags for the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags for the license configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Product information.
         * </p>
         * 
         * @param productInformationList
         *        Product information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationList(Collection<ProductInformation> productInformationList);

        /**
         * <p>
         * Product information.
         * </p>
         * 
         * @param productInformationList
         *        Product information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationList(ProductInformation... productInformationList);

        /**
         * <p>
         * Product information.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProductInformation>.Builder}
         * avoiding the need to create one manually via {@link List<ProductInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductInformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #productInformationList(List<ProductInformation>)}.
         * 
         * @param productInformationList
         *        a consumer that will call methods on {@link List<ProductInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productInformationList(List<ProductInformation>)
         */
        Builder productInformationList(Consumer<ProductInformation.Builder>... productInformationList);

        /**
         * <p>
         * Automated discovery information.
         * </p>
         * 
         * @param automatedDiscoveryInformation
         *        Automated discovery information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedDiscoveryInformation(AutomatedDiscoveryInformation automatedDiscoveryInformation);

        /**
         * <p>
         * Automated discovery information.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedDiscoveryInformation.Builder}
         * avoiding the need to create one manually via {@link AutomatedDiscoveryInformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutomatedDiscoveryInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #automatedDiscoveryInformation(AutomatedDiscoveryInformation)}
         * .
         * 
         * @param automatedDiscoveryInformation
         *        a consumer that will call methods on {@link AutomatedDiscoveryInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automatedDiscoveryInformation(AutomatedDiscoveryInformation)
         */
        default Builder automatedDiscoveryInformation(
                Consumer<AutomatedDiscoveryInformation.Builder> automatedDiscoveryInformation) {
            return automatedDiscoveryInformation(AutomatedDiscoveryInformation.builder()
                    .applyMutation(automatedDiscoveryInformation).build());
        }

        /**
         * <p>
         * When true, disassociates a resource when software is uninstalled.
         * </p>
         * 
         * @param disassociateWhenNotFound
         *        When true, disassociates a resource when software is uninstalled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateWhenNotFound(Boolean disassociateWhenNotFound);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String licenseConfigurationId;

        private String licenseConfigurationArn;

        private String name;

        private String description;

        private String licenseCountingType;

        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();

        private Long licenseCount;

        private Boolean licenseCountHardLimit;

        private Long consumedLicenses;

        private String status;

        private String ownerAccountId;

        private List<ConsumedLicenseSummary> consumedLicenseSummaryList = DefaultSdkAutoConstructList.getInstance();

        private List<ManagedResourceSummary> managedResourceSummaryList = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<ProductInformation> productInformationList = DefaultSdkAutoConstructList.getInstance();

        private AutomatedDiscoveryInformation automatedDiscoveryInformation;

        private Boolean disassociateWhenNotFound;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseConfigurationResponse model) {
            super(model);
            licenseConfigurationId(model.licenseConfigurationId);
            licenseConfigurationArn(model.licenseConfigurationArn);
            name(model.name);
            description(model.description);
            licenseCountingType(model.licenseCountingType);
            licenseRules(model.licenseRules);
            licenseCount(model.licenseCount);
            licenseCountHardLimit(model.licenseCountHardLimit);
            consumedLicenses(model.consumedLicenses);
            status(model.status);
            ownerAccountId(model.ownerAccountId);
            consumedLicenseSummaryList(model.consumedLicenseSummaryList);
            managedResourceSummaryList(model.managedResourceSummaryList);
            tags(model.tags);
            productInformationList(model.productInformationList);
            automatedDiscoveryInformation(model.automatedDiscoveryInformation);
            disassociateWhenNotFound(model.disassociateWhenNotFound);
        }

        public final String getLicenseConfigurationId() {
            return licenseConfigurationId;
        }

        public final void setLicenseConfigurationId(String licenseConfigurationId) {
            this.licenseConfigurationId = licenseConfigurationId;
        }

        @Override
        @Transient
        public final Builder licenseConfigurationId(String licenseConfigurationId) {
            this.licenseConfigurationId = licenseConfigurationId;
            return this;
        }

        public final String getLicenseConfigurationArn() {
            return licenseConfigurationArn;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        @Override
        @Transient
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLicenseCountingType() {
            return licenseCountingType;
        }

        public final void setLicenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
        }

        @Override
        @Transient
        public final Builder licenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
            return this;
        }

        @Override
        @Transient
        public final Builder licenseCountingType(LicenseCountingType licenseCountingType) {
            this.licenseCountingType(licenseCountingType == null ? null : licenseCountingType.toString());
            return this;
        }

        public final Collection<String> getLicenseRules() {
            if (licenseRules instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseRules;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        @Override
        @Transient
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseRules(String... licenseRules) {
            licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final Long getLicenseCount() {
            return licenseCount;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        @Override
        @Transient
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final Boolean getLicenseCountHardLimit() {
            return licenseCountHardLimit;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        @Override
        @Transient
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final Long getConsumedLicenses() {
            return consumedLicenses;
        }

        public final void setConsumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
        }

        @Override
        @Transient
        public final Builder consumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        @Transient
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final List<ConsumedLicenseSummary.Builder> getConsumedLicenseSummaryList() {
            List<ConsumedLicenseSummary.Builder> result = ConsumedLicenseSummaryListCopier
                    .copyToBuilder(this.consumedLicenseSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumedLicenseSummaryList(Collection<ConsumedLicenseSummary.BuilderImpl> consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList = ConsumedLicenseSummaryListCopier.copyFromBuilder(consumedLicenseSummaryList);
        }

        @Override
        @Transient
        public final Builder consumedLicenseSummaryList(Collection<ConsumedLicenseSummary> consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList = ConsumedLicenseSummaryListCopier.copy(consumedLicenseSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder consumedLicenseSummaryList(ConsumedLicenseSummary... consumedLicenseSummaryList) {
            consumedLicenseSummaryList(Arrays.asList(consumedLicenseSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder consumedLicenseSummaryList(Consumer<ConsumedLicenseSummary.Builder>... consumedLicenseSummaryList) {
            consumedLicenseSummaryList(Stream.of(consumedLicenseSummaryList)
                    .map(c -> ConsumedLicenseSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedResourceSummary.Builder> getManagedResourceSummaryList() {
            List<ManagedResourceSummary.Builder> result = ManagedResourceSummaryListCopier
                    .copyToBuilder(this.managedResourceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedResourceSummaryList(Collection<ManagedResourceSummary.BuilderImpl> managedResourceSummaryList) {
            this.managedResourceSummaryList = ManagedResourceSummaryListCopier.copyFromBuilder(managedResourceSummaryList);
        }

        @Override
        @Transient
        public final Builder managedResourceSummaryList(Collection<ManagedResourceSummary> managedResourceSummaryList) {
            this.managedResourceSummaryList = ManagedResourceSummaryListCopier.copy(managedResourceSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedResourceSummaryList(ManagedResourceSummary... managedResourceSummaryList) {
            managedResourceSummaryList(Arrays.asList(managedResourceSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedResourceSummaryList(Consumer<ManagedResourceSummary.Builder>... managedResourceSummaryList) {
            managedResourceSummaryList(Stream.of(managedResourceSummaryList)
                    .map(c -> ManagedResourceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProductInformation.Builder> getProductInformationList() {
            List<ProductInformation.Builder> result = ProductInformationListCopier.copyToBuilder(this.productInformationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductInformationList(Collection<ProductInformation.BuilderImpl> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copyFromBuilder(productInformationList);
        }

        @Override
        @Transient
        public final Builder productInformationList(Collection<ProductInformation> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copy(productInformationList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productInformationList(ProductInformation... productInformationList) {
            productInformationList(Arrays.asList(productInformationList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productInformationList(Consumer<ProductInformation.Builder>... productInformationList) {
            productInformationList(Stream.of(productInformationList)
                    .map(c -> ProductInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutomatedDiscoveryInformation.Builder getAutomatedDiscoveryInformation() {
            return automatedDiscoveryInformation != null ? automatedDiscoveryInformation.toBuilder() : null;
        }

        public final void setAutomatedDiscoveryInformation(AutomatedDiscoveryInformation.BuilderImpl automatedDiscoveryInformation) {
            this.automatedDiscoveryInformation = automatedDiscoveryInformation != null ? automatedDiscoveryInformation.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder automatedDiscoveryInformation(AutomatedDiscoveryInformation automatedDiscoveryInformation) {
            this.automatedDiscoveryInformation = automatedDiscoveryInformation;
            return this;
        }

        public final Boolean getDisassociateWhenNotFound() {
            return disassociateWhenNotFound;
        }

        public final void setDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
            this.disassociateWhenNotFound = disassociateWhenNotFound;
        }

        @Override
        @Transient
        public final Builder disassociateWhenNotFound(Boolean disassociateWhenNotFound) {
            this.disassociateWhenNotFound = disassociateWhenNotFound;
            return this;
        }

        @Override
        public GetLicenseConfigurationResponse build() {
            return new GetLicenseConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
