/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Software license that is managed in License Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class License implements SdkPojo, Serializable, ToCopyableBuilder<License.Builder, License> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(License::licenseArn)).setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseName").getter(getter(License::licenseName)).setter(setter(Builder::licenseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseName").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(License::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> PRODUCT_SKU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductSKU").getter(getter(License::productSKU)).setter(setter(Builder::productSKU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSKU").build()).build();

    private static final SdkField<IssuerDetails> ISSUER_FIELD = SdkField.<IssuerDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Issuer").getter(getter(License::issuer)).setter(setter(Builder::issuer))
            .constructor(IssuerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(License::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(License::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<DatetimeRange> VALIDITY_FIELD = SdkField.<DatetimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("Validity").getter(getter(License::validity)).setter(setter(Builder::validity))
            .constructor(DatetimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()).build();

    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Beneficiary").getter(getter(License::beneficiary)).setter(setter(Builder::beneficiary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()).build();

    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<Entitlement>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(License::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConsumptionConfiguration> CONSUMPTION_CONFIGURATION_FIELD = SdkField
            .<ConsumptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConsumptionConfiguration")
            .getter(getter(License::consumptionConfiguration)).setter(setter(Builder::consumptionConfiguration))
            .constructor(ConsumptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumptionConfiguration").build())
            .build();

    private static final SdkField<List<Metadata>> LICENSE_METADATA_FIELD = SdkField
            .<List<Metadata>> builder(MarshallingType.LIST)
            .memberName("LicenseMetadata")
            .getter(getter(License::licenseMetadata))
            .setter(setter(Builder::licenseMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateTime").getter(getter(License::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(License::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD,
            LICENSE_NAME_FIELD, PRODUCT_NAME_FIELD, PRODUCT_SKU_FIELD, ISSUER_FIELD, HOME_REGION_FIELD, STATUS_FIELD,
            VALIDITY_FIELD, BENEFICIARY_FIELD, ENTITLEMENTS_FIELD, CONSUMPTION_CONFIGURATION_FIELD, LICENSE_METADATA_FIELD,
            CREATE_TIME_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String licenseArn;

    private final String licenseName;

    private final String productName;

    private final String productSKU;

    private final IssuerDetails issuer;

    private final String homeRegion;

    private final String status;

    private final DatetimeRange validity;

    private final String beneficiary;

    private final List<Entitlement> entitlements;

    private final ConsumptionConfiguration consumptionConfiguration;

    private final List<Metadata> licenseMetadata;

    private final String createTime;

    private final String version;

    private License(BuilderImpl builder) {
        this.licenseArn = builder.licenseArn;
        this.licenseName = builder.licenseName;
        this.productName = builder.productName;
        this.productSKU = builder.productSKU;
        this.issuer = builder.issuer;
        this.homeRegion = builder.homeRegion;
        this.status = builder.status;
        this.validity = builder.validity;
        this.beneficiary = builder.beneficiary;
        this.entitlements = builder.entitlements;
        this.consumptionConfiguration = builder.consumptionConfiguration;
        this.licenseMetadata = builder.licenseMetadata;
        this.createTime = builder.createTime;
        this.version = builder.version;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license.
     */
    public final String licenseArn() {
        return licenseArn;
    }

    /**
     * <p>
     * License name.
     * </p>
     * 
     * @return License name.
     */
    public final String licenseName() {
        return licenseName;
    }

    /**
     * <p>
     * Product name.
     * </p>
     * 
     * @return Product name.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * Product SKU.
     * </p>
     * 
     * @return Product SKU.
     */
    public final String productSKU() {
        return productSKU;
    }

    /**
     * <p>
     * License issuer.
     * </p>
     * 
     * @return License issuer.
     */
    public final IssuerDetails issuer() {
        return issuer;
    }

    /**
     * <p>
     * Home Region of the license.
     * </p>
     * 
     * @return Home Region of the license.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * License status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return License status.
     * @see LicenseStatus
     */
    public final LicenseStatus status() {
        return LicenseStatus.fromValue(status);
    }

    /**
     * <p>
     * License status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return License status.
     * @see LicenseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Date and time range during which the license is valid, in ISO8601-UTC format.
     * </p>
     * 
     * @return Date and time range during which the license is valid, in ISO8601-UTC format.
     */
    public final DatetimeRange validity() {
        return validity;
    }

    /**
     * <p>
     * License beneficiary.
     * </p>
     * 
     * @return License beneficiary.
     */
    public final String beneficiary() {
        return beneficiary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entitlements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License entitlements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitlements} method.
     * </p>
     * 
     * @return License entitlements.
     */
    public final List<Entitlement> entitlements() {
        return entitlements;
    }

    /**
     * <p>
     * Configuration for consumption of the license.
     * </p>
     * 
     * @return Configuration for consumption of the license.
     */
    public final ConsumptionConfiguration consumptionConfiguration() {
        return consumptionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLicenseMetadata() {
        return licenseMetadata != null && !(licenseMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseMetadata} method.
     * </p>
     * 
     * @return License metadata.
     */
    public final List<Metadata> licenseMetadata() {
        return licenseMetadata;
    }

    /**
     * <p>
     * License creation time.
     * </p>
     * 
     * @return License creation time.
     */
    public final String createTime() {
        return createTime;
    }

    /**
     * <p>
     * License version.
     * </p>
     * 
     * @return License version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseName());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(productSKU());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        hashCode = 31 * hashCode + Objects.hashCode(beneficiary());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consumptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseMetadata() ? licenseMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof License)) {
            return false;
        }
        License other = (License) obj;
        return Objects.equals(licenseArn(), other.licenseArn()) && Objects.equals(licenseName(), other.licenseName())
                && Objects.equals(productName(), other.productName()) && Objects.equals(productSKU(), other.productSKU())
                && Objects.equals(issuer(), other.issuer()) && Objects.equals(homeRegion(), other.homeRegion())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(validity(), other.validity())
                && Objects.equals(beneficiary(), other.beneficiary()) && hasEntitlements() == other.hasEntitlements()
                && Objects.equals(entitlements(), other.entitlements())
                && Objects.equals(consumptionConfiguration(), other.consumptionConfiguration())
                && hasLicenseMetadata() == other.hasLicenseMetadata()
                && Objects.equals(licenseMetadata(), other.licenseMetadata()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("License").add("LicenseArn", licenseArn()).add("LicenseName", licenseName())
                .add("ProductName", productName()).add("ProductSKU", productSKU()).add("Issuer", issuer())
                .add("HomeRegion", homeRegion()).add("Status", statusAsString()).add("Validity", validity())
                .add("Beneficiary", beneficiary()).add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("ConsumptionConfiguration", consumptionConfiguration())
                .add("LicenseMetadata", hasLicenseMetadata() ? licenseMetadata() : null).add("CreateTime", createTime())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "LicenseName":
            return Optional.ofNullable(clazz.cast(licenseName()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "ProductSKU":
            return Optional.ofNullable(clazz.cast(productSKU()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Validity":
            return Optional.ofNullable(clazz.cast(validity()));
        case "Beneficiary":
            return Optional.ofNullable(clazz.cast(beneficiary()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "ConsumptionConfiguration":
            return Optional.ofNullable(clazz.cast(consumptionConfiguration()));
        case "LicenseMetadata":
            return Optional.ofNullable(clazz.cast(licenseMetadata()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<License, T> g) {
        return obj -> g.apply((License) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, License> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * License name.
         * </p>
         * 
         * @param licenseName
         *        License name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseName(String licenseName);

        /**
         * <p>
         * Product name.
         * </p>
         * 
         * @param productName
         *        Product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * Product SKU.
         * </p>
         * 
         * @param productSKU
         *        Product SKU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productSKU(String productSKU);

        /**
         * <p>
         * License issuer.
         * </p>
         * 
         * @param issuer
         *        License issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(IssuerDetails issuer);

        /**
         * <p>
         * License issuer.
         * </p>
         * This is a convenience method that creates an instance of the {@link IssuerDetails.Builder} avoiding the need
         * to create one manually via {@link IssuerDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link IssuerDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #issuer(IssuerDetails)}.
         * 
         * @param issuer
         *        a consumer that will call methods on {@link IssuerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuer(IssuerDetails)
         */
        default Builder issuer(Consumer<IssuerDetails.Builder> issuer) {
            return issuer(IssuerDetails.builder().applyMutation(issuer).build());
        }

        /**
         * <p>
         * Home Region of the license.
         * </p>
         * 
         * @param homeRegion
         *        Home Region of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * License status.
         * </p>
         * 
         * @param status
         *        License status.
         * @see LicenseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * License status.
         * </p>
         * 
         * @param status
         *        License status.
         * @see LicenseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseStatus
         */
        Builder status(LicenseStatus status);

        /**
         * <p>
         * Date and time range during which the license is valid, in ISO8601-UTC format.
         * </p>
         * 
         * @param validity
         *        Date and time range during which the license is valid, in ISO8601-UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(DatetimeRange validity);

        /**
         * <p>
         * Date and time range during which the license is valid, in ISO8601-UTC format.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatetimeRange.Builder} avoiding the need
         * to create one manually via {@link DatetimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatetimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #validity(DatetimeRange)}.
         * 
         * @param validity
         *        a consumer that will call methods on {@link DatetimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validity(DatetimeRange)
         */
        default Builder validity(Consumer<DatetimeRange.Builder> validity) {
            return validity(DatetimeRange.builder().applyMutation(validity).build());
        }

        /**
         * <p>
         * License beneficiary.
         * </p>
         * 
         * @param beneficiary
         *        License beneficiary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beneficiary(String beneficiary);

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<Entitlement> entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Entitlement... entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Entitlement>.Builder} avoiding the
         * need to create one manually via {@link List<Entitlement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entitlement>.Builder#build()} is called immediately and its
         * result is passed to {@link #entitlements(List<Entitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<Entitlement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<Entitlement>)
         */
        Builder entitlements(Consumer<Entitlement.Builder>... entitlements);

        /**
         * <p>
         * Configuration for consumption of the license.
         * </p>
         * 
         * @param consumptionConfiguration
         *        Configuration for consumption of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration);

        /**
         * <p>
         * Configuration for consumption of the license.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link ConsumptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConsumptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #consumptionConfiguration(ConsumptionConfiguration)}.
         * 
         * @param consumptionConfiguration
         *        a consumer that will call methods on {@link ConsumptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumptionConfiguration(ConsumptionConfiguration)
         */
        default Builder consumptionConfiguration(Consumer<ConsumptionConfiguration.Builder> consumptionConfiguration) {
            return consumptionConfiguration(ConsumptionConfiguration.builder().applyMutation(consumptionConfiguration).build());
        }

        /**
         * <p>
         * License metadata.
         * </p>
         * 
         * @param licenseMetadata
         *        License metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseMetadata(Collection<Metadata> licenseMetadata);

        /**
         * <p>
         * License metadata.
         * </p>
         * 
         * @param licenseMetadata
         *        License metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseMetadata(Metadata... licenseMetadata);

        /**
         * <p>
         * License metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Metadata>.Builder} avoiding the need
         * to create one manually via {@link List<Metadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #licenseMetadata(List<Metadata>)}.
         * 
         * @param licenseMetadata
         *        a consumer that will call methods on {@link List<Metadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseMetadata(List<Metadata>)
         */
        Builder licenseMetadata(Consumer<Metadata.Builder>... licenseMetadata);

        /**
         * <p>
         * License creation time.
         * </p>
         * 
         * @param createTime
         *        License creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(String createTime);

        /**
         * <p>
         * License version.
         * </p>
         * 
         * @param version
         *        License version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String licenseArn;

        private String licenseName;

        private String productName;

        private String productSKU;

        private IssuerDetails issuer;

        private String homeRegion;

        private String status;

        private DatetimeRange validity;

        private String beneficiary;

        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private ConsumptionConfiguration consumptionConfiguration;

        private List<Metadata> licenseMetadata = DefaultSdkAutoConstructList.getInstance();

        private String createTime;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(License model) {
            licenseArn(model.licenseArn);
            licenseName(model.licenseName);
            productName(model.productName);
            productSKU(model.productSKU);
            issuer(model.issuer);
            homeRegion(model.homeRegion);
            status(model.status);
            validity(model.validity);
            beneficiary(model.beneficiary);
            entitlements(model.entitlements);
            consumptionConfiguration(model.consumptionConfiguration);
            licenseMetadata(model.licenseMetadata);
            createTime(model.createTime);
            version(model.version);
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        @Transient
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getLicenseName() {
            return licenseName;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        @Override
        @Transient
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        @Transient
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getProductSKU() {
            return productSKU;
        }

        public final void setProductSKU(String productSKU) {
            this.productSKU = productSKU;
        }

        @Override
        @Transient
        public final Builder productSKU(String productSKU) {
            this.productSKU = productSKU;
            return this;
        }

        public final IssuerDetails.Builder getIssuer() {
            return issuer != null ? issuer.toBuilder() : null;
        }

        public final void setIssuer(IssuerDetails.BuilderImpl issuer) {
            this.issuer = issuer != null ? issuer.build() : null;
        }

        @Override
        @Transient
        public final Builder issuer(IssuerDetails issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        @Transient
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(LicenseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DatetimeRange.Builder getValidity() {
            return validity != null ? validity.toBuilder() : null;
        }

        public final void setValidity(DatetimeRange.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        @Override
        @Transient
        public final Builder validity(DatetimeRange validity) {
            this.validity = validity;
            return this;
        }

        public final String getBeneficiary() {
            return beneficiary;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        @Override
        @Transient
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = EntitlementListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = EntitlementListCopier.copyFromBuilder(entitlements);
        }

        @Override
        @Transient
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = EntitlementListCopier.copy(entitlements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlements(Entitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> Entitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ConsumptionConfiguration.Builder getConsumptionConfiguration() {
            return consumptionConfiguration != null ? consumptionConfiguration.toBuilder() : null;
        }

        public final void setConsumptionConfiguration(ConsumptionConfiguration.BuilderImpl consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration != null ? consumptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        public final List<Metadata.Builder> getLicenseMetadata() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.licenseMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseMetadata(Collection<Metadata.BuilderImpl> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copyFromBuilder(licenseMetadata);
        }

        @Override
        @Transient
        public final Builder licenseMetadata(Collection<Metadata> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copy(licenseMetadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseMetadata(Metadata... licenseMetadata) {
            licenseMetadata(Arrays.asList(licenseMetadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseMetadata(Consumer<Metadata.Builder>... licenseMetadata) {
            licenseMetadata(Stream.of(licenseMetadata).map(c -> Metadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public License build() {
            return new License(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
