/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsageForLicenseConfigurationResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListUsageForLicenseConfigurationResponse.Builder, ListUsageForLicenseConfigurationResponse> {
    private static final SdkField<List<LicenseConfigurationUsage>> LICENSE_CONFIGURATION_USAGE_LIST_FIELD = SdkField
            .<List<LicenseConfigurationUsage>> builder(MarshallingType.LIST)
            .memberName("LicenseConfigurationUsageList")
            .getter(getter(ListUsageForLicenseConfigurationResponse::licenseConfigurationUsageList))
            .setter(setter(Builder::licenseConfigurationUsageList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationUsageList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseConfigurationUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseConfigurationUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListUsageForLicenseConfigurationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_USAGE_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<LicenseConfigurationUsage> licenseConfigurationUsageList;

    private final String nextToken;

    private ListUsageForLicenseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationUsageList = builder.licenseConfigurationUsageList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseConfigurationUsageList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseConfigurationUsageList() {
        return licenseConfigurationUsageList != null && !(licenseConfigurationUsageList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseConfigurationUsageList} method.
     * </p>
     * 
     * @return Information about the license configurations.
     */
    public final List<LicenseConfigurationUsage> licenseConfigurationUsageList() {
        return licenseConfigurationUsageList;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseConfigurationUsageList() ? licenseConfigurationUsageList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsageForLicenseConfigurationResponse)) {
            return false;
        }
        ListUsageForLicenseConfigurationResponse other = (ListUsageForLicenseConfigurationResponse) obj;
        return hasLicenseConfigurationUsageList() == other.hasLicenseConfigurationUsageList()
                && Objects.equals(licenseConfigurationUsageList(), other.licenseConfigurationUsageList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListUsageForLicenseConfigurationResponse")
                .add("LicenseConfigurationUsageList", hasLicenseConfigurationUsageList() ? licenseConfigurationUsageList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationUsageList":
            return Optional.ofNullable(clazz.cast(licenseConfigurationUsageList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsageForLicenseConfigurationResponse, T> g) {
        return obj -> g.apply((ListUsageForLicenseConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUsageForLicenseConfigurationResponse> {
        /**
         * <p>
         * Information about the license configurations.
         * </p>
         * 
         * @param licenseConfigurationUsageList
         *        Information about the license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationUsageList(Collection<LicenseConfigurationUsage> licenseConfigurationUsageList);

        /**
         * <p>
         * Information about the license configurations.
         * </p>
         * 
         * @param licenseConfigurationUsageList
         *        Information about the license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationUsageList(LicenseConfigurationUsage... licenseConfigurationUsageList);

        /**
         * <p>
         * Information about the license configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LicenseConfigurationUsage>.Builder}
         * avoiding the need to create one manually via {@link List<LicenseConfigurationUsage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseConfigurationUsage>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #licenseConfigurationUsageList(List<LicenseConfigurationUsage>)}.
         * 
         * @param licenseConfigurationUsageList
         *        a consumer that will call methods on {@link List<LicenseConfigurationUsage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseConfigurationUsageList(List<LicenseConfigurationUsage>)
         */
        Builder licenseConfigurationUsageList(Consumer<LicenseConfigurationUsage.Builder>... licenseConfigurationUsageList);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<LicenseConfigurationUsage> licenseConfigurationUsageList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsageForLicenseConfigurationResponse model) {
            super(model);
            licenseConfigurationUsageList(model.licenseConfigurationUsageList);
            nextToken(model.nextToken);
        }

        public final List<LicenseConfigurationUsage.Builder> getLicenseConfigurationUsageList() {
            List<LicenseConfigurationUsage.Builder> result = LicenseConfigurationUsageListCopier
                    .copyToBuilder(this.licenseConfigurationUsageList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseConfigurationUsageList(
                Collection<LicenseConfigurationUsage.BuilderImpl> licenseConfigurationUsageList) {
            this.licenseConfigurationUsageList = LicenseConfigurationUsageListCopier
                    .copyFromBuilder(licenseConfigurationUsageList);
        }

        @Override
        @Transient
        public final Builder licenseConfigurationUsageList(Collection<LicenseConfigurationUsage> licenseConfigurationUsageList) {
            this.licenseConfigurationUsageList = LicenseConfigurationUsageListCopier.copy(licenseConfigurationUsageList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseConfigurationUsageList(LicenseConfigurationUsage... licenseConfigurationUsageList) {
            licenseConfigurationUsageList(Arrays.asList(licenseConfigurationUsageList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseConfigurationUsageList(
                Consumer<LicenseConfigurationUsage.Builder>... licenseConfigurationUsageList) {
            licenseConfigurationUsageList(Stream.of(licenseConfigurationUsageList)
                    .map(c -> LicenseConfigurationUsage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUsageForLicenseConfigurationResponse build() {
            return new ListUsageForLicenseConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
