/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes product information for a license configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductInformation.Builder, ProductInformation> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ProductInformation::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<ProductInformationFilter>> PRODUCT_INFORMATION_FILTER_LIST_FIELD = SdkField
            .<List<ProductInformationFilter>> builder(MarshallingType.LIST)
            .memberName("ProductInformationFilterList")
            .getter(getter(ProductInformation::productInformationFilterList))
            .setter(setter(Builder::productInformationFilterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductInformationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductInformationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            PRODUCT_INFORMATION_FILTER_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final List<ProductInformationFilter> productInformationFilterList;

    private ProductInformation(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.productInformationFilterList = builder.productInformationFilterList;
    }

    /**
     * <p>
     * Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.
     * </p>
     * 
     * @return Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductInformationFilterList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProductInformationFilterList() {
        return productInformationFilterList != null && !(productInformationFilterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical
     * operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and a
     * <code>ProductInformationFilterValue</code> that specifies the value to filter on.
     * </p>
     * <p>
     * Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and valid
     * options for <code>ProductInformationFilterComparator</code>.
     * </p>
     * <p>
     * The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Application Publisher</code> - The publisher of the application. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from
     * automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag must be appended to
     * <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>.
     * <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated
     * discovery. Logical operator is <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
     * <code>NOT_EQUALS</code>. Possible values are: <code>sql-server-enterprise</code> |
     * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following filters and logical operators are supported when the resource type is <code>RDS</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Engine Edition</code> - The edition of the database engine. Logical operator is <code>EQUALS</code>.
     * Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> |
     * <code>oracle-se2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values are:
     * <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> | <code>ols</code> |
     * <code>olap</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductInformationFilterList} method.
     * </p>
     * 
     * @return A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a
     *         logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being
     *         declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p>
     *         <p>
     *         Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and
     *         valid options for <code>ProductInformationFilterComparator</code>.
     *         </p>
     *         <p>
     *         The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Application Publisher</code> - The publisher of the application. Logical operator is
     *         <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Application Version</code> - The version of the application. Logical operator is
     *         <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude
     *         from automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag must be
     *         appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>.
     *         <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from
     *         automated discovery. Logical operator is <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code>
     *         and <code>NOT_EQUALS</code>. Possible values are: <code>sql-server-enterprise</code> |
     *         <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following filters and logical operators are supported when the resource type is <code>RDS</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Engine Edition</code> - The edition of the database engine. Logical operator is <code>EQUALS</code>
     *         . Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> |
     *         <code>oracle-se2</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values
     *         are: <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> |
     *         <code>ols</code> | <code>olap</code>.
     *         </p>
     *         </li>
     */
    public final List<ProductInformationFilter> productInformationFilterList() {
        return productInformationFilterList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductInformationFilterList() ? productInformationFilterList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductInformation)) {
            return false;
        }
        ProductInformation other = (ProductInformation) obj;
        return Objects.equals(resourceType(), other.resourceType())
                && hasProductInformationFilterList() == other.hasProductInformationFilterList()
                && Objects.equals(productInformationFilterList(), other.productInformationFilterList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductInformation").add("ResourceType", resourceType())
                .add("ProductInformationFilterList", hasProductInformationFilterList() ? productInformationFilterList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ProductInformationFilterList":
            return Optional.ofNullable(clazz.cast(productInformationFilterList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductInformation, T> g) {
        return obj -> g.apply((ProductInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductInformation> {
        /**
         * <p>
         * Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.
         * </p>
         * 
         * @param resourceType
         *        Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical
         * operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and
         * a <code>ProductInformationFilterValue</code> that specifies the value to filter on.
         * </p>
         * <p>
         * Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and
         * valid options for <code>ProductInformationFilterComparator</code>.
         * </p>
         * <p>
         * The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Publisher</code> - The publisher of the application. Logical operator is
         * <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from
         * automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag must be appended to
         * <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>.
         * <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated
         * discovery. Logical operator is <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
         * <code>NOT_EQUALS</code>. Possible values are: <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following filters and logical operators are supported when the resource type is <code>RDS</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Engine Edition</code> - The edition of the database engine. Logical operator is <code>EQUALS</code>.
         * Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> |
         * <code>oracle-se2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values are:
         * <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> |
         * <code>ols</code> | <code>olap</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param productInformationFilterList
         *        A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a
         *        logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being
         *        declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p>
         *        <p>
         *        Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions
         *        and valid options for <code>ProductInformationFilterComparator</code>.
         *        </p>
         *        <p>
         *        The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Publisher</code> - The publisher of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Version</code> - The version of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to
         *        exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag
         *        must be appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>.
         *        <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from
         *        automated discovery. Logical operator is <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>License Included</code> - The type of license included. Logical operators are
         *        <code>EQUALS</code> and <code>NOT_EQUALS</code>. Possible values are:
         *        <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> |
         *        <code>windows-server-datacenter</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following filters and logical operators are supported when the resource type is <code>RDS</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Engine Edition</code> - The edition of the database engine. Logical operator is
         *        <code>EQUALS</code>. Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> |
         *        <code>oracle-se1</code> | <code>oracle-se2</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values
         *        are: <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> |
         *        <code>ols</code> | <code>olap</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterList(Collection<ProductInformationFilter> productInformationFilterList);

        /**
         * <p>
         * A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical
         * operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and
         * a <code>ProductInformationFilterValue</code> that specifies the value to filter on.
         * </p>
         * <p>
         * Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and
         * valid options for <code>ProductInformationFilterComparator</code>.
         * </p>
         * <p>
         * The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Publisher</code> - The publisher of the application. Logical operator is
         * <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from
         * automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag must be appended to
         * <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>.
         * <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated
         * discovery. Logical operator is <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
         * <code>NOT_EQUALS</code>. Possible values are: <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following filters and logical operators are supported when the resource type is <code>RDS</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Engine Edition</code> - The edition of the database engine. Logical operator is <code>EQUALS</code>.
         * Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> |
         * <code>oracle-se2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values are:
         * <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> |
         * <code>ols</code> | <code>olap</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param productInformationFilterList
         *        A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a
         *        logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being
         *        declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p>
         *        <p>
         *        Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions
         *        and valid options for <code>ProductInformationFilterComparator</code>.
         *        </p>
         *        <p>
         *        The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Publisher</code> - The publisher of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Version</code> - The version of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to
         *        exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag
         *        must be appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>.
         *        <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from
         *        automated discovery. Logical operator is <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>License Included</code> - The type of license included. Logical operators are
         *        <code>EQUALS</code> and <code>NOT_EQUALS</code>. Possible values are:
         *        <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> |
         *        <code>windows-server-datacenter</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following filters and logical operators are supported when the resource type is <code>RDS</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Engine Edition</code> - The edition of the database engine. Logical operator is
         *        <code>EQUALS</code>. Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> |
         *        <code>oracle-se1</code> | <code>oracle-se2</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values
         *        are: <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> |
         *        <code>ols</code> | <code>olap</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterList(ProductInformationFilter... productInformationFilterList);

        /**
         * <p>
         * A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical
         * operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and
         * a <code>ProductInformationFilterValue</code> that specifies the value to filter on.
         * </p>
         * <p>
         * Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and
         * valid options for <code>ProductInformationFilterComparator</code>.
         * </p>
         * <p>
         * The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Publisher</code> - The publisher of the application. Logical operator is
         * <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from
         * automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag must be appended to
         * <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>.
         * <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated
         * discovery. Logical operator is <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
         * <code>NOT_EQUALS</code>. Possible values are: <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following filters and logical operators are supported when the resource type is <code>RDS</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Engine Edition</code> - The edition of the database engine. Logical operator is <code>EQUALS</code>.
         * Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> |
         * <code>oracle-se2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values are:
         * <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> |
         * <code>ols</code> | <code>olap</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link List<ProductInformationFilter>.Builder}
         * avoiding the need to create one manually via {@link List<ProductInformationFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductInformationFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #productInformationFilterList(List<ProductInformationFilter>)}
         * .
         * 
         * @param productInformationFilterList
         *        a consumer that will call methods on {@link List<ProductInformationFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productInformationFilterList(List<ProductInformationFilter>)
         */
        Builder productInformationFilterList(Consumer<ProductInformationFilter.Builder>... productInformationFilterList);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private List<ProductInformationFilter> productInformationFilterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProductInformation model) {
            resourceType(model.resourceType);
            productInformationFilterList(model.productInformationFilterList);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final List<ProductInformationFilter.Builder> getProductInformationFilterList() {
            List<ProductInformationFilter.Builder> result = ProductInformationFilterListCopier
                    .copyToBuilder(this.productInformationFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductInformationFilterList(
                Collection<ProductInformationFilter.BuilderImpl> productInformationFilterList) {
            this.productInformationFilterList = ProductInformationFilterListCopier.copyFromBuilder(productInformationFilterList);
        }

        @Override
        @Transient
        public final Builder productInformationFilterList(Collection<ProductInformationFilter> productInformationFilterList) {
            this.productInformationFilterList = ProductInformationFilterListCopier.copy(productInformationFilterList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productInformationFilterList(ProductInformationFilter... productInformationFilterList) {
            productInformationFilterList(Arrays.asList(productInformationFilterList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productInformationFilterList(
                Consumer<ProductInformationFilter.Builder>... productInformationFilterList) {
            productInformationFilterList(Stream.of(productInformationFilterList)
                    .map(c -> ProductInformationFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProductInformation build() {
            return new ProductInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
