/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describe the details of a report generator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportGenerator implements SdkPojo, Serializable, ToCopyableBuilder<ReportGenerator.Builder, ReportGenerator> {
    private static final SdkField<String> REPORT_GENERATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportGeneratorName").getter(getter(ReportGenerator::reportGeneratorName))
            .setter(setter(Builder::reportGeneratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGeneratorName").build())
            .build();

    private static final SdkField<List<String>> REPORT_TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReportType")
            .getter(getter(ReportGenerator::reportTypeAsStrings))
            .setter(setter(Builder::reportTypeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReportContext> REPORT_CONTEXT_FIELD = SdkField
            .<ReportContext> builder(MarshallingType.SDK_POJO).memberName("ReportContext")
            .getter(getter(ReportGenerator::reportContext)).setter(setter(Builder::reportContext))
            .constructor(ReportContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportContext").build()).build();

    private static final SdkField<ReportFrequency> REPORT_FREQUENCY_FIELD = SdkField
            .<ReportFrequency> builder(MarshallingType.SDK_POJO).memberName("ReportFrequency")
            .getter(getter(ReportGenerator::reportFrequency)).setter(setter(Builder::reportFrequency))
            .constructor(ReportFrequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportFrequency").build()).build();

    private static final SdkField<String> LICENSE_MANAGER_REPORT_GENERATOR_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LicenseManagerReportGeneratorArn")
            .getter(getter(ReportGenerator::licenseManagerReportGeneratorArn))
            .setter(setter(Builder::licenseManagerReportGeneratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseManagerReportGeneratorArn")
                    .build()).build();

    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRunStatus").getter(getter(ReportGenerator::lastRunStatus)).setter(setter(Builder::lastRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunStatus").build()).build();

    private static final SdkField<String> LAST_RUN_FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRunFailureReason").getter(getter(ReportGenerator::lastRunFailureReason))
            .setter(setter(Builder::lastRunFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunFailureReason").build())
            .build();

    private static final SdkField<String> LAST_REPORT_GENERATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastReportGenerationTime").getter(getter(ReportGenerator::lastReportGenerationTime))
            .setter(setter(Builder::lastReportGenerationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastReportGenerationTime").build())
            .build();

    private static final SdkField<String> REPORT_CREATOR_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportCreatorAccount").getter(getter(ReportGenerator::reportCreatorAccount))
            .setter(setter(Builder::reportCreatorAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportCreatorAccount").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ReportGenerator::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("S3Location").getter(getter(ReportGenerator::s3Location)).setter(setter(Builder::s3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location").build()).build();

    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateTime").getter(getter(ReportGenerator::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ReportGenerator::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GENERATOR_NAME_FIELD,
            REPORT_TYPE_FIELD, REPORT_CONTEXT_FIELD, REPORT_FREQUENCY_FIELD, LICENSE_MANAGER_REPORT_GENERATOR_ARN_FIELD,
            LAST_RUN_STATUS_FIELD, LAST_RUN_FAILURE_REASON_FIELD, LAST_REPORT_GENERATION_TIME_FIELD,
            REPORT_CREATOR_ACCOUNT_FIELD, DESCRIPTION_FIELD, S3_LOCATION_FIELD, CREATE_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportGeneratorName;

    private final List<String> reportType;

    private final ReportContext reportContext;

    private final ReportFrequency reportFrequency;

    private final String licenseManagerReportGeneratorArn;

    private final String lastRunStatus;

    private final String lastRunFailureReason;

    private final String lastReportGenerationTime;

    private final String reportCreatorAccount;

    private final String description;

    private final S3Location s3Location;

    private final String createTime;

    private final List<Tag> tags;

    private ReportGenerator(BuilderImpl builder) {
        this.reportGeneratorName = builder.reportGeneratorName;
        this.reportType = builder.reportType;
        this.reportContext = builder.reportContext;
        this.reportFrequency = builder.reportFrequency;
        this.licenseManagerReportGeneratorArn = builder.licenseManagerReportGeneratorArn;
        this.lastRunStatus = builder.lastRunStatus;
        this.lastRunFailureReason = builder.lastRunFailureReason;
        this.lastReportGenerationTime = builder.lastReportGenerationTime;
        this.reportCreatorAccount = builder.reportCreatorAccount;
        this.description = builder.description;
        this.s3Location = builder.s3Location;
        this.createTime = builder.createTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name of the report generator.
     * </p>
     * 
     * @return Name of the report generator.
     */
    public final String reportGeneratorName() {
        return reportGeneratorName;
    }

    /**
     * <p>
     * Type of reports that are generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReportType} method.
     * </p>
     * 
     * @return Type of reports that are generated.
     */
    public final List<ReportType> reportType() {
        return ReportTypeListCopier.copyStringToEnum(reportType);
    }

    /**
     * For responses, this returns true if the service returned a value for the ReportType property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReportType() {
        return reportType != null && !(reportType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Type of reports that are generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReportType} method.
     * </p>
     * 
     * @return Type of reports that are generated.
     */
    public final List<String> reportTypeAsStrings() {
        return reportType;
    }

    /**
     * <p>
     * License configuration type for this generator.
     * </p>
     * 
     * @return License configuration type for this generator.
     */
    public final ReportContext reportContext() {
        return reportContext;
    }

    /**
     * <p>
     * Details about how frequently reports are generated.
     * </p>
     * 
     * @return Details about how frequently reports are generated.
     */
    public final ReportFrequency reportFrequency() {
        return reportFrequency;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the report generator.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the report generator.
     */
    public final String licenseManagerReportGeneratorArn() {
        return licenseManagerReportGeneratorArn;
    }

    /**
     * <p>
     * Status of the last report generation attempt.
     * </p>
     * 
     * @return Status of the last report generation attempt.
     */
    public final String lastRunStatus() {
        return lastRunStatus;
    }

    /**
     * <p>
     * Failure message for the last report generation attempt.
     * </p>
     * 
     * @return Failure message for the last report generation attempt.
     */
    public final String lastRunFailureReason() {
        return lastRunFailureReason;
    }

    /**
     * <p>
     * Time the last report was generated at.
     * </p>
     * 
     * @return Time the last report was generated at.
     */
    public final String lastReportGenerationTime() {
        return lastReportGenerationTime;
    }

    /**
     * <p>
     * The Amazon Web Services account ID used to create the report generator.
     * </p>
     * 
     * @return The Amazon Web Services account ID used to create the report generator.
     */
    public final String reportCreatorAccount() {
        return reportCreatorAccount;
    }

    /**
     * <p>
     * Description of the report generator.
     * </p>
     * 
     * @return Description of the report generator.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Details of the S3 bucket that report generator reports are published to.
     * </p>
     * 
     * @return Details of the S3 bucket that report generator reports are published to.
     */
    public final S3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * Time the report was created.
     * </p>
     * 
     * @return Time the report was created.
     */
    public final String createTime() {
        return createTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags associated with the report generator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags associated with the report generator.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportGeneratorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasReportType() ? reportTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reportContext());
        hashCode = 31 * hashCode + Objects.hashCode(reportFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(licenseManagerReportGeneratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunFailureReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastReportGenerationTime());
        hashCode = 31 * hashCode + Objects.hashCode(reportCreatorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportGenerator)) {
            return false;
        }
        ReportGenerator other = (ReportGenerator) obj;
        return Objects.equals(reportGeneratorName(), other.reportGeneratorName()) && hasReportType() == other.hasReportType()
                && Objects.equals(reportTypeAsStrings(), other.reportTypeAsStrings())
                && Objects.equals(reportContext(), other.reportContext())
                && Objects.equals(reportFrequency(), other.reportFrequency())
                && Objects.equals(licenseManagerReportGeneratorArn(), other.licenseManagerReportGeneratorArn())
                && Objects.equals(lastRunStatus(), other.lastRunStatus())
                && Objects.equals(lastRunFailureReason(), other.lastRunFailureReason())
                && Objects.equals(lastReportGenerationTime(), other.lastReportGenerationTime())
                && Objects.equals(reportCreatorAccount(), other.reportCreatorAccount())
                && Objects.equals(description(), other.description()) && Objects.equals(s3Location(), other.s3Location())
                && Objects.equals(createTime(), other.createTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportGenerator").add("ReportGeneratorName", reportGeneratorName())
                .add("ReportType", hasReportType() ? reportTypeAsStrings() : null).add("ReportContext", reportContext())
                .add("ReportFrequency", reportFrequency())
                .add("LicenseManagerReportGeneratorArn", licenseManagerReportGeneratorArn())
                .add("LastRunStatus", lastRunStatus()).add("LastRunFailureReason", lastRunFailureReason())
                .add("LastReportGenerationTime", lastReportGenerationTime()).add("ReportCreatorAccount", reportCreatorAccount())
                .add("Description", description()).add("S3Location", s3Location()).add("CreateTime", createTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportGeneratorName":
            return Optional.ofNullable(clazz.cast(reportGeneratorName()));
        case "ReportType":
            return Optional.ofNullable(clazz.cast(reportTypeAsStrings()));
        case "ReportContext":
            return Optional.ofNullable(clazz.cast(reportContext()));
        case "ReportFrequency":
            return Optional.ofNullable(clazz.cast(reportFrequency()));
        case "LicenseManagerReportGeneratorArn":
            return Optional.ofNullable(clazz.cast(licenseManagerReportGeneratorArn()));
        case "LastRunStatus":
            return Optional.ofNullable(clazz.cast(lastRunStatus()));
        case "LastRunFailureReason":
            return Optional.ofNullable(clazz.cast(lastRunFailureReason()));
        case "LastReportGenerationTime":
            return Optional.ofNullable(clazz.cast(lastReportGenerationTime()));
        case "ReportCreatorAccount":
            return Optional.ofNullable(clazz.cast(reportCreatorAccount()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "S3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportGenerator, T> g) {
        return obj -> g.apply((ReportGenerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportGenerator> {
        /**
         * <p>
         * Name of the report generator.
         * </p>
         * 
         * @param reportGeneratorName
         *        Name of the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGeneratorName(String reportGeneratorName);

        /**
         * <p>
         * Type of reports that are generated.
         * </p>
         * 
         * @param reportType
         *        Type of reports that are generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportTypeWithStrings(Collection<String> reportType);

        /**
         * <p>
         * Type of reports that are generated.
         * </p>
         * 
         * @param reportType
         *        Type of reports that are generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportTypeWithStrings(String... reportType);

        /**
         * <p>
         * Type of reports that are generated.
         * </p>
         * 
         * @param reportType
         *        Type of reports that are generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportType(Collection<ReportType> reportType);

        /**
         * <p>
         * Type of reports that are generated.
         * </p>
         * 
         * @param reportType
         *        Type of reports that are generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportType(ReportType... reportType);

        /**
         * <p>
         * License configuration type for this generator.
         * </p>
         * 
         * @param reportContext
         *        License configuration type for this generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportContext(ReportContext reportContext);

        /**
         * <p>
         * License configuration type for this generator.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportContext.Builder} avoiding the need
         * to create one manually via {@link ReportContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportContext.Builder#build()} is called immediately and its
         * result is passed to {@link #reportContext(ReportContext)}.
         * 
         * @param reportContext
         *        a consumer that will call methods on {@link ReportContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportContext(ReportContext)
         */
        default Builder reportContext(Consumer<ReportContext.Builder> reportContext) {
            return reportContext(ReportContext.builder().applyMutation(reportContext).build());
        }

        /**
         * <p>
         * Details about how frequently reports are generated.
         * </p>
         * 
         * @param reportFrequency
         *        Details about how frequently reports are generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportFrequency(ReportFrequency reportFrequency);

        /**
         * <p>
         * Details about how frequently reports are generated.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportFrequency.Builder} avoiding the
         * need to create one manually via {@link ReportFrequency#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportFrequency.Builder#build()} is called immediately and its
         * result is passed to {@link #reportFrequency(ReportFrequency)}.
         * 
         * @param reportFrequency
         *        a consumer that will call methods on {@link ReportFrequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportFrequency(ReportFrequency)
         */
        default Builder reportFrequency(Consumer<ReportFrequency.Builder> reportFrequency) {
            return reportFrequency(ReportFrequency.builder().applyMutation(reportFrequency).build());
        }

        /**
         * <p>
         * Amazon Resource Name (ARN) of the report generator.
         * </p>
         * 
         * @param licenseManagerReportGeneratorArn
         *        Amazon Resource Name (ARN) of the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn);

        /**
         * <p>
         * Status of the last report generation attempt.
         * </p>
         * 
         * @param lastRunStatus
         *        Status of the last report generation attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunStatus(String lastRunStatus);

        /**
         * <p>
         * Failure message for the last report generation attempt.
         * </p>
         * 
         * @param lastRunFailureReason
         *        Failure message for the last report generation attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunFailureReason(String lastRunFailureReason);

        /**
         * <p>
         * Time the last report was generated at.
         * </p>
         * 
         * @param lastReportGenerationTime
         *        Time the last report was generated at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastReportGenerationTime(String lastReportGenerationTime);

        /**
         * <p>
         * The Amazon Web Services account ID used to create the report generator.
         * </p>
         * 
         * @param reportCreatorAccount
         *        The Amazon Web Services account ID used to create the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportCreatorAccount(String reportCreatorAccount);

        /**
         * <p>
         * Description of the report generator.
         * </p>
         * 
         * @param description
         *        Description of the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Details of the S3 bucket that report generator reports are published to.
         * </p>
         * 
         * @param s3Location
         *        Details of the S3 bucket that report generator reports are published to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3Location s3Location);

        /**
         * <p>
         * Details of the S3 bucket that report generator reports are published to.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Location(S3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(S3Location)
         */
        default Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return s3Location(S3Location.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * Time the report was created.
         * </p>
         * 
         * @param createTime
         *        Time the report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(String createTime);

        /**
         * <p>
         * Tags associated with the report generator.
         * </p>
         * 
         * @param tags
         *        Tags associated with the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags associated with the report generator.
         * </p>
         * 
         * @param tags
         *        Tags associated with the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags associated with the report generator.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String reportGeneratorName;

        private List<String> reportType = DefaultSdkAutoConstructList.getInstance();

        private ReportContext reportContext;

        private ReportFrequency reportFrequency;

        private String licenseManagerReportGeneratorArn;

        private String lastRunStatus;

        private String lastRunFailureReason;

        private String lastReportGenerationTime;

        private String reportCreatorAccount;

        private String description;

        private S3Location s3Location;

        private String createTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportGenerator model) {
            reportGeneratorName(model.reportGeneratorName);
            reportTypeWithStrings(model.reportType);
            reportContext(model.reportContext);
            reportFrequency(model.reportFrequency);
            licenseManagerReportGeneratorArn(model.licenseManagerReportGeneratorArn);
            lastRunStatus(model.lastRunStatus);
            lastRunFailureReason(model.lastRunFailureReason);
            lastReportGenerationTime(model.lastReportGenerationTime);
            reportCreatorAccount(model.reportCreatorAccount);
            description(model.description);
            s3Location(model.s3Location);
            createTime(model.createTime);
            tags(model.tags);
        }

        public final String getReportGeneratorName() {
            return reportGeneratorName;
        }

        public final void setReportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
        }

        @Override
        @Transient
        public final Builder reportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
            return this;
        }

        public final Collection<String> getReportType() {
            if (reportType instanceof SdkAutoConstructList) {
                return null;
            }
            return reportType;
        }

        public final void setReportType(Collection<String> reportType) {
            this.reportType = ReportTypeListCopier.copy(reportType);
        }

        @Override
        @Transient
        public final Builder reportTypeWithStrings(Collection<String> reportType) {
            this.reportType = ReportTypeListCopier.copy(reportType);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reportTypeWithStrings(String... reportType) {
            reportTypeWithStrings(Arrays.asList(reportType));
            return this;
        }

        @Override
        @Transient
        public final Builder reportType(Collection<ReportType> reportType) {
            this.reportType = ReportTypeListCopier.copyEnumToString(reportType);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reportType(ReportType... reportType) {
            reportType(Arrays.asList(reportType));
            return this;
        }

        public final ReportContext.Builder getReportContext() {
            return reportContext != null ? reportContext.toBuilder() : null;
        }

        public final void setReportContext(ReportContext.BuilderImpl reportContext) {
            this.reportContext = reportContext != null ? reportContext.build() : null;
        }

        @Override
        @Transient
        public final Builder reportContext(ReportContext reportContext) {
            this.reportContext = reportContext;
            return this;
        }

        public final ReportFrequency.Builder getReportFrequency() {
            return reportFrequency != null ? reportFrequency.toBuilder() : null;
        }

        public final void setReportFrequency(ReportFrequency.BuilderImpl reportFrequency) {
            this.reportFrequency = reportFrequency != null ? reportFrequency.build() : null;
        }

        @Override
        @Transient
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        public final String getLicenseManagerReportGeneratorArn() {
            return licenseManagerReportGeneratorArn;
        }

        public final void setLicenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
            this.licenseManagerReportGeneratorArn = licenseManagerReportGeneratorArn;
        }

        @Override
        @Transient
        public final Builder licenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
            this.licenseManagerReportGeneratorArn = licenseManagerReportGeneratorArn;
            return this;
        }

        public final String getLastRunStatus() {
            return lastRunStatus;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        @Override
        @Transient
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        public final String getLastRunFailureReason() {
            return lastRunFailureReason;
        }

        public final void setLastRunFailureReason(String lastRunFailureReason) {
            this.lastRunFailureReason = lastRunFailureReason;
        }

        @Override
        @Transient
        public final Builder lastRunFailureReason(String lastRunFailureReason) {
            this.lastRunFailureReason = lastRunFailureReason;
            return this;
        }

        public final String getLastReportGenerationTime() {
            return lastReportGenerationTime;
        }

        public final void setLastReportGenerationTime(String lastReportGenerationTime) {
            this.lastReportGenerationTime = lastReportGenerationTime;
        }

        @Override
        @Transient
        public final Builder lastReportGenerationTime(String lastReportGenerationTime) {
            this.lastReportGenerationTime = lastReportGenerationTime;
            return this;
        }

        public final String getReportCreatorAccount() {
            return reportCreatorAccount;
        }

        public final void setReportCreatorAccount(String reportCreatorAccount) {
            this.reportCreatorAccount = reportCreatorAccount;
        }

        @Override
        @Transient
        public final Builder reportCreatorAccount(String reportCreatorAccount) {
            this.reportCreatorAccount = reportCreatorAccount;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final S3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReportGenerator build() {
            return new ReportGenerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
