/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLicenseVersionRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateLicenseVersionRequest.Builder, CreateLicenseVersionRequest> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(CreateLicenseVersionRequest::licenseArn)).setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseName").getter(getter(CreateLicenseVersionRequest::licenseName))
            .setter(setter(Builder::licenseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseName").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(CreateLicenseVersionRequest::productName))
            .setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<Issuer> ISSUER_FIELD = SdkField.<Issuer> builder(MarshallingType.SDK_POJO).memberName("Issuer")
            .getter(getter(CreateLicenseVersionRequest::issuer)).setter(setter(Builder::issuer)).constructor(Issuer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(CreateLicenseVersionRequest::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<DatetimeRange> VALIDITY_FIELD = SdkField.<DatetimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("Validity").getter(getter(CreateLicenseVersionRequest::validity)).setter(setter(Builder::validity))
            .constructor(DatetimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()).build();

    private static final SdkField<List<Metadata>> LICENSE_METADATA_FIELD = SdkField
            .<List<Metadata>> builder(MarshallingType.LIST)
            .memberName("LicenseMetadata")
            .getter(getter(CreateLicenseVersionRequest::licenseMetadata))
            .setter(setter(Builder::licenseMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<Entitlement>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(CreateLicenseVersionRequest::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConsumptionConfiguration> CONSUMPTION_CONFIGURATION_FIELD = SdkField
            .<ConsumptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConsumptionConfiguration")
            .getter(getter(CreateLicenseVersionRequest::consumptionConfiguration))
            .setter(setter(Builder::consumptionConfiguration)).constructor(ConsumptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumptionConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateLicenseVersionRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateLicenseVersionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceVersion").getter(getter(CreateLicenseVersionRequest::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD,
            LICENSE_NAME_FIELD, PRODUCT_NAME_FIELD, ISSUER_FIELD, HOME_REGION_FIELD, VALIDITY_FIELD, LICENSE_METADATA_FIELD,
            ENTITLEMENTS_FIELD, CONSUMPTION_CONFIGURATION_FIELD, STATUS_FIELD, CLIENT_TOKEN_FIELD, SOURCE_VERSION_FIELD));

    private final String licenseArn;

    private final String licenseName;

    private final String productName;

    private final Issuer issuer;

    private final String homeRegion;

    private final DatetimeRange validity;

    private final List<Metadata> licenseMetadata;

    private final List<Entitlement> entitlements;

    private final ConsumptionConfiguration consumptionConfiguration;

    private final String status;

    private final String clientToken;

    private final String sourceVersion;

    private CreateLicenseVersionRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.licenseName = builder.licenseName;
        this.productName = builder.productName;
        this.issuer = builder.issuer;
        this.homeRegion = builder.homeRegion;
        this.validity = builder.validity;
        this.licenseMetadata = builder.licenseMetadata;
        this.entitlements = builder.entitlements;
        this.consumptionConfiguration = builder.consumptionConfiguration;
        this.status = builder.status;
        this.clientToken = builder.clientToken;
        this.sourceVersion = builder.sourceVersion;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license.
     */
    public final String licenseArn() {
        return licenseArn;
    }

    /**
     * <p>
     * License name.
     * </p>
     * 
     * @return License name.
     */
    public final String licenseName() {
        return licenseName;
    }

    /**
     * <p>
     * Product name.
     * </p>
     * 
     * @return Product name.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * License issuer.
     * </p>
     * 
     * @return License issuer.
     */
    public final Issuer issuer() {
        return issuer;
    }

    /**
     * <p>
     * Home Region of the license.
     * </p>
     * 
     * @return Home Region of the license.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * Date and time range during which the license is valid, in ISO8601-UTC format.
     * </p>
     * 
     * @return Date and time range during which the license is valid, in ISO8601-UTC format.
     */
    public final DatetimeRange validity() {
        return validity;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLicenseMetadata() {
        return licenseMetadata != null && !(licenseMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the license.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseMetadata} method.
     * </p>
     * 
     * @return Information about the license.
     */
    public final List<Metadata> licenseMetadata() {
        return licenseMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entitlements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License entitlements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitlements} method.
     * </p>
     * 
     * @return License entitlements.
     */
    public final List<Entitlement> entitlements() {
        return entitlements;
    }

    /**
     * <p>
     * Configuration for consumption of the license. Choose a provisional configuration for workloads running with
     * continuous connectivity. Choose a borrow configuration for workloads with offline usage.
     * </p>
     * 
     * @return Configuration for consumption of the license. Choose a provisional configuration for workloads running
     *         with continuous connectivity. Choose a borrow configuration for workloads with offline usage.
     */
    public final ConsumptionConfiguration consumptionConfiguration() {
        return consumptionConfiguration;
    }

    /**
     * <p>
     * License status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return License status.
     * @see LicenseStatus
     */
    public final LicenseStatus status() {
        return LicenseStatus.fromValue(status);
    }

    /**
     * <p>
     * License status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return License status.
     * @see LicenseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Current version of the license.
     * </p>
     * 
     * @return Current version of the license.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseName());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseMetadata() ? licenseMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consumptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseVersionRequest)) {
            return false;
        }
        CreateLicenseVersionRequest other = (CreateLicenseVersionRequest) obj;
        return Objects.equals(licenseArn(), other.licenseArn()) && Objects.equals(licenseName(), other.licenseName())
                && Objects.equals(productName(), other.productName()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(homeRegion(), other.homeRegion()) && Objects.equals(validity(), other.validity())
                && hasLicenseMetadata() == other.hasLicenseMetadata()
                && Objects.equals(licenseMetadata(), other.licenseMetadata()) && hasEntitlements() == other.hasEntitlements()
                && Objects.equals(entitlements(), other.entitlements())
                && Objects.equals(consumptionConfiguration(), other.consumptionConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(sourceVersion(), other.sourceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLicenseVersionRequest").add("LicenseArn", licenseArn()).add("LicenseName", licenseName())
                .add("ProductName", productName()).add("Issuer", issuer()).add("HomeRegion", homeRegion())
                .add("Validity", validity()).add("LicenseMetadata", hasLicenseMetadata() ? licenseMetadata() : null)
                .add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("ConsumptionConfiguration", consumptionConfiguration()).add("Status", statusAsString())
                .add("ClientToken", clientToken()).add("SourceVersion", sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "LicenseName":
            return Optional.ofNullable(clazz.cast(licenseName()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "Validity":
            return Optional.ofNullable(clazz.cast(validity()));
        case "LicenseMetadata":
            return Optional.ofNullable(clazz.cast(licenseMetadata()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "ConsumptionConfiguration":
            return Optional.ofNullable(clazz.cast(consumptionConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseVersionRequest, T> g) {
        return obj -> g.apply((CreateLicenseVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLicenseVersionRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * License name.
         * </p>
         * 
         * @param licenseName
         *        License name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseName(String licenseName);

        /**
         * <p>
         * Product name.
         * </p>
         * 
         * @param productName
         *        Product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * License issuer.
         * </p>
         * 
         * @param issuer
         *        License issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(Issuer issuer);

        /**
         * <p>
         * License issuer.
         * </p>
         * This is a convenience method that creates an instance of the {@link Issuer.Builder} avoiding the need to
         * create one manually via {@link Issuer#builder()}.
         *
         * When the {@link Consumer} completes, {@link Issuer.Builder#build()} is called immediately and its result is
         * passed to {@link #issuer(Issuer)}.
         * 
         * @param issuer
         *        a consumer that will call methods on {@link Issuer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuer(Issuer)
         */
        default Builder issuer(Consumer<Issuer.Builder> issuer) {
            return issuer(Issuer.builder().applyMutation(issuer).build());
        }

        /**
         * <p>
         * Home Region of the license.
         * </p>
         * 
         * @param homeRegion
         *        Home Region of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * Date and time range during which the license is valid, in ISO8601-UTC format.
         * </p>
         * 
         * @param validity
         *        Date and time range during which the license is valid, in ISO8601-UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(DatetimeRange validity);

        /**
         * <p>
         * Date and time range during which the license is valid, in ISO8601-UTC format.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatetimeRange.Builder} avoiding the need
         * to create one manually via {@link DatetimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatetimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #validity(DatetimeRange)}.
         * 
         * @param validity
         *        a consumer that will call methods on {@link DatetimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validity(DatetimeRange)
         */
        default Builder validity(Consumer<DatetimeRange.Builder> validity) {
            return validity(DatetimeRange.builder().applyMutation(validity).build());
        }

        /**
         * <p>
         * Information about the license.
         * </p>
         * 
         * @param licenseMetadata
         *        Information about the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseMetadata(Collection<Metadata> licenseMetadata);

        /**
         * <p>
         * Information about the license.
         * </p>
         * 
         * @param licenseMetadata
         *        Information about the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseMetadata(Metadata... licenseMetadata);

        /**
         * <p>
         * Information about the license.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Metadata>.Builder} avoiding the need
         * to create one manually via {@link List<Metadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #licenseMetadata(List<Metadata>)}.
         * 
         * @param licenseMetadata
         *        a consumer that will call methods on {@link List<Metadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseMetadata(List<Metadata>)
         */
        Builder licenseMetadata(Consumer<Metadata.Builder>... licenseMetadata);

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<Entitlement> entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Entitlement... entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Entitlement>.Builder} avoiding the
         * need to create one manually via {@link List<Entitlement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entitlement>.Builder#build()} is called immediately and its
         * result is passed to {@link #entitlements(List<Entitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<Entitlement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<Entitlement>)
         */
        Builder entitlements(Consumer<Entitlement.Builder>... entitlements);

        /**
         * <p>
         * Configuration for consumption of the license. Choose a provisional configuration for workloads running with
         * continuous connectivity. Choose a borrow configuration for workloads with offline usage.
         * </p>
         * 
         * @param consumptionConfiguration
         *        Configuration for consumption of the license. Choose a provisional configuration for workloads running
         *        with continuous connectivity. Choose a borrow configuration for workloads with offline usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration);

        /**
         * <p>
         * Configuration for consumption of the license. Choose a provisional configuration for workloads running with
         * continuous connectivity. Choose a borrow configuration for workloads with offline usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link ConsumptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConsumptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #consumptionConfiguration(ConsumptionConfiguration)}.
         * 
         * @param consumptionConfiguration
         *        a consumer that will call methods on {@link ConsumptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumptionConfiguration(ConsumptionConfiguration)
         */
        default Builder consumptionConfiguration(Consumer<ConsumptionConfiguration.Builder> consumptionConfiguration) {
            return consumptionConfiguration(ConsumptionConfiguration.builder().applyMutation(consumptionConfiguration).build());
        }

        /**
         * <p>
         * License status.
         * </p>
         * 
         * @param status
         *        License status.
         * @see LicenseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * License status.
         * </p>
         * 
         * @param status
         *        License status.
         * @see LicenseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseStatus
         */
        Builder status(LicenseStatus status);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Current version of the license.
         * </p>
         * 
         * @param sourceVersion
         *        Current version of the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseArn;

        private String licenseName;

        private String productName;

        private Issuer issuer;

        private String homeRegion;

        private DatetimeRange validity;

        private List<Metadata> licenseMetadata = DefaultSdkAutoConstructList.getInstance();

        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private ConsumptionConfiguration consumptionConfiguration;

        private String status;

        private String clientToken;

        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseVersionRequest model) {
            super(model);
            licenseArn(model.licenseArn);
            licenseName(model.licenseName);
            productName(model.productName);
            issuer(model.issuer);
            homeRegion(model.homeRegion);
            validity(model.validity);
            licenseMetadata(model.licenseMetadata);
            entitlements(model.entitlements);
            consumptionConfiguration(model.consumptionConfiguration);
            status(model.status);
            clientToken(model.clientToken);
            sourceVersion(model.sourceVersion);
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getLicenseName() {
            return licenseName;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        @Override
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final Issuer.Builder getIssuer() {
            return issuer != null ? issuer.toBuilder() : null;
        }

        public final void setIssuer(Issuer.BuilderImpl issuer) {
            this.issuer = issuer != null ? issuer.build() : null;
        }

        @Override
        public final Builder issuer(Issuer issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final DatetimeRange.Builder getValidity() {
            return validity != null ? validity.toBuilder() : null;
        }

        public final void setValidity(DatetimeRange.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        @Override
        public final Builder validity(DatetimeRange validity) {
            this.validity = validity;
            return this;
        }

        public final List<Metadata.Builder> getLicenseMetadata() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.licenseMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseMetadata(Collection<Metadata.BuilderImpl> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copyFromBuilder(licenseMetadata);
        }

        @Override
        public final Builder licenseMetadata(Collection<Metadata> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copy(licenseMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Metadata... licenseMetadata) {
            licenseMetadata(Arrays.asList(licenseMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Consumer<Metadata.Builder>... licenseMetadata) {
            licenseMetadata(Stream.of(licenseMetadata).map(c -> Metadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = EntitlementListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = EntitlementListCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = EntitlementListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> Entitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ConsumptionConfiguration.Builder getConsumptionConfiguration() {
            return consumptionConfiguration != null ? consumptionConfiguration.toBuilder() : null;
        }

        public final void setConsumptionConfiguration(ConsumptionConfiguration.BuilderImpl consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration != null ? consumptionConfiguration.build() : null;
        }

        @Override
        public final Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseVersionRequest build() {
            return new CreateLicenseVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
