/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLicenseManagerReportGeneratorResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<GetLicenseManagerReportGeneratorResponse.Builder, GetLicenseManagerReportGeneratorResponse> {
    private static final SdkField<ReportGenerator> REPORT_GENERATOR_FIELD = SdkField
            .<ReportGenerator> builder(MarshallingType.SDK_POJO).memberName("ReportGenerator")
            .getter(getter(GetLicenseManagerReportGeneratorResponse::reportGenerator)).setter(setter(Builder::reportGenerator))
            .constructor(ReportGenerator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGenerator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GENERATOR_FIELD));

    private final ReportGenerator reportGenerator;

    private GetLicenseManagerReportGeneratorResponse(BuilderImpl builder) {
        super(builder);
        this.reportGenerator = builder.reportGenerator;
    }

    /**
     * <p>
     * A report generator that creates periodic reports about your license configurations.
     * </p>
     * 
     * @return A report generator that creates periodic reports about your license configurations.
     */
    public final ReportGenerator reportGenerator() {
        return reportGenerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportGenerator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseManagerReportGeneratorResponse)) {
            return false;
        }
        GetLicenseManagerReportGeneratorResponse other = (GetLicenseManagerReportGeneratorResponse) obj;
        return Objects.equals(reportGenerator(), other.reportGenerator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLicenseManagerReportGeneratorResponse").add("ReportGenerator", reportGenerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportGenerator":
            return Optional.ofNullable(clazz.cast(reportGenerator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseManagerReportGeneratorResponse, T> g) {
        return obj -> g.apply((GetLicenseManagerReportGeneratorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLicenseManagerReportGeneratorResponse> {
        /**
         * <p>
         * A report generator that creates periodic reports about your license configurations.
         * </p>
         * 
         * @param reportGenerator
         *        A report generator that creates periodic reports about your license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGenerator(ReportGenerator reportGenerator);

        /**
         * <p>
         * A report generator that creates periodic reports about your license configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportGenerator.Builder} avoiding the
         * need to create one manually via {@link ReportGenerator#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportGenerator.Builder#build()} is called immediately and its
         * result is passed to {@link #reportGenerator(ReportGenerator)}.
         * 
         * @param reportGenerator
         *        a consumer that will call methods on {@link ReportGenerator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportGenerator(ReportGenerator)
         */
        default Builder reportGenerator(Consumer<ReportGenerator.Builder> reportGenerator) {
            return reportGenerator(ReportGenerator.builder().applyMutation(reportGenerator).build());
        }
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private ReportGenerator reportGenerator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseManagerReportGeneratorResponse model) {
            super(model);
            reportGenerator(model.reportGenerator);
        }

        public final ReportGenerator.Builder getReportGenerator() {
            return reportGenerator != null ? reportGenerator.toBuilder() : null;
        }

        public final void setReportGenerator(ReportGenerator.BuilderImpl reportGenerator) {
            this.reportGenerator = reportGenerator != null ? reportGenerator.build() : null;
        }

        @Override
        public final Builder reportGenerator(ReportGenerator reportGenerator) {
            this.reportGenerator = reportGenerator;
            return this;
        }

        @Override
        public GetLicenseManagerReportGeneratorResponse build() {
            return new GetLicenseManagerReportGeneratorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
