/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration;
import software.amazon.awssdk.services.licensemanager.model.DatetimeRange;
import software.amazon.awssdk.services.licensemanager.model.Entitlement;
import software.amazon.awssdk.services.licensemanager.model.EntitlementListCopier;
import software.amazon.awssdk.services.licensemanager.model.Issuer;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.LicenseStatus;
import software.amazon.awssdk.services.licensemanager.model.Metadata;
import software.amazon.awssdk.services.licensemanager.model.MetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseVersionRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateLicenseVersionRequest> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::licenseArn)).setter(CreateLicenseVersionRequest.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseName").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::licenseName)).setter(CreateLicenseVersionRequest.setter(Builder::licenseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseName").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::productName)).setter(CreateLicenseVersionRequest.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<Issuer> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Issuer").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::issuer)).setter(CreateLicenseVersionRequest.setter(Builder::issuer)).constructor(Issuer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::homeRegion)).setter(CreateLicenseVersionRequest.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<DatetimeRange> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Validity").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::validity)).setter(CreateLicenseVersionRequest.setter(Builder::validity)).constructor(DatetimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()}).build();
    private static final SdkField<List<Metadata>> LICENSE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseMetadata").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::licenseMetadata)).setter(CreateLicenseVersionRequest.setter(Builder::licenseMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::entitlements)).setter(CreateLicenseVersionRequest.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entitlement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConsumptionConfiguration> CONSUMPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumptionConfiguration").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::consumptionConfiguration)).setter(CreateLicenseVersionRequest.setter(Builder::consumptionConfiguration)).constructor(ConsumptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumptionConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::statusAsString)).setter(CreateLicenseVersionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::clientToken)).setter(CreateLicenseVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceVersion").getter(CreateLicenseVersionRequest.getter(CreateLicenseVersionRequest::sourceVersion)).setter(CreateLicenseVersionRequest.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD, LICENSE_NAME_FIELD, PRODUCT_NAME_FIELD, ISSUER_FIELD, HOME_REGION_FIELD, VALIDITY_FIELD, LICENSE_METADATA_FIELD, ENTITLEMENTS_FIELD, CONSUMPTION_CONFIGURATION_FIELD, STATUS_FIELD, CLIENT_TOKEN_FIELD, SOURCE_VERSION_FIELD));
    private final String licenseArn;
    private final String licenseName;
    private final String productName;
    private final Issuer issuer;
    private final String homeRegion;
    private final DatetimeRange validity;
    private final List<Metadata> licenseMetadata;
    private final List<Entitlement> entitlements;
    private final ConsumptionConfiguration consumptionConfiguration;
    private final String status;
    private final String clientToken;
    private final String sourceVersion;

    private CreateLicenseVersionRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.licenseName = builder.licenseName;
        this.productName = builder.productName;
        this.issuer = builder.issuer;
        this.homeRegion = builder.homeRegion;
        this.validity = builder.validity;
        this.licenseMetadata = builder.licenseMetadata;
        this.entitlements = builder.entitlements;
        this.consumptionConfiguration = builder.consumptionConfiguration;
        this.status = builder.status;
        this.clientToken = builder.clientToken;
        this.sourceVersion = builder.sourceVersion;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final String licenseName() {
        return this.licenseName;
    }

    public final String productName() {
        return this.productName;
    }

    public final Issuer issuer() {
        return this.issuer;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final DatetimeRange validity() {
        return this.validity;
    }

    public final boolean hasLicenseMetadata() {
        return this.licenseMetadata != null && !(this.licenseMetadata instanceof SdkAutoConstructList);
    }

    public final List<Metadata> licenseMetadata() {
        return this.licenseMetadata;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<Entitlement> entitlements() {
        return this.entitlements;
    }

    public final ConsumptionConfiguration consumptionConfiguration() {
        return this.consumptionConfiguration;
    }

    public final LicenseStatus status() {
        return LicenseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseMetadata() ? this.licenseMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consumptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseVersionRequest)) {
            return false;
        }
        CreateLicenseVersionRequest other = (CreateLicenseVersionRequest)((Object)obj);
        return Objects.equals(this.licenseArn(), other.licenseArn()) && Objects.equals(this.licenseName(), other.licenseName()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.validity(), other.validity()) && this.hasLicenseMetadata() == other.hasLicenseMetadata() && Objects.equals(this.licenseMetadata(), other.licenseMetadata()) && this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.consumptionConfiguration(), other.consumptionConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sourceVersion(), other.sourceVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseVersionRequest").add("LicenseArn", (Object)this.licenseArn()).add("LicenseName", (Object)this.licenseName()).add("ProductName", (Object)this.productName()).add("Issuer", (Object)this.issuer()).add("HomeRegion", (Object)this.homeRegion()).add("Validity", (Object)this.validity()).add("LicenseMetadata", this.hasLicenseMetadata() ? this.licenseMetadata() : null).add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("ConsumptionConfiguration", (Object)this.consumptionConfiguration()).add("Status", (Object)this.statusAsString()).add("ClientToken", (Object)this.clientToken()).add("SourceVersion", (Object)this.sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "LicenseName": {
                return Optional.ofNullable(clazz.cast(this.licenseName()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "Validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
            case "LicenseMetadata": {
                return Optional.ofNullable(clazz.cast(this.licenseMetadata()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "ConsumptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.consumptionConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseVersionRequest, T> g) {
        return obj -> g.apply((CreateLicenseVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseArn;
        private String licenseName;
        private String productName;
        private Issuer issuer;
        private String homeRegion;
        private DatetimeRange validity;
        private List<Metadata> licenseMetadata = DefaultSdkAutoConstructList.getInstance();
        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();
        private ConsumptionConfiguration consumptionConfiguration;
        private String status;
        private String clientToken;
        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseVersionRequest model) {
            super(model);
            this.licenseArn(model.licenseArn);
            this.licenseName(model.licenseName);
            this.productName(model.productName);
            this.issuer(model.issuer);
            this.homeRegion(model.homeRegion);
            this.validity(model.validity);
            this.licenseMetadata(model.licenseMetadata);
            this.entitlements(model.entitlements);
            this.consumptionConfiguration(model.consumptionConfiguration);
            this.status(model.status);
            this.clientToken(model.clientToken);
            this.sourceVersion(model.sourceVersion);
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getLicenseName() {
            return this.licenseName;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        @Override
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final Issuer.Builder getIssuer() {
            return this.issuer != null ? this.issuer.toBuilder() : null;
        }

        public final void setIssuer(Issuer.BuilderImpl issuer) {
            this.issuer = issuer != null ? issuer.build() : null;
        }

        @Override
        public final Builder issuer(Issuer issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final DatetimeRange.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        public final void setValidity(DatetimeRange.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        @Override
        public final Builder validity(DatetimeRange validity) {
            this.validity = validity;
            return this;
        }

        public final List<Metadata.Builder> getLicenseMetadata() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.licenseMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseMetadata(Collection<Metadata.BuilderImpl> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copyFromBuilder(licenseMetadata);
        }

        @Override
        public final Builder licenseMetadata(Collection<Metadata> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copy(licenseMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Metadata ... licenseMetadata) {
            this.licenseMetadata(Arrays.asList(licenseMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Consumer<Metadata.Builder> ... licenseMetadata) {
            this.licenseMetadata(Stream.of(licenseMetadata).map(c -> (Metadata)((Metadata.Builder)Metadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = EntitlementListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = EntitlementListCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = EntitlementListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (Entitlement)((Entitlement.Builder)Entitlement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConsumptionConfiguration.Builder getConsumptionConfiguration() {
            return this.consumptionConfiguration != null ? this.consumptionConfiguration.toBuilder() : null;
        }

        public final void setConsumptionConfiguration(ConsumptionConfiguration.BuilderImpl consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration != null ? consumptionConfiguration.build() : null;
        }

        @Override
        public final Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseVersionRequest build() {
            return new CreateLicenseVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseVersionRequest> {
        public Builder licenseArn(String var1);

        public Builder licenseName(String var1);

        public Builder productName(String var1);

        public Builder issuer(Issuer var1);

        default public Builder issuer(Consumer<Issuer.Builder> issuer) {
            return this.issuer((Issuer)((Issuer.Builder)Issuer.builder().applyMutation(issuer)).build());
        }

        public Builder homeRegion(String var1);

        public Builder validity(DatetimeRange var1);

        default public Builder validity(Consumer<DatetimeRange.Builder> validity) {
            return this.validity((DatetimeRange)((DatetimeRange.Builder)DatetimeRange.builder().applyMutation(validity)).build());
        }

        public Builder licenseMetadata(Collection<Metadata> var1);

        public Builder licenseMetadata(Metadata ... var1);

        public Builder licenseMetadata(Consumer<Metadata.Builder> ... var1);

        public Builder entitlements(Collection<Entitlement> var1);

        public Builder entitlements(Entitlement ... var1);

        public Builder entitlements(Consumer<Entitlement.Builder> ... var1);

        public Builder consumptionConfiguration(ConsumptionConfiguration var1);

        default public Builder consumptionConfiguration(Consumer<ConsumptionConfiguration.Builder> consumptionConfiguration) {
            return this.consumptionConfiguration((ConsumptionConfiguration)((ConsumptionConfiguration.Builder)ConsumptionConfiguration.builder().applyMutation(consumptionConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(LicenseStatus var1);

        public Builder clientToken(String var1);

        public Builder sourceVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

