/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about how frequently reports are generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportFrequency implements SdkPojo, Serializable, ToCopyableBuilder<ReportFrequency.Builder, ReportFrequency> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("value")
            .getter(getter(ReportFrequency::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("period")
            .getter(getter(ReportFrequency::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer value;

    private final String period;

    private ReportFrequency(BuilderImpl builder) {
        this.value = builder.value;
        this.period = builder.period;
    }

    /**
     * <p>
     * Number of times within the frequency period that a report is generated. The only supported value is
     * <code>1</code>.
     * </p>
     * 
     * @return Number of times within the frequency period that a report is generated. The only supported value is
     *         <code>1</code>.
     */
    public final Integer value() {
        return value;
    }

    /**
     * <p>
     * Time period between each report. The period can be daily, weekly, or monthly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link ReportFrequencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAsString}.
     * </p>
     * 
     * @return Time period between each report. The period can be daily, weekly, or monthly.
     * @see ReportFrequencyType
     */
    public final ReportFrequencyType period() {
        return ReportFrequencyType.fromValue(period);
    }

    /**
     * <p>
     * Time period between each report. The period can be daily, weekly, or monthly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link ReportFrequencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAsString}.
     * </p>
     * 
     * @return Time period between each report. The period can be daily, weekly, or monthly.
     * @see ReportFrequencyType
     */
    public final String periodAsString() {
        return period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportFrequency)) {
            return false;
        }
        ReportFrequency other = (ReportFrequency) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(periodAsString(), other.periodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportFrequency").add("Value", value()).add("Period", periodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportFrequency, T> g) {
        return obj -> g.apply((ReportFrequency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportFrequency> {
        /**
         * <p>
         * Number of times within the frequency period that a report is generated. The only supported value is
         * <code>1</code>.
         * </p>
         * 
         * @param value
         *        Number of times within the frequency period that a report is generated. The only supported value is
         *        <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);

        /**
         * <p>
         * Time period between each report. The period can be daily, weekly, or monthly.
         * </p>
         * 
         * @param period
         *        Time period between each report. The period can be daily, weekly, or monthly.
         * @see ReportFrequencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFrequencyType
         */
        Builder period(String period);

        /**
         * <p>
         * Time period between each report. The period can be daily, weekly, or monthly.
         * </p>
         * 
         * @param period
         *        Time period between each report. The period can be daily, weekly, or monthly.
         * @see ReportFrequencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFrequencyType
         */
        Builder period(ReportFrequencyType period);
    }

    static final class BuilderImpl implements Builder {
        private Integer value;

        private String period;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportFrequency model) {
            value(model.value);
            period(model.period);
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(ReportFrequencyType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        @Override
        public ReportFrequency build() {
            return new ReportFrequency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
