/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for AWS Organizations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConfiguration.Builder, OrganizationConfiguration> {
    private static final SdkField<Boolean> ENABLE_INTEGRATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIntegration").getter(getter(OrganizationConfiguration::enableIntegration))
            .setter(setter(Builder::enableIntegration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIntegration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_INTEGRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableIntegration;

    private OrganizationConfiguration(BuilderImpl builder) {
        this.enableIntegration = builder.enableIntegration;
    }

    /**
     * <p>
     * Enables AWS Organization integration.
     * </p>
     * 
     * @return Enables AWS Organization integration.
     */
    public final Boolean enableIntegration() {
        return enableIntegration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableIntegration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfiguration)) {
            return false;
        }
        OrganizationConfiguration other = (OrganizationConfiguration) obj;
        return Objects.equals(enableIntegration(), other.enableIntegration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationConfiguration").add("EnableIntegration", enableIntegration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableIntegration":
            return Optional.ofNullable(clazz.cast(enableIntegration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfiguration, T> g) {
        return obj -> g.apply((OrganizationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConfiguration> {
        /**
         * <p>
         * Enables AWS Organization integration.
         * </p>
         * 
         * @param enableIntegration
         *        Enables AWS Organization integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIntegration(Boolean enableIntegration);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfiguration model) {
            enableIntegration(model.enableIntegration);
        }

        public final Boolean getEnableIntegration() {
            return enableIntegration;
        }

        public final void setEnableIntegration(Boolean enableIntegration) {
            this.enableIntegration = enableIntegration;
        }

        @Override
        @Transient
        public final Builder enableIntegration(Boolean enableIntegration) {
            this.enableIntegration = enableIntegration;
            return this;
        }

        @Override
        public OrganizationConfiguration build() {
            return new OrganizationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
